/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import gnu.classpath.NotImplementedException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosTicket
implements Destroyable,
Serializable,
Refreshable {
    private static final long serialVersionUID = 7395334370157380539L;
    private static final int FORWARDABLE = 1;
    private static final int FORWARDED = 2;
    private static final int PROXIABLE = 3;
    private static final int PROXY = 4;
    private static final int POSTDATED = 6;
    private static final int RENEWABLE = 8;
    private static final int INITIAL = 9;
    private static final int NUM_FLAGS = 12;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;

    public KerberosTicket(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        this.asn1Encoding = (byte[])byArray.clone();
        this.sessionKey = new KeyImpl(byArray2, n);
        this.flags = new boolean[12];
        if (blArray != null) {
            System.arraycopy(blArray, 0, this.flags, 0, Math.min(blArray.length, 12));
        }
        this.flags = (boolean[])blArray.clone();
        this.authTime = (Date)date.clone();
        this.startTime = (Date)(date2 == null ? date : date2).clone();
        this.endTime = (Date)date3.clone();
        this.renewTill = (Date)date4.clone();
        this.client = kerberosPrincipal;
        this.server = kerberosPrincipal2;
        this.clientAddresses = inetAddressArray == null ? null : (InetAddress[])inetAddressArray.clone();
    }

    public void destroy() throws DestroyFailedException {
        if (this.sessionKey == null) {
            throw new DestroyFailedException("already destroyed");
        }
        this.sessionKey = null;
        this.asn1Encoding = null;
    }

    public boolean isDestroyed() {
        return this.sessionKey == null;
    }

    public boolean isCurrent() {
        long l = System.currentTimeMillis();
        return this.startTime.getTime() <= l && l <= this.endTime.getTime();
    }

    public void refresh() throws RefreshFailedException, NotImplementedException {
        if (!this.isRenewable()) {
            throw new RefreshFailedException("not renewable");
        }
        if (this.renewTill != null && System.currentTimeMillis() >= this.renewTill.getTime()) {
            throw new RefreshFailedException("renewal time elapsed");
        }
        throw new RefreshFailedException("not implemented");
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public final boolean isForwardable() {
        return this.flags[1];
    }

    public final boolean isForwarded() {
        return this.flags[2];
    }

    public final boolean isProxiable() {
        return this.flags[3];
    }

    public final boolean isProxy() {
        return this.flags[4];
    }

    public final boolean isPostdated() {
        return this.flags[6];
    }

    public final boolean isRenewable() {
        return this.flags[8];
    }

    public final boolean isInitial() {
        return this.flags[9];
    }

    public final boolean[] getFlags() {
        return (boolean[])this.flags.clone();
    }

    public final Date getAuthTime() {
        return (Date)this.authTime.clone();
    }

    public final Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    public final Date getEndTime() {
        return (Date)this.endTime.clone();
    }

    public final Date getRenewTill() {
        return this.flags[8] ? (Date)this.renewTill.clone() : null;
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final byte[] getEncoded() {
        this.checkDestroyed();
        return (byte[])this.sessionKey.key.clone();
    }

    public final SecretKey getSessionKey() {
        this.checkDestroyed();
        return this.sessionKey;
    }

    private void checkDestroyed() {
        if (this.sessionKey == null) {
            throw new IllegalStateException("key is destroyed");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[client=" + this.client + ",server=" + this.server + ",sessionKey=" + this.sessionKey + ",flags=" + this.flags + ",authTime=" + this.authTime + ",startTime= " + this.startTime + ",endTime=" + this.endTime + ",renewTill=" + this.renewTill + ",clientAddresses=" + this.clientAddresses + "]";
    }

    public final int getSessionKeyType() {
        return this.sessionKey.type;
    }
}

