/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.SubjectDomainCombiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    private final Set principals;
    private boolean readOnly;
    private final transient SecureSet pubCred;
    private final transient SecureSet privCred;

    public Subject() {
        this.principals = new SecureSet(this, 0);
        this.pubCred = new SecureSet(this, 1);
        this.privCred = new SecureSet(this, 2);
        this.readOnly = false;
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException();
        }
        this.principals = new SecureSet(this, 0, set);
        this.pubCred = new SecureSet(this, 1, set2);
        this.privCred = new SecureSet(this, 2, set3);
        this.readOnly = bl;
    }

    public static Subject getSubject(AccessControlContext accessControlContext) {
        DomainCombiner domainCombiner;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (!((domainCombiner = accessControlContext.getDomainCombiner()) instanceof SubjectDomainCombiner)) {
            return null;
        }
        return ((SubjectDomainCombiner)domainCombiner).getSubject();
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext accessControlContext = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(privilegedAction, accessControlContext);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext accessControlContext = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(privilegedExceptionAction, accessControlContext);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        AccessControlContext accessControlContext2 = new AccessControlContext(accessControlContext, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(privilegedAction, accessControlContext2);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (accessControlContext == null) {
            accessControlContext = new AccessControlContext(new ProtectionDomain[0]);
        }
        AccessControlContext accessControlContext2 = new AccessControlContext(accessControlContext, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(privilegedExceptionAction, accessControlContext2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Subject)) {
            return false;
        }
        Subject subject = (Subject)object;
        return this.principals.containsAll(subject.getPrincipals()) && this.pubCred.containsAll(subject.getPublicCredentials()) && this.privCred.containsAll(subject.getPrivateCredentials());
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        HashSet hashSet = new HashSet(this.principals.size());
        for (Object e : this.principals) {
            if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
            hashSet.add(e);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<Object> getPrivateCredentials() {
        return this.privCred;
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        HashSet hashSet = new HashSet(this.privCred.size());
        for (Object e : this.privCred) {
            if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
            hashSet.add(e);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<Object> getPublicCredentials() {
        return this.pubCred;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        HashSet hashSet = new HashSet(this.pubCred.size());
        for (Object e : this.pubCred) {
            if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
            hashSet.add(e);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public int hashCode() {
        return this.principals.hashCode() + this.privCred.hashCode() + this.pubCred.hashCode();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public String toString() {
        return Subject.class.getName() + " [ principals=" + this.principals + ", private credentials=" + this.privCred + ", public credentials=" + this.pubCred + ", read-only=" + this.readOnly + " ]";
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        static final int PRINCIPALS = 0;
        static final int PUBLIC_CREDENTIALS = 1;
        static final int PRIVATE_CREDENTIALS = 2;
        private final Subject subject;
        private final LinkedList elements;
        private final transient int type;

        SecureSet(Subject subject, int n, Collection collection) {
            this(subject, n);
            for (Object e : collection) {
                if (n == 0 && !(e instanceof Principal)) {
                    throw new IllegalArgumentException(e + " is not a Principal");
                }
                if (this.elements.contains(e)) continue;
                this.elements.add(e);
            }
        }

        SecureSet(Subject subject, int n) {
            this.subject = subject;
            this.type = n;
            this.elements = new LinkedList();
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            return this.elements.iterator();
        }

        public synchronized boolean add(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager securityManager = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (securityManager != null) {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (object instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (securityManager == null) break;
                    securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (securityManager == null) break;
                    securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            if (this.elements.contains(object)) {
                return false;
            }
            return this.elements.add(object);
        }

        public synchronized boolean remove(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager securityManager = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (securityManager != null) {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (object instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (securityManager == null) break;
                    securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (securityManager == null) break;
                    securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            return this.elements.remove(object);
        }

        public synchronized boolean contains(Object object) {
            return this.elements.contains(object);
        }

        public boolean removeAll(Collection collection) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.retainAll(collection);
        }

        public void clear() {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            this.elements.clear();
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }
    }
}

