/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;

public final class SimpleDoc
implements Doc {
    private final Object printData;
    private final DocFlavor flavor;
    private final DocAttributeSet attributes;
    private InputStream stream;
    private Reader reader;

    public SimpleDoc(Object object, DocFlavor docFlavor, DocAttributeSet docAttributeSet) {
        if (object == null || docFlavor == null) {
            throw new IllegalArgumentException("printData/flavor may not be null");
        }
        if (!(object.getClass().getName().equals(docFlavor.getRepresentationClassName()) || docFlavor.getRepresentationClassName().equals("java.io.Reader") && object instanceof Reader || docFlavor.getRepresentationClassName().equals("java.io.InputStream") && object instanceof InputStream)) {
            throw new IllegalArgumentException("data is not of declared flavor type");
        }
        this.printData = object;
        this.flavor = docFlavor;
        this.attributes = docAttributeSet != null ? AttributeSetUtilities.unmodifiableView(docAttributeSet) : null;
        this.stream = null;
        this.reader = null;
    }

    public DocAttributeSet getAttributes() {
        return this.attributes;
    }

    public DocFlavor getDocFlavor() {
        return this.flavor;
    }

    public Object getPrintData() throws IOException {
        return this.printData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReaderForText() throws IOException {
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.reader == null) {
                if (this.flavor instanceof DocFlavor.CHAR_ARRAY) {
                    this.reader = new CharArrayReader((char[])this.printData);
                } else if (this.flavor instanceof DocFlavor.STRING) {
                    this.reader = new StringReader((String)this.printData);
                } else if (this.flavor instanceof DocFlavor.READER) {
                    this.reader = (Reader)this.printData;
                }
            }
            return this.reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStreamForBytes() throws IOException {
        SimpleDoc simpleDoc = this;
        synchronized (simpleDoc) {
            if (this.stream == null) {
                if (this.flavor instanceof DocFlavor.BYTE_ARRAY) {
                    this.stream = new ByteArrayInputStream((byte[])this.printData);
                } else if (this.flavor instanceof DocFlavor.INPUT_STREAM) {
                    this.stream = (InputStream)this.printData;
                }
            }
            return this.stream;
        }
    }
}

