/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import gnu.classpath.ServiceFactory;
import gnu.javax.print.CupsPrintServiceLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;

public abstract class PrintServiceLookup {
    private static final CupsPrintServiceLookup systemProvider = new CupsPrintServiceLookup();
    private static final HashSet printServices = new HashSet();
    private static final HashSet printServiceLookups = new HashSet();

    public static boolean registerServiceProvider(PrintServiceLookup printServiceLookup) {
        return printServiceLookups.add(printServiceLookup);
    }

    public static boolean registerService(PrintService printService) {
        if (printService instanceof StreamPrintService) {
            return false;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
            return printServices.add(printService);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static final PrintService[] lookupPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PrintService[] printServiceArray = systemProvider.getPrintServices(docFlavor, attributeSet);
        arrayList.addAll(Arrays.asList(printServiceArray));
        for (Object object : printServiceLookups) {
            printServiceArray = ((PrintServiceLookup)object).getPrintServices(docFlavor, attributeSet);
            arrayList.addAll(Arrays.asList(printServiceArray));
        }
        for (Object object : printServices) {
            if (!systemProvider.checkPrintService(docFlavor, attributeSet, (PrintService)object)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new PrintService[arrayList.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MultiDocPrintService[] multiDocPrintServiceArray = systemProvider.getMultiDocPrintServices(docFlavorArray, attributeSet);
        arrayList.addAll(Arrays.asList(multiDocPrintServiceArray));
        for (Object object : printServiceLookups) {
            multiDocPrintServiceArray = ((PrintServiceLookup)object).getMultiDocPrintServices(docFlavorArray, attributeSet);
            arrayList.addAll(Arrays.asList(multiDocPrintServiceArray));
        }
        for (Object object : printServices) {
            if (!systemProvider.checkMultiDocPrintService(docFlavorArray, attributeSet, (PrintService)object)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new MultiDocPrintService[arrayList.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        PrintService printService = systemProvider.getDefaultPrintService();
        if (printService != null) {
            return printService;
        }
        Iterator iterator = printServiceLookups.iterator();
        while (iterator.hasNext()) {
            printService = ((PrintServiceLookup)iterator.next()).getDefaultPrintService();
            if (printService == null) continue;
            return printService;
        }
        return null;
    }

    public abstract PrintService getDefaultPrintService();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);

    static {
        Iterator<PrintServiceLookup> iterator = ServiceFactory.lookupProviders(PrintServiceLookup.class);
        while (iterator.hasNext()) {
            printServiceLookups.add(iterator.next());
        }
    }
}

