/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactory {
    private static final String TRUST_MANAGER_FACTORY = "TrustManagerFactory";
    private static final String DEFAULT_ALGORITHM = "JessieX509";
    private final TrustManagerFactorySpi tmfSpi;
    private final Provider provider;
    private final String algorithm;

    protected TrustManagerFactory(TrustManagerFactorySpi trustManagerFactorySpi, Provider provider, String string) {
        this.tmfSpi = trustManagerFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final TrustManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return TrustManagerFactory.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static final TrustManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return TrustManagerFactory.getInstance(string, provider);
    }

    public static final TrustManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        StringBuilder stringBuilder = new StringBuilder("TrustManagerFactory algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(TRUST_MANAGER_FACTORY, string, provider);
            return new TrustManagerFactory((TrustManagerFactorySpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(stringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public static final String getDefaultAlgorithm() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            string = DEFAULT_ALGORITHM;
        }
        return string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final TrustManager[] getTrustManagers() {
        return this.tmfSpi.engineGetTrustManagers();
    }

    public final void init(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.tmfSpi.engineInit(managerFactoryParameters);
    }

    public final void init(KeyStore keyStore) throws KeyStoreException {
        this.tmfSpi.engineInit(keyStore);
    }
}

