/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLContext context;

    protected SSLServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        try {
            keyManagerArray = Security.getProperty("ssl.ServerSocketFactory.provider");
            trustManagerArray = ClassLoader.getSystemClassLoader();
            if (keyManagerArray != null && trustManagerArray != null) {
                return (ServerSocketFactory)trustManagerArray.loadClass((String)keyManagerArray).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context == null) {
            Object object;
            keyManagerArray = null;
            trustManagerArray = null;
            String string = KeyManagerFactory.getDefaultAlgorithm();
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            try {
                object = KeyManagerFactory.getInstance(string);
                ((KeyManagerFactory)object).init(null, null);
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = TrustManagerFactory.getInstance(string2);
                ((TrustManagerFactory)object).init((KeyStore)null);
                trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(keyManagerArray, trustManagerArray, null);
            }
            catch (Exception exception) {
                return new ErrorServerSocketFactory(new RuntimeException("error instantiating default server socket factory: " + exception.toString(), exception));
            }
        }
        try {
            return context.getServerSocketFactory();
        }
        catch (Exception exception) {
            return new ErrorServerSocketFactory(new RuntimeException("no SSLSocketFactory implementation available"));
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    private static final class ErrorServerSocketFactory
    extends SSLServerSocketFactory {
        private RuntimeException x;

        ErrorServerSocketFactory(RuntimeException runtimeException) {
            this.x = runtimeException;
        }

        public ServerSocket createServerSocket() throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int n) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int n, int n2) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public String[] getDefaultCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public String[] getSupportedCipherSuites() {
            throw new RuntimeException(this.x);
        }
    }
}

