/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import gnu.classpath.VMStackWalker;
import gnu.java.lang.CPStringBuilder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    private static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;

    NamingManager() {
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return icfb != null;
    }

    public static Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        InitialContextFactory initialContextFactory = null;
        if (icfb != null) {
            initialContextFactory = icfb.createInitialContextFactory(hashtable);
        } else {
            String string = null;
            if (hashtable != null) {
                string = (String)hashtable.get("java.naming.factory.initial");
            }
            if (string == null) {
                string = System.getProperty("java.naming.factory.initial");
            }
            if (string == null) {
                throw new NoInitialContextException("Can't find property: java.naming.factory.initial");
            }
            try {
                initialContextFactory = (InitialContextFactory)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception exception) {
                NoInitialContextException noInitialContextException = new NoInitialContextException("Can't load InitialContextFactory class: " + string);
                noInitialContextException.setRootCause(exception);
                throw noInitialContextException;
            }
        }
        return initialContextFactory.getInitialContext(hashtable);
    }

    static Context getURLContext(Object object, Name name, Context context, String string, Hashtable<?, ?> hashtable) throws NamingException {
        String string2;
        String string3 = "gnu.javax.naming.jndi.url";
        String string4 = "com.sun.jndi.url";
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        if (hashtable != null && (string2 = (String)hashtable.get("java.naming.factory.url.pkgs")) != null) {
            cPStringBuilder.append(string2);
        }
        if ((string2 = System.getProperty("java.naming.factory.url.pkgs")) != null) {
            if (cPStringBuilder.length() > 0) {
                cPStringBuilder.append(':');
            }
            cPStringBuilder.append(string2);
        }
        if (cPStringBuilder.length() > 0) {
            cPStringBuilder.append(':');
        }
        cPStringBuilder.append(string3);
        cPStringBuilder.append(':');
        cPStringBuilder.append(string4);
        string = string + "." + string + "URLContextFactory";
        StringTokenizer stringTokenizer = new StringTokenizer(cPStringBuilder.toString(), ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            try {
                String string6 = string5 + "." + string;
                Class clazz = NamingManager.forName(string6);
                if (clazz == null) continue;
                try {
                    ObjectFactory objectFactory = (ObjectFactory)clazz.newInstance();
                    Object object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
                    Context context2 = (Context)object2;
                    if (context2 == null) continue;
                    return context2;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    static Class forName(String string) {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class[] classArray = VMStackWalker.getClassContext();
            for (int i = 0; i < classArray.length; ++i) {
                ClassLoader classLoader = classArray[i].getClassLoader();
                try {
                    if (classLoader == null) continue;
                    return Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static Context getURLContext(String string, Hashtable<?, ?> hashtable) throws NamingException {
        return NamingManager.getURLContext(null, null, null, string, hashtable);
    }

    public static void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws NamingException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (ofb != null) {
            throw new IllegalStateException("object factory builder already installed");
        }
        if (objectFactoryBuilder != null) {
            ofb = objectFactoryBuilder;
        }
    }

    static StringTokenizer getPlusPath(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = (String)hashtable.get(string);
        if (context == null) {
            context = NamingManager.getInitialContext(hashtable);
        }
        String string3 = (String)context.getEnvironment().get(string);
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null) {
            string2 = string2 + ":" + string3;
        }
        return new StringTokenizer(string2 != null ? string2 : "", ":");
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Object object2;
        ObjectFactory objectFactory = null;
        if (ofb != null) {
            objectFactory = ofb.createObjectFactory(object, hashtable);
        } else {
            Object object3;
            Class<?> clazz;
            String string;
            Object object4;
            object2 = object;
            if (object instanceof Referenceable) {
                object2 = ((Referenceable)object).getReference();
            }
            if (object2 instanceof Reference) {
                object4 = (Reference)object2;
                string = ((Reference)object4).getFactoryClassName();
                if (string != null) {
                    clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    objectFactory = (ObjectFactory)clazz.newInstance();
                } else {
                    clazz = ((Reference)object4).getAll();
                    while (clazz.hasMoreElements()) {
                        Object object5;
                        object3 = (RefAddr)clazz.nextElement();
                        if (!(object3 instanceof StringRefAddr) || !"URL".equals(((RefAddr)object3).getType()) || (object5 = (objectFactory = (ObjectFactory)((Object)NamingManager.getURLContext(object, name, context, (String)((RefAddr)object3).getContent(), hashtable))).getObjectInstance(object, name, context, hashtable)) == null) continue;
                        return object5;
                    }
                    objectFactory = null;
                }
            }
            if (objectFactory == null) {
                object4 = NamingManager.getPlusPath("java.naming.factory.object", hashtable, context);
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    string = ((StringTokenizer)object4).nextToken();
                    clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    objectFactory = (ObjectFactory)clazz.newInstance();
                    object3 = objectFactory.getObjectInstance(object, name, context, hashtable);
                    if (object3 == null) continue;
                    return object3;
                }
                return object;
            }
        }
        if (objectFactory == null) {
            return object;
        }
        object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        return object2 == null ? object : object2;
    }

    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws NamingException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (icfb != null) {
            throw new IllegalStateException("ctx factory builder already installed");
        }
        if (initialContextFactoryBuilder != null) {
            icfb = initialContextFactoryBuilder;
        }
    }

    public static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        Hashtable<?, ?> hashtable = cannotProceedException.getEnvironment();
        if (hashtable != null) {
            hashtable.put(CPE, cannotProceedException);
        }
        try {
            Object object = NamingManager.getObjectInstance(cannotProceedException.getResolvedObj(), cannotProceedException.getAltName(), cannotProceedException.getAltNameCtx(), hashtable);
            if (object != null) {
                return (Context)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cannotProceedException.fillInStackTrace();
        throw cannotProceedException;
    }

    public static Object getStateToBind(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        StringTokenizer stringTokenizer = NamingManager.getPlusPath("java.naming.factory.state", hashtable, context);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                StateFactory stateFactory = (StateFactory)clazz.newInstance();
                Object object2 = stateFactory.getStateToBind(object, name, context, hashtable);
                if (object2 == null) continue;
                return object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return object;
    }
}

