/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1673475790065791735L;
    protected Vector<RefAddr> addrs;
    protected String classFactory;
    protected String classFactoryLocation;
    protected String className;

    public Reference(String string) {
        this.className = string;
        this.addrs = new Vector();
    }

    public Reference(String string, RefAddr refAddr) {
        this.className = string;
        this.addrs = new Vector();
        this.addrs.add(refAddr);
    }

    public Reference(String string, String string2, String string3) {
        this.className = string;
        this.classFactory = string2;
        this.classFactoryLocation = string3;
        this.addrs = new Vector();
    }

    public Reference(String string, RefAddr refAddr, String string2, String string3) {
        this.className = string;
        this.classFactory = string2;
        this.classFactoryLocation = string3;
        this.addrs = new Vector();
        this.addrs.add(refAddr);
    }

    public void add(int n, RefAddr refAddr) {
        this.addrs.add(n, refAddr);
    }

    public void add(RefAddr refAddr) {
        this.addrs.add(refAddr);
    }

    public void clear() {
        this.addrs.clear();
    }

    public Object clone() {
        Reference reference = new Reference(this.className, this.classFactory, this.classFactoryLocation);
        reference.addrs = (Vector)this.addrs.clone();
        return reference;
    }

    private boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        Reference reference = (Reference)object;
        return this.equals(this.classFactory, reference.classFactory) && this.equals(this.classFactoryLocation, reference.classFactoryLocation) && this.equals(this.className, reference.className) && this.addrs.equals(reference.addrs);
    }

    public RefAddr get(int n) {
        return this.addrs.get(n);
    }

    public RefAddr get(String string) {
        for (int i = 0; i < this.addrs.size(); ++i) {
            RefAddr refAddr = this.addrs.get(i);
            if (!string.equals(refAddr.getType())) continue;
            return refAddr;
        }
        return null;
    }

    public Enumeration<RefAddr> getAll() {
        return this.addrs.elements();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.addrs.size(); ++i) {
            n += this.addrs.get(i).hashCode();
        }
        return n;
    }

    public Object remove(int n) {
        return this.addrs.remove(n);
    }

    public int size() {
        return this.addrs.size();
    }

    public String toString() {
        String string = this.getClass().toString() + "[";
        for (int i = 0; i < this.addrs.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.addrs.get(i).toString();
        }
        return string + "]";
    }
}

