/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBeanOperationInfoSupport
extends MBeanOperationInfo
implements OpenMBeanOperationInfo {
    private static final long serialVersionUID = 4996859732565369366L;
    private OpenType<?> returnOpenType;
    private transient Integer hashCode;
    private transient String string;

    public OpenMBeanOperationInfoSupport(String string, String string2, OpenMBeanParameterInfo[] openMBeanParameterInfoArray, OpenType<?> openType, int n) {
        super(string, string2, (MBeanParameterInfo[])openMBeanParameterInfoArray, openType == null ? null : openType.getClassName(), n);
        if (string == null) {
            throw new IllegalArgumentException("The name may not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The description may not be null.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The name may not be the empty string.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("The description may not be the empty string.");
        }
        if (n != 1 && n != 0 && n != 2 && n != 3) {
            throw new IllegalArgumentException("The impact factor is an invalid value.");
        }
        this.returnOpenType = openType;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OpenMBeanOperationInfo)) {
            return false;
        }
        OpenMBeanOperationInfo openMBeanOperationInfo = (OpenMBeanOperationInfo)object;
        return this.getName().equals(openMBeanOperationInfo.getName()) && this.getSignature().equals(openMBeanOperationInfo.getSignature()) && this.returnOpenType.equals(openMBeanOperationInfo.getReturnOpenType()) && this.getImpact() == openMBeanOperationInfo.getImpact();
    }

    @Override
    public OpenType<?> getReturnOpenType() {
        return this.returnOpenType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getName().hashCode() + this.returnOpenType.hashCode() + Integer.valueOf(this.getImpact()).hashCode() + Arrays.asList(this.getSignature()).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            String string;
            switch (this.getImpact()) {
                case 0: {
                    string = "INFO";
                    break;
                }
                case 1: {
                    string = "ACTION";
                    break;
                }
                case 2: {
                    string = "ACTION_INFO";
                    break;
                }
                case 3: {
                    string = "UNKNOWN";
                    break;
                }
                default: {
                    string = "ERRONEOUS VALUE";
                }
            }
            this.string = this.getClass().getName() + "[name=" + this.getName() + ",signature=" + Arrays.toString(this.getSignature()) + ",returnOpenType=" + this.returnOpenType + ",impact=" + string + "]";
        }
        return this.string;
    }
}

