/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends OpenType<CompositeData> {
    private static final long serialVersionUID = -5366242454346948798L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, OpenType<?>> nameToType;
    private transient Integer hashCode;
    private transient String string;

    public CompositeType(String string, String string2, String[] stringArray, String[] stringArray2, OpenType<?>[] openTypeArray) throws OpenDataException {
        super(CompositeData.class.getName(), string, string2);
        int n;
        if (stringArray.length == 0 || stringArray.length != stringArray2.length || stringArray.length != openTypeArray.length) {
            throw new IllegalArgumentException("Arrays must be non-empty and of equal size.");
        }
        this.nameToDescription = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("Name " + n + " is null.");
            }
            if (stringArray2[n] == null) {
                throw new IllegalArgumentException("Description " + n + " is null.");
            }
            String string3 = stringArray[n].trim();
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Name " + n + " is " + "the empty string.");
            }
            if (stringArray2[n].length() == 0) {
                throw new IllegalArgumentException("Description " + n + " is " + "the empty string.");
            }
            if (this.nameToDescription.containsKey(string3)) {
                throw new OpenDataException(string3 + " appears more " + "than once.");
            }
            this.nameToDescription.put(string3, stringArray2[n]);
        }
        this.nameToType = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            this.nameToType.put(stringArray[n].trim(), openTypeArray[n]);
        }
    }

    public boolean containsKey(String string) {
        return this.nameToDescription.containsKey(string);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CompositeType)) {
            return false;
        }
        CompositeType compositeType = (CompositeType)object;
        if (!compositeType.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        Set<String> set = this.keySet();
        if (!compositeType.keySet().equals(set)) {
            return false;
        }
        for (String string : set) {
            if (compositeType.getType(string).equals(this.getType(string))) continue;
            return false;
        }
        return true;
    }

    public String getDescription(String string) {
        return this.nameToDescription.get(string);
    }

    public OpenType<?> getType(String string) {
        return this.nameToType.get(string);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int n = 0;
            for (Map.Entry<String, OpenType<?>> entry : this.nameToType.entrySet()) {
                n += entry.getKey().hashCode() + entry.getValue().hashCode();
            }
            this.hashCode = n + this.getTypeName().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isValue(Object object) {
        if (object instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)object;
            return this.equals(compositeData.getCompositeType());
        }
        return false;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getTypeName() + ", fields=" + this.nameToType + "]";
        }
        return this.string;
    }
}

