/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataSupport
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 8003518976613702244L;
    private SortedMap<String, Object> contents;
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, Map<String, ?> map) throws OpenDataException {
        this(compositeType, map.keySet().toArray(new String[map.size()]), map.values().toArray());
    }

    public CompositeDataSupport(CompositeType compositeType, String[] stringArray, Object[] objectArray) throws OpenDataException {
        if (compositeType == null) {
            throw new IllegalArgumentException("The given composite type is null.");
        }
        this.compositeType = compositeType;
        if (stringArray == null) {
            throw new IllegalArgumentException("The names array is null.");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("The values array is null.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("The sizes of the arrays differ.");
        }
        Set<String> set = compositeType.keySet();
        if (set.size() != stringArray.length) {
            throw new OpenDataException("The number of field names does not match the type description.");
        }
        this.contents = new TreeMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException("Element " + i + " of the names " + "array is null.");
            }
            if (stringArray[i].length() == 0) {
                throw new IllegalArgumentException("Element " + i + " of the names " + "array is an empty string.");
            }
            if (objectArray[i] == null) {
                throw new IllegalArgumentException("Element " + i + " of the values " + "array is null.");
            }
            if (!set.contains(stringArray[i])) {
                throw new OpenDataException("The name, " + stringArray[i] + ", is not a " + "field in the given type description.");
            }
            if (!compositeType.getType(stringArray[i]).isValue(objectArray[i])) {
                throw new OpenDataException("The value, " + objectArray[i] + ", is not a " + "valid value for the " + stringArray[i] + " field.");
            }
            this.contents.put(stringArray[i], objectArray[i]);
        }
    }

    @Override
    public boolean containsKey(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.contents.containsKey(string);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contents.containsValue(object);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        if (!compositeData.getCompositeType().equals(this.compositeType)) {
            return false;
        }
        for (String string : this.contents.keySet()) {
            if (!compositeData.containsKey(string)) {
                return false;
            }
            if (compositeData.get(string).equals(this.contents.get(string))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The supplied key is null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The supplied key is the empty string.");
        }
        if (!this.contents.containsKey(string)) {
            throw new InvalidKeyException("The supplied key does not exist.");
        }
        return this.contents.get(string);
    }

    @Override
    public Object[] getAll(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public int hashCode() {
        int n = this.compositeType.hashCode();
        for (Object v : this.contents.values()) {
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[compositeType=" + this.compositeType + ",contents=" + this.contents + "]";
    }

    @Override
    public Collection<?> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }
}

