/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectName
implements Serializable,
QueryExp {
    private static final long serialVersionUID = 1081892073854801359L;
    public static final ObjectName WILDCARD;
    private transient String domain;
    private transient TreeMap<String, String> properties;
    private transient String propertyListString;
    private transient boolean propertyListPattern;
    private transient boolean propertyValuePattern;
    private transient MBeanServer server;

    public ObjectName(String string) throws MalformedObjectNameException {
        if (string.length() == 0) {
            string = "*:*";
        }
        this.parse(string);
    }

    private void parse(String string) throws MalformedObjectNameException {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new MalformedObjectNameException("No domain separator was found.");
        }
        this.domain = string.substring(0, n);
        String string2 = string.substring(n + 1);
        this.properties = new TreeMap();
        String[] stringArray = string2.split(",");
        if (stringArray.length == 0 && !this.isPattern()) {
            throw new MalformedObjectNameException("A name that is not a pattern must contain at least one key-value pair.");
        }
        this.propertyListString = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("*")) {
                if (this.propertyListPattern) {
                    throw new MalformedObjectNameException("Multiple wildcards in properties.");
                }
                this.propertyListPattern = true;
                continue;
            }
            int n2 = stringArray[i].indexOf(61);
            if (n2 == -1) {
                throw new MalformedObjectNameException("A key must be followed by a value.");
            }
            String string3 = stringArray[i].substring(0, n2);
            if (this.properties.containsKey(string3)) {
                throw new MalformedObjectNameException("The same key occurs more than once.");
            }
            String string4 = stringArray[i].substring(n2 + 1);
            this.properties.put(string3, string4);
            this.propertyListString = this.propertyListString + string3 + "=" + string4 + ",";
        }
        if (this.propertyListString.length() > 0) {
            this.propertyListString = this.propertyListString.substring(0, this.propertyListString.length() - 1);
        }
        this.checkComponents();
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        this.domain = string;
        this.properties = new TreeMap();
        this.properties.put(string2, string3);
        this.checkComponents();
    }

    public ObjectName(String string, Hashtable<String, String> hashtable) throws MalformedObjectNameException {
        this.domain = string;
        this.properties = new TreeMap();
        this.properties.putAll(hashtable);
        this.checkComponents();
    }

    private void checkComponents() throws MalformedObjectNameException {
        if (this.domain.indexOf(58) != -1) {
            throw new MalformedObjectNameException("The domain includes a ':' character.");
        }
        if (this.domain.indexOf(10) != -1) {
            throw new MalformedObjectNameException("The domain includes a newline character.");
        }
        char[] cArray = new char[]{'\n', ':', ',', '*', '?', '='};
        char[] cArray2 = new char[]{'\n', ':', ',', '='};
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            for (int i = 0; i < cArray.length; ++i) {
                if (entry.getKey().indexOf(cArray[i]) == -1) continue;
                throw new MalformedObjectNameException("A key contains a '" + cArray[i] + "' " + "character.");
            }
            String string = entry.getValue();
            int n = string.indexOf(34);
            if (n == 0) {
                try {
                    ObjectName.unquote(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw (MalformedObjectNameException)new MalformedObjectNameException("The quoted value is invalid.").initCause(illegalArgumentException);
                }
            } else {
                if (n != -1) {
                    throw new MalformedObjectNameException("A value contains a '\"' character.");
                }
                for (int i = 0; i < cArray2.length; ++i) {
                    if (string.indexOf(cArray2[i]) == -1) continue;
                    throw new MalformedObjectNameException("A value contains a '" + cArray2[i] + "' " + "character.");
                }
            }
            if (string.indexOf(42) == -1 && string.indexOf(63) == -1) continue;
            this.propertyValuePattern = true;
        }
    }

    @Override
    public boolean apply(ObjectName objectName) {
        if (objectName.isPattern()) {
            return false;
        }
        if (!this.isPattern()) {
            return this.equals(objectName);
        }
        if (this.isDomainPattern() ? !ObjectName.domainMatches(this.domain, 0, objectName.getDomain(), 0) : !this.domain.equals(objectName.getDomain())) {
            return false;
        }
        if (this.isPropertyPattern()) {
            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String string = entry.getKey();
                if (!hashtable.containsKey(string)) {
                    return false;
                }
                String string2 = entry.getValue();
                if (string2.equals(hashtable.get(string))) continue;
                return false;
            }
        } else if (!this.getCanonicalKeyPropertyListString().equals(objectName.getCanonicalKeyPropertyListString())) {
            return false;
        }
        return true;
    }

    private static boolean domainMatches(String string, int n, String string2, int n2) {
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '*') {
                for (int i = string2.length(); i >= n2; --i) {
                    if (!ObjectName.domainMatches(string, n, string2, i)) continue;
                    return true;
                }
                return false;
            }
            if (n2 >= string2.length()) {
                return false;
            }
            if (c != '?' && c != string2.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectName) {
            ObjectName objectName = (ObjectName)object;
            return this.getCanonicalName().equals(objectName.getCanonicalName());
        }
        return false;
    }

    public String getCanonicalKeyPropertyListString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            cPStringBuilder.append(entry.getKey() + "=" + entry.getValue());
            if (!iterator.hasNext()) continue;
            cPStringBuilder.append(",");
        }
        return cPStringBuilder.toString();
    }

    public String getCanonicalName() {
        return this.domain + ":" + this.getCanonicalKeyPropertyListString() + (this.isPropertyPattern() ? (this.properties.isEmpty() ? "*" : ",*") : "");
    }

    public String getDomain() {
        return this.domain;
    }

    public static ObjectName getInstance(ObjectName objectName) {
        try {
            return new ObjectName(objectName.getCanonicalName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw (InternalError)new InternalError("The canonical name of the given name is invalid.").initCause(malformedObjectNameException);
        }
    }

    public static ObjectName getInstance(String string) throws MalformedObjectNameException {
        return new ObjectName(string);
    }

    public static ObjectName getInstance(String string, String string2, String string3) throws MalformedObjectNameException {
        return new ObjectName(string, string2, string3);
    }

    public static ObjectName getInstance(String string, Hashtable<String, String> hashtable) throws MalformedObjectNameException {
        return new ObjectName(string, hashtable);
    }

    public String getKeyProperty(String string) {
        if (string == null) {
            throw new NullPointerException("Null key given in request for a value.");
        }
        return this.properties.get(string);
    }

    public Hashtable<String, String> getKeyPropertyList() {
        return new Hashtable<String, String>(this.properties);
    }

    public String getKeyPropertyListString() {
        if (this.propertyListString != null) {
            return this.propertyListString;
        }
        return this.getCanonicalKeyPropertyListString();
    }

    public int hashCode() {
        return this.domain.hashCode() + this.properties.hashCode();
    }

    public boolean isDomainPattern() {
        return this.domain.contains("?") || this.domain.contains("*");
    }

    public boolean isPattern() {
        return this.isDomainPattern() || this.isPropertyPattern();
    }

    public boolean isPropertyPattern() {
        return this.propertyListPattern || this.propertyValuePattern;
    }

    public boolean isPropertyListPattern() {
        return this.propertyListPattern;
    }

    public boolean isPropertyValuePattern() {
        return this.propertyValuePattern;
    }

    public boolean isPropertyValuePattern(String string) {
        String string2 = this.getKeyProperty(string);
        if (string2 == null) {
            throw new IllegalArgumentException(string + " is not a valid property.");
        }
        return string2.indexOf(63) != -1 || string2.indexOf(42) != -1;
    }

    public static String quote(String string) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append('\"');
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    cPStringBuilder.append("\\\"");
                    continue block7;
                }
                case '*': {
                    cPStringBuilder.append("\\*");
                    continue block7;
                }
                case '?': {
                    cPStringBuilder.append("\\?");
                    continue block7;
                }
                case '\\': {
                    cPStringBuilder.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    cPStringBuilder.append("\\\n");
                    continue block7;
                }
                default: {
                    cPStringBuilder.append(c);
                }
            }
        }
        cPStringBuilder.append('\"');
        return cPStringBuilder.toString();
    }

    @Override
    public void setMBeanServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getDomain());
        cPStringBuilder.append(':');
        String string = this.getKeyPropertyListString();
        cPStringBuilder.append(string);
        if (this.isPropertyPattern()) {
            if (string.length() == 0) {
                cPStringBuilder.append("*");
            } else {
                cPStringBuilder.append(",*");
            }
        }
        objectOutputStream.writeObject(cPStringBuilder.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        try {
            this.parse(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InvalidObjectException(malformedObjectNameException.toString());
        }
    }

    public static String unquote(String string) {
        if (string.charAt(0) != '\"') {
            throw new IllegalArgumentException("The string does not start with a quote.");
        }
        if (string.charAt(string.length() - 1) != '\"') {
            throw new IllegalArgumentException("The string does not end with a quote.");
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if ((c = string.charAt(++i)) != '\"' && c != '?' && c != '*' && c != 'n' && c != '\\') {
                    throw new IllegalArgumentException("Illegal escaped character: " + c);
                }
            } else if (c == '\"' || c == '\n') {
                throw new IllegalArgumentException("Illegal character: " + c);
            }
            cPStringBuilder.append(c);
        }
        return cPStringBuilder.toString();
    }

    static {
        try {
            WILDCARD = new ObjectName("");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw (InternalError)new InternalError("A problem occurred initializing the ObjectName wildcard.").initCause(malformedObjectNameException);
        }
    }
}

