/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;

    public MBeanServerPermission(String string) {
        this(string, null);
    }

    public MBeanServerPermission(String string, String string2) {
        super(MBeanServerPermission.checkName(string), string2);
        if (string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException("The supplied action list was not equal to null or the empty string.");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MBeanServerPermission) {
            MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)object;
            return mBeanServerPermission.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof MBeanServerPermission) {
            if (this.getName().equals("*")) {
                return true;
            }
            MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)permission;
            String[] stringArray = this.getName().split(",");
            String[] stringArray2 = mBeanServerPermission.getName().split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                boolean bl = false;
                String string = stringArray2[i].trim();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string2 = stringArray[j].trim();
                    if (string2.equals(string)) {
                        bl = true;
                    }
                    if (!string2.equals("createMBeanServer") || !string.equals("newMBeanServer")) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }

    private static String checkName(String string) {
        if (!string.equals("*")) {
            String[] stringArray = string.split(",");
            string = "";
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (!(string2.equals("createMBeanServer") || string2.equals("findMBeanServer") || string2.equals("newMBeanServer") || string2.equals("releaseMBeanServer"))) {
                    throw new IllegalArgumentException("An invalid constraint, " + string2 + ", was specified.");
                }
                if (string2.equals("newMBeanServer")) {
                    bl2 = true;
                    continue;
                }
                if (string2.equals("createMBeanServer")) {
                    bl = true;
                    continue;
                }
                if (!bl3) {
                    string = string + ",";
                }
                string = string + string2;
                bl3 = false;
            }
            if (bl2 && !bl) {
                string = string + (bl3 ? "" : ",") + "newMBeanServer";
            } else if (bl) {
                string = string + (bl3 ? "" : ",") + "createMBeanServer";
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MBeanServerPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -5661980843569388590L;
        private MBeanServerPermission collectionPermission;

        private MBeanServerPermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("This collection is read only.");
            }
            if (permission instanceof MBeanServerPermission) {
                MBeanServerPermission mBeanServerPermission = (MBeanServerPermission)permission;
                if (this.collectionPermission == null) {
                    this.collectionPermission = mBeanServerPermission;
                } else {
                    String string = this.collectionPermission.getName();
                    String[] stringArray = string.split(",");
                    String[] stringArray2 = mBeanServerPermission.getName().split(",");
                    int n = string.indexOf("createMBeanServer");
                    int n2 = string.indexOf("newMBeanServer");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        boolean bl = false;
                        String string2 = stringArray2[i].trim();
                        for (int j = 0; j < stringArray.length; ++j) {
                            String string3 = stringArray[j].trim();
                            if (string3.equals(string2)) {
                                bl = true;
                            }
                            if (string2.equals("newMBeanServer") && n != -1) {
                                bl = true;
                            }
                            if (!string2.equals("createMBeanServer") || n2 == -1) continue;
                            string = string.replace("newMBeanServer", "createMBeanServer");
                        }
                        if (bl) continue;
                        string = string + "," + string2;
                    }
                    this.collectionPermission = new MBeanServerPermission(string);
                }
            }
        }

        @Override
        public Enumeration<Permission> elements() {
            return new MBeanServerPermissionEnumeration(this.collectionPermission);
        }

        @Override
        public boolean implies(Permission permission) {
            return this.collectionPermission.implies(permission);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MBeanServerPermissionEnumeration
        implements Enumeration<Permission> {
            private MBeanServerPermission p;
            private boolean done;

            public MBeanServerPermissionEnumeration(MBeanServerPermission mBeanServerPermission) {
                this.p = mBeanServerPermission;
                this.done = false;
            }

            @Override
            public boolean hasMoreElements() {
                return !this.done;
            }

            @Override
            public Permission nextElement() {
                if (this.hasMoreElements()) {
                    this.done = true;
                    return this.p;
                }
                throw new NoSuchElementException("No more elements are available.");
            }
        }
    }
}

