/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.javax.management.Translator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerInvocationHandler
implements InvocationHandler {
    private MBeanServerConnection conn;
    private ObjectName name;
    private boolean mxBean;
    private Class<?> iface;

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this(mBeanServerConnection, objectName, false);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName, boolean bl) {
        this.conn = mBeanServerConnection;
        this.name = objectName;
        this.mxBean = bl;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.conn;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String[] stringArray;
        String string = method.getName();
        Class<? extends Object> clazz = object.getClass();
        if (string.equals("toString")) {
            if (this.inInterface(string, clazz, new Class[0])) {
                return this.conn.invoke(this.name, string, null, null);
            }
            return clazz.getName() + "[name=" + this.name + ", conn=" + this.conn + "]";
        }
        if (string.equals("hashCode")) {
            if (this.inInterface(string, clazz, new Class[0])) {
                return this.conn.invoke(this.name, string, null, null);
            }
            return this.conn.hashCode() + this.name.hashCode() + (this.iface == null ? 0 : this.iface.hashCode());
        }
        if (string.equals("equals")) {
            if (this.inInterface(string, clazz, Object.class)) {
                return this.conn.invoke(this.name, string, new Object[]{objectArray[0]}, new String[]{"java.lang.Object"});
            }
            if (objectArray[0].getClass() != object.getClass()) {
                return false;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(objectArray[0]);
            if (invocationHandler instanceof MBeanServerInvocationHandler) {
                MBeanServerInvocationHandler mBeanServerInvocationHandler = (MBeanServerInvocationHandler)invocationHandler;
                return this.conn.equals(mBeanServerInvocationHandler.getMBeanServerConnection()) && this.name.equals(mBeanServerInvocationHandler.getObjectName()) && (this.iface == null ? mBeanServerInvocationHandler.iface == null : this.iface.equals(mBeanServerInvocationHandler.iface));
            }
            return false;
        }
        if (NotificationEmitter.class.isAssignableFrom(clazz)) {
            if (string.equals("addNotificationListener")) {
                this.conn.addNotificationListener(this.name, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            }
            if (string.equals("getNotificationInfo")) {
                return this.conn.getMBeanInfo(this.name).getNotifications();
            }
            if (string.equals("removeNotificationListener")) {
                if (objectArray.length == 1) {
                    this.conn.removeNotificationListener(this.name, (NotificationListener)objectArray[0]);
                } else {
                    this.conn.removeNotificationListener(this.name, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                }
                return null;
            }
        }
        if (objectArray == null) {
            stringArray = null;
        } else {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i].getClass().getName();
            }
        }
        String string2 = null;
        if (string.startsWith("get")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is")) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            Object object2 = this.conn.getAttribute(this.name, string2);
            if (this.mxBean) {
                return Translator.toJava(object2, method);
            }
            return object2;
        }
        if (string.startsWith("set")) {
            Object object3 = this.mxBean ? Translator.fromJava(objectArray, method)[0] : objectArray[0];
            this.conn.setAttribute(this.name, new Attribute(string.substring(3), object3));
            return null;
        }
        if (this.mxBean) {
            return Translator.toJava(this.conn.invoke(this.name, string, Translator.fromJava(objectArray, method), stringArray), method);
        }
        return this.conn.invoke(this.name, string, objectArray, stringArray);
    }

    public boolean isMXBean() {
        return this.mxBean;
    }

    public static <T> T newProxyInstance(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        if (bl) {
            return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, NotificationEmitter.class}, new MBeanServerInvocationHandler(mBeanServerConnection, objectName));
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new MBeanServerInvocationHandler(mBeanServerConnection, objectName));
    }

    private boolean inInterface(String string, Class<?> clazz, Class<?> ... classArray) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            try {
                clazz2.getMethod(string, classArray);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return false;
    }
}

