/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.classpath.SystemProperties;
import gnu.javax.management.ListenerData;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private String id;
    private final List<ListenerData> listeners = new ArrayList<ListenerData>();
    private long seqNo;

    public MBeanServerDelegate() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "Unknown host";
        }
        this.id = string + "_" + new Date().getTime();
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException("A null listener was supplied.");
        }
        this.listeners.add(new ListenerData(notificationListener, notificationFilter, object));
    }

    public String getImplementationName() {
        return "GNU JMX";
    }

    public String getImplementationVendor() {
        return "The GNU Classpath Project";
    }

    public String getImplementationVersion() {
        return SystemProperties.getProperty("gnu.classpath.version");
    }

    public String getMBeanServerId() {
        return this.id;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"}, MBeanServerNotification.class.getName(), "Server registration notifications")};
    }

    public String getSpecificationName() {
        return "JMX";
    }

    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    public String getSpecificationVersion() {
        return "1.2";
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Iterator<ListenerData> iterator = this.listeners.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (iterator.next().getListener() != notificationListener) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(notificationListener, notificationFilter, object))) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + " with filter " + notificationFilter + "and passback " + object + ", is not registered with this bean.");
        }
    }

    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() <= 0L) {
            notification.setSequenceNumber(++this.seqNo);
        }
        for (ListenerData listenerData : this.listeners) {
            NotificationFilter notificationFilter = listenerData.getFilter();
            if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
            listenerData.getListener().handleNotification(notification, listenerData.getPassback());
        }
    }
}

