/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MXBean;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMX {
    public static final String DEFAULT_VALUE_FIELD = "defaultValue";
    public static final String IMMUTABLE_INFO_FIELD = "immutableInfo";
    public static final String INTERFACE_CLASS_NAME_FIELD = "interfaceClassName";
    public static final String LEGAL_VALUES_FIELD = "legalValues";
    public static final String MAX_VALUE_FIELD = "maxValue";
    public static final String MIN_VALUE_FIELD = "minValue";
    public static final String MXBEAN_FIELD = "mxbean";
    public static final String OPEN_TYPE_FIELD = "openType";
    public static final String ORIGINAL_TYPE_FIELD = "originalType";

    private JMX() {
    }

    public static boolean isMXBeanInterface(Class<?> clazz) {
        MXBean mXBean = clazz.getAnnotation(MXBean.class);
        if (mXBean != null) {
            return mXBean.value();
        }
        return clazz.getName().endsWith("MXBean");
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        return MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName, clazz, bl);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        if (bl) {
            return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, NotificationEmitter.class}, new MBeanServerInvocationHandler(mBeanServerConnection, objectName, true));
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new MBeanServerInvocationHandler(mBeanServerConnection, objectName, true));
    }
}

