/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ReflectionException;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    @Deprecated
    public AttributeValueExp() {
    }

    public AttributeValueExp(String string) {
        this.attr = string;
    }

    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object object = this.getAttribute(objectName);
        if (object == null || !(object instanceof String)) {
            throw new BadAttributeValueExpException(object);
        }
        return new StringValueExp((String)object);
    }

    protected Object getAttribute(ObjectName objectName) {
        try {
            return QueryEval.getMBeanServer().getAttribute(objectName, this.attr);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (MBeanException mBeanException) {
            return null;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return null;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return null;
        }
        catch (ReflectionException reflectionException) {
            return null;
        }
    }

    public String getAttributeName() {
        return this.attr;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    public String toString() {
        return "'" + this.attr + "'";
    }
}

