/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private String rootName;
    private Map nodes = new HashMap();
    private Map childPolicies = new HashMap();
    private Map childRanges = new HashMap();
    private String resourceBaseName;

    public IIOMetadataFormatImpl(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (n < 1 || n > 2 || n == 5) {
            throw new IllegalArgumentException("wrong child policy");
        }
        this.nodes.put(string, new IIOMetadataNode(string));
        this.childPolicies.put(string, new Integer(n));
        this.rootName = string;
    }

    public IIOMetadataFormatImpl(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("invalid min or max children argument");
        }
        this.nodes.put(string, new IIOMetadataNode(string));
        this.childPolicies.put(string, new Integer(5));
        this.childRanges.put(string, new int[]{n, n2});
        this.rootName = string;
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        iIOMetadataNode.setAttributeNode(new IIOMetadataNodeAttr(iIOMetadataNode, string2, n, bl, string3));
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, List<String> list2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        iIOMetadataNode.setAttributeNode(new IIOMetadataNodeAttrEnumerated(iIOMetadataNode, string2, n, bl, string3, list2));
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, String string4, String string5, boolean bl2, boolean bl3) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        iIOMetadataNode.setAttributeNode(new IIOMetadataNodeAttrBounded(iIOMetadataNode, string2, n, bl, string3, string4, string5, bl2, bl3));
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, int n2, int n3) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        iIOMetadataNode.setAttributeNode(new IIOMetadataNodeAttrList(iIOMetadataNode, string2, n, bl, n2, n3));
    }

    protected void addBooleanAttribute(String string, String string2, boolean bl, boolean bl2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TRUE");
        arrayList.add("FALSE");
        iIOMetadataNode.setAttributeNode(new IIOMetadataNodeAttrEnumerated(iIOMetadataNode, string2, 1, bl, bl2 ? "TRUE" : "FALSE", arrayList));
    }

    protected void addChildElement(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string2);
        iIOMetadataNode.appendChild(new IIOMetadataNode(string));
        this.childPolicies.put(string, new Integer(5));
    }

    protected void addElement(String string, String string2, int n) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string2);
        iIOMetadataNode.appendChild(new IIOMetadataNode(string));
        this.childPolicies.put(string, new Integer(n));
    }

    protected void addElement(String string, String string2, int n, int n2) {
        this.addChildElement(string, string2);
        this.childRanges.put(string, new int[]{n, n2});
    }

    private void addNodeObject(IIOMetadataNode iIOMetadataNode, NodeObject nodeObject) {
        iIOMetadataNode.setUserObject(nodeObject);
    }

    private NodeObject getNodeObject(IIOMetadataNode iIOMetadataNode) {
        return (NodeObject)iIOMetadataNode.getUserObject();
    }

    private void removeNodeObject(IIOMetadataNode iIOMetadataNode) {
        iIOMetadataNode.setUserObject(null);
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, boolean bl, T t) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        this.addNodeObject(iIOMetadataNode, new NodeObject(iIOMetadataNode, clazz, bl, t));
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, boolean bl, T t, List<? extends T> list2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        this.addNodeObject(iIOMetadataNode, new NodeObjectEnumerated(iIOMetadataNode, clazz, bl, t, list2));
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, T t, Comparable<? super T> comparable, Comparable<? super T> comparable2, boolean bl, boolean bl2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        this.addNodeObject(iIOMetadataNode, new NodeObjectBounded(iIOMetadataNode, clazz, t, comparable, comparable2, bl, bl2));
    }

    protected void addObjectValue(String string, Class<?> clazz, int n, int n2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        this.addNodeObject(iIOMetadataNode, new NodeObjectArray((Element)iIOMetadataNode, clazz, n, n2));
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        return new IIOMetadataFormatImpl(standardMetadataFormatName, 1){

            public boolean canNodeAppear(String string, ImageTypeSpecifier imageTypeSpecifier) {
                return true;
            }
        };
    }

    @Override
    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    protected void removeAttribute(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        iIOMetadataNode.removeAttribute(string2);
    }

    protected void removeElement(String string) {
        this.nodes.remove(string);
    }

    protected void removeObjectValue(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        this.removeNodeObject(iIOMetadataNode);
    }

    protected void setResourceBaseName(String string) {
        this.resourceBaseName = string;
    }

    @Override
    public int getAttributeDataType(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttr iIOMetadataNodeAttr = (IIOMetadataNodeAttr)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttr.getDataType();
    }

    @Override
    public String getAttributeDefaultValue(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttr iIOMetadataNodeAttr = (IIOMetadataNodeAttr)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttr.getValue();
    }

    @Override
    public String getAttributeDescription(String string, String string2, Locale locale) {
        return this.getDescription(string + "/" + string2, locale);
    }

    @Override
    public String[] getAttributeEnumerations(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttrEnumerated iIOMetadataNodeAttrEnumerated = (IIOMetadataNodeAttrEnumerated)iIOMetadataNode.getAttributeNode(string2);
        Object[] objectArray = iIOMetadataNodeAttrEnumerated.getEnumerations();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    @Override
    public int getAttributeListMaxLength(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttrList iIOMetadataNodeAttrList = (IIOMetadataNodeAttrList)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttrList.getListMaxLength();
    }

    @Override
    public int getAttributeListMinLength(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttrList iIOMetadataNodeAttrList = (IIOMetadataNodeAttrList)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttrList.getListMinLength();
    }

    @Override
    public String getAttributeMaxValue(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttrBounded iIOMetadataNodeAttrBounded = (IIOMetadataNodeAttrBounded)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttrBounded.getMaxValue();
    }

    @Override
    public String getAttributeMinValue(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttrBounded iIOMetadataNodeAttrBounded = (IIOMetadataNodeAttrBounded)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttrBounded.getMinValue();
    }

    @Override
    public String[] getAttributeNames(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        NamedNodeMap namedNodeMap = iIOMetadataNode.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            stringArray[i] = namedNodeMap.item(i).getLocalName();
        }
        return stringArray;
    }

    @Override
    public int getAttributeValueType(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        IIOMetadataNodeAttr iIOMetadataNodeAttr = (IIOMetadataNodeAttr)iIOMetadataNode.getAttributeNode(string2);
        return iIOMetadataNodeAttr.getDataType();
    }

    @Override
    public String[] getChildNames(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringArray[i] = nodeList.item(i).getLocalName();
        }
        return stringArray;
    }

    @Override
    public int getChildPolicy(String string) {
        return (Integer)this.childPolicies.get(string);
    }

    private String getDescription(String string, Locale locale) {
        if (this.resourceBaseName == null) {
            return null;
        }
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBaseName, locale);
        String string2 = null;
        if (resourceBundle == null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        return string2;
    }

    @Override
    public String getElementDescription(String string, Locale locale) {
        return this.getDescription(string, locale);
    }

    @Override
    public int getElementMaxChildren(String string) {
        return ((int[])this.childRanges.get(string))[1];
    }

    @Override
    public int getElementMinChildren(String string) {
        return ((int[])this.childRanges.get(string))[0];
    }

    @Override
    public int getObjectArrayMaxLength(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return (Integer)((NodeObjectArray)this.getNodeObject(iIOMetadataNode)).getArrayMaxLength();
    }

    @Override
    public int getObjectArrayMinLength(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return (Integer)((NodeObjectArray)this.getNodeObject(iIOMetadataNode)).getArrayMinLength();
    }

    @Override
    public Class<?> getObjectClass(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return this.getNodeObject(iIOMetadataNode).getClassType();
    }

    @Override
    public Object getObjectDefaultValue(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return this.getNodeObject(iIOMetadataNode).getDefaultValue();
    }

    @Override
    public Object[] getObjectEnumerations(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return ((NodeObjectEnumerated)this.getNodeObject(iIOMetadataNode)).getEnumerations();
    }

    @Override
    public Comparable<?> getObjectMaxValue(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return ((NodeObjectBounded)this.getNodeObject(iIOMetadataNode)).getMaxValue();
    }

    @Override
    public Comparable<?> getObjectMinValue(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return ((NodeObjectBounded)this.getNodeObject(iIOMetadataNode)).getMinValue();
    }

    @Override
    public int getObjectValueType(String string) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        NodeObject nodeObject = this.getNodeObject(iIOMetadataNode);
        if (nodeObject == null) {
            return 0;
        }
        return nodeObject.getValueType();
    }

    @Override
    public boolean isAttributeRequired(String string, String string2) {
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)this.nodes.get(string);
        return ((IIOMetadataNodeAttr)iIOMetadataNode.getAttributeNode(string2)).isRequired();
    }

    private class NodeObjectArray
    extends NodeObject {
        protected Integer arrayMinLength;
        protected Integer arrayMaxLength;

        public NodeObjectArray(Element element, Class clazz, int n, int n2) {
            super(element, clazz, false, null);
            this.arrayMinLength = new Integer(n);
            this.arrayMaxLength = new Integer(n2);
            this.valueType = 32;
        }

        public Comparable getArrayMinLength() {
            return this.arrayMinLength;
        }

        public Comparable getArrayMaxLength() {
            return this.arrayMaxLength;
        }
    }

    private class NodeObjectBounded
    extends NodeObject {
        protected Comparable minValue;
        protected Comparable maxValue;
        protected boolean minInclusive;
        protected boolean maxInclusive;

        public NodeObjectBounded(Element element, Class clazz, Object object, Comparable comparable, Comparable comparable2, boolean bl, boolean bl2) {
            super(element, clazz, false, object);
            this.minValue = comparable;
            this.maxValue = comparable2;
            this.minInclusive = bl;
            this.maxInclusive = bl2;
            this.valueType = bl ? (bl2 ? 14 : 6) : (bl2 ? 10 : 2);
        }

        public Comparable getMinValue() {
            return this.minValue;
        }

        public Comparable getMaxValue() {
            return this.maxValue;
        }
    }

    private class NodeObjectEnumerated
    extends NodeObject {
        protected List enumeratedValues;

        public NodeObjectEnumerated(Element element, Class clazz, boolean bl, Object object, List list2) {
            super(element, clazz, false, object);
            this.enumeratedValues = list2;
            this.valueType = 16;
        }

        public Object[] getEnumerations() {
            return this.enumeratedValues.toArray();
        }
    }

    private class NodeObject {
        protected Element owner;
        protected Class classType;
        protected boolean required;
        protected Object defaultValue;
        protected int valueType;

        public NodeObject(Element element, Class clazz, boolean bl, Object object) {
            this.owner = element;
            this.classType = clazz;
            this.required = bl;
            this.defaultValue = object;
            this.valueType = 1;
        }

        public int getValueType() {
            return this.valueType;
        }

        public Class getClassType() {
            return this.classType;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    private class IIOMetadataNodeAttrList
    extends IIOMetadataNodeAttr {
        protected int listMinLength;
        protected int listMaxLength;

        public IIOMetadataNodeAttrList(Element element, String string, int n, boolean bl, int n2, int n3) {
            super(element, string, n, bl, null);
            this.listMinLength = n2;
            this.listMaxLength = n3;
        }

        public int getListMinLength() {
            return this.listMinLength;
        }

        public int getListMaxLength() {
            return this.listMaxLength;
        }
    }

    private class IIOMetadataNodeAttrBounded
    extends IIOMetadataNodeAttr {
        protected String minValue;
        protected String maxValue;
        protected boolean minInclusive;
        protected boolean maxInclusive;

        public IIOMetadataNodeAttrBounded(Element element, String string, int n, boolean bl, String string2, String string3, String string4, boolean bl2, boolean bl3) {
            super(element, string, n, bl, string2);
            this.minValue = string3;
            this.maxValue = string4;
            this.minInclusive = bl2;
            this.maxInclusive = bl3;
        }

        public String getMinValue() {
            return this.minValue;
        }

        public String getMaxValue() {
            return this.maxValue;
        }
    }

    private class IIOMetadataNodeAttrEnumerated
    extends IIOMetadataNodeAttr {
        protected List enumeratedValues;

        public IIOMetadataNodeAttrEnumerated(Element element, String string, int n, boolean bl, String string2, List list2) {
            super(element, string, n, bl, string2);
            this.enumeratedValues = new ArrayList(list2);
        }

        public Object[] getEnumerations() {
            return this.enumeratedValues.toArray();
        }
    }

    static class IIOMetadataNodeAttr
    extends IIOMetadataNode
    implements Attr {
        protected Element owner;
        protected String name;
        protected int dataType;
        protected boolean required;
        protected String defaultValue;

        public IIOMetadataNodeAttr(Element element, String string, String string2) {
            this(element, string, 0, true, string2);
        }

        public IIOMetadataNodeAttr(Element element, String string, int n, boolean bl, String string2) {
            this.owner = element;
            this.name = string;
            this.dataType = n;
            this.required = bl;
            this.defaultValue = string2;
        }

        public String getName() {
            return this.name;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public int getDataType() {
            return this.dataType;
        }

        public TypeInfo getSchemaTypeInfo() {
            return null;
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.defaultValue;
        }

        public boolean isId() {
            return false;
        }

        public void setValue(String string) {
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

