/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import javax.imageio.IIOParamController;
import javax.imageio.ImageTypeSpecifier;

public abstract class IIOParam {
    protected IIOParamController controller = null;
    protected IIOParamController defaultController = null;
    protected Point destinationOffset = new Point(0, 0);
    protected ImageTypeSpecifier destinationType = null;
    protected int[] sourceBands = null;
    protected Rectangle sourceRegion = null;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected int subsamplingXOffset = 0;
    protected int subsamplingYOffset = 0;
    private boolean no_controller = false;

    protected IIOParam() {
    }

    public boolean activateController() {
        if (this.controller == null) {
            if (this.defaultController == null || this.no_controller) {
                return false;
            }
            return this.defaultController.activate(this);
        }
        return this.controller.activate(this);
    }

    public IIOParamController getController() {
        return this.controller == null ? (this.no_controller ? null : this.defaultController) : this.controller;
    }

    public IIOParamController getDefaultController() {
        return this.defaultController;
    }

    public Point getDestinationOffset() {
        return this.destinationOffset;
    }

    public ImageTypeSpecifier getDestinationType() {
        return this.destinationType;
    }

    public int[] getSourceBands() {
        if (this.sourceBands == null) {
            return null;
        }
        int[] nArray = new int[this.sourceBands.length];
        System.arraycopy(this.sourceBands, 0, nArray, 0, this.sourceBands.length);
        return nArray;
    }

    public Rectangle getSourceRegion() {
        return this.sourceRegion;
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public int getSubsamplingXOffset() {
        return this.subsamplingXOffset;
    }

    public int getSubsamplingYOffset() {
        return this.subsamplingYOffset;
    }

    public boolean hasController() {
        return this.getController() != null;
    }

    public void setController(IIOParamController iIOParamController) {
        if (iIOParamController == this.defaultController) {
            this.controller = null;
            this.no_controller = false;
        } else {
            this.no_controller = iIOParamController == null;
            this.controller = iIOParamController;
        }
    }

    public void setDestinationType(ImageTypeSpecifier imageTypeSpecifier) {
        this.destinationType = imageTypeSpecifier;
    }

    public void setDestinationOffset(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("destinationOffset is null");
        }
        this.destinationOffset = point;
    }

    public void setSourceBands(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sourceBands = nArray2;
    }

    public void setSourceRegion(Rectangle rectangle) {
        if (rectangle != null && (rectangle.x < 0 || rectangle.y < 0 || rectangle.width <= 0 || rectangle.height <= 0)) {
            throw new IllegalArgumentException("illegal source region");
        }
        if (rectangle != null) {
            int n = (rectangle.height - this.subsamplingYOffset + this.sourceYSubsampling - 1) / this.sourceYSubsampling;
            int n2 = (rectangle.width - this.subsamplingXOffset + this.sourceXSubsampling - 1) / this.sourceXSubsampling;
            if (n <= 0 || n2 <= 0) {
                throw new IllegalStateException("zero pixels in source region");
            }
        }
        this.sourceRegion = rectangle;
    }

    public void setSourceSubsampling(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("subsampling offset < 0");
        }
        if (this.sourceRegion != null) {
            int n5 = (this.sourceRegion.height - n4 + n2 - 1) / n2;
            int n6 = (this.sourceRegion.width - n3 + n - 1) / n;
            if (n5 <= 0 || n6 <= 0) {
                throw new IllegalStateException("subsampling parameters would produce zero pixel samples in source region");
            }
        }
        this.sourceXSubsampling = n;
        this.sourceYSubsampling = n2;
        this.subsamplingXOffset = n3;
        this.subsamplingYOffset = n4;
    }
}

