/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private static final String SERVICE = "KeyAgreement";
    private KeyAgreementSpi kaSpi;
    private Provider provider;
    private String algorithm;
    private boolean virgin;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.kaSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
        this.virgin = true;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return KeyAgreement.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyAgreement.getInstance(string, provider);
    }

    public static final KeyAgreement getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        StringBuilder stringBuilder = new StringBuilder("KeyAgreement algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(SERVICE, string, provider);
            return new KeyAgreement((KeyAgreementSpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(stringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final Key doPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret(byArray, n);
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.kaSpi.engineGenerateSecret(string);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, new SecureRandom());
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.kaSpi.engineInit(key, secureRandom);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.init(key, algorithmParameterSpec, new SecureRandom());
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.kaSpi.engineInit(key, algorithmParameterSpec, secureRandom);
        this.virgin = false;
    }
}

