/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static boolean debug = false;
    private Map<String, String>[] mimetypes;

    public MimetypesFileTypeMap() {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MimetypesFileTypeMap(String string) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            this.init(fileReader);
            Object var4_3 = null;
            if (fileReader == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileReader == null) throw throwable;
            ((Reader)fileReader).close();
            throw throwable;
        }
        ((Reader)fileReader).close();
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this.init(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void init(Reader reader) {
        int n;
        Object object;
        this.mimetypes = new Map[5];
        for (int i = 0; i < this.mimetypes.length; ++i) {
            this.mimetypes[i] = new HashMap<String, String>();
        }
        if (reader != null) {
            if (debug) {
                System.out.println("MimetypesFileTypeMap: load PROG");
            }
            try {
                this.parse(this.mimetypes[0], reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load HOME");
        }
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                this.parseFile(this.mimetypes[1], new CPStringBuilder((String)object).append(File.separatorChar).append(".mime.types").toString());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load SYS");
        }
        try {
            this.parseFile(this.mimetypes[2], new CPStringBuilder(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mime.types").toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load JAR");
        }
        if ((n = (object = this.getSystemResources("META-INF/mime.types")).size()) > 0) {
            for (int i = 0; i < n; ++i) {
                InputStreamReader inputStreamReader = null;
                URL uRL = (URL)object.get(i);
                inputStreamReader = new InputStreamReader(uRL.openStream());
                this.parse(this.mimetypes[3], inputStreamReader);
                Object var9_12 = null;
                if (inputStreamReader == null) continue;
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException2) {}
                continue;
                {
                    catch (IOException iOException) {
                        var9_12 = null;
                        if (inputStreamReader == null) continue;
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_12 = null;
                    if (inputStreamReader != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        } else {
            this.parseResource(this.mimetypes[3], "/META-INF/mime.types");
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load DEF");
        }
        this.parseResource(this.mimetypes[4], "/META-INF/mimetypes.default");
    }

    public synchronized void addMimeTypes(String string) {
        if (debug) {
            System.out.println("MimetypesFileTypeMap: add to PROG");
        }
        try {
            this.parse(this.mimetypes[0], new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    @Override
    public synchronized String getContentType(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return DEFAULT_MIME_TYPE;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() < 1) {
            return DEFAULT_MIME_TYPE;
        }
        for (int i = 0; i < this.mimetypes.length; ++i) {
            String string3 = this.mimetypes[i].get(string2);
            if (string3 == null) continue;
            return string3;
        }
        return DEFAULT_MIME_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFile(Map<String, String> map, String string) {
        FileReader fileReader = null;
        fileReader = new FileReader(string);
        this.parse(map, fileReader);
        Object var6_4 = null;
        if (fileReader == null) return;
        try {
            ((Reader)fileReader).close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var6_5 = null;
                if (fileReader == null) return;
                try {
                    ((Reader)fileReader).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileReader == null) throw throwable;
            try {
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseResource(Map<String, String> map, String string) {
        Reader reader;
        block8: {
            reader = null;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) break block8;
            reader = new InputStreamReader(inputStream);
            this.parse(map, reader);
        }
        Object var6_6 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var6_7 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void parse(Map<String, String> map, Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        CPStringBuilder cPStringBuilder = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = (string = string.trim()).length();
            if (n != 0 && string.charAt(0) != '#') {
                if (string.charAt(n - 1) == '\\') {
                    if (cPStringBuilder == null) {
                        cPStringBuilder = new CPStringBuilder();
                    }
                    cPStringBuilder.append(string.substring(0, n - 1));
                } else if (cPStringBuilder != null) {
                    cPStringBuilder.append(string);
                    this.parseEntry(map, cPStringBuilder.toString());
                    cPStringBuilder = null;
                } else {
                    this.parseEntry(map, string);
                }
            }
            string = bufferedReader.readLine();
        }
    }

    private void parseEntry(Map<String, String> map, String string) {
        String string2 = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) {
                if (string2 == null) {
                    string2 = cPStringBuilder.toString();
                } else if (cPStringBuilder.length() > 0) {
                    map.put(cPStringBuilder.toString(), string2);
                }
                cPStringBuilder.setLength(0);
                continue;
            }
            cPStringBuilder.append(c);
        }
        if (cPStringBuilder.length() > 0) {
            map.put(cPStringBuilder.toString(), string2);
        }
    }

    private List<URL> getSystemResources(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = ClassLoader.getSystemResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    static {
        try {
            String string = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

