/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType
implements Externalizable {
    static final String TSPECIALS = "()<>@,;:/[]?=\\\"";
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new MimeTypeParameterList();
    }

    public MimeType(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public MimeType(String string, String string2) throws MimeTypeParseException {
        MimeType.checkValidity(string, "Primary type is invalid");
        MimeType.checkValidity(string2, "Sub type is invalid");
        this.primaryType = string.toLowerCase();
        this.subType = string2.toLowerCase();
        this.parameters = new MimeTypeParameterList();
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String string) throws MimeTypeParseException {
        MimeType.checkValidity(string, "Primary type is invalid");
        this.primaryType = string.toLowerCase();
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String string) throws MimeTypeParseException {
        MimeType.checkValidity(string, "Sub type is invalid");
        this.subType = string.toLowerCase();
    }

    public MimeTypeParameterList getParameters() {
        return this.parameters;
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public void setParameter(String string, String string2) {
        this.parameters.set(string, string2);
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    public String toString() {
        return new CPStringBuilder(this.primaryType).append('/').append(this.subType).append(this.parameters.toString()).toString();
    }

    public String getBaseType() {
        return new CPStringBuilder(this.primaryType).append('/').append(this.subType).toString();
    }

    public boolean match(MimeType mimeType) {
        String string = mimeType.getPrimaryType();
        String string2 = mimeType.getSubType();
        return this.primaryType.equals(string) && (this.subType.equals(string2) || "*".equals(this.subType) || "*".equals(string2));
    }

    public boolean match(String string) throws MimeTypeParseException {
        return this.match(new MimeType(string));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
        objectOutput.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.parse(objectInput.readUTF());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IOException(mimeTypeParseException.getMessage());
        }
    }

    private void parse(String string) throws MimeTypeParseException {
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n == -1) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n2 == -1) {
            this.primaryType = string.substring(0, n).toLowerCase().trim();
            this.subType = string.substring(n + 1).toLowerCase().trim();
            this.parameters = new MimeTypeParameterList();
        } else if (n < n2) {
            this.primaryType = string.substring(0, n).toLowerCase().trim();
            this.subType = string.substring(n + 1, n2).toLowerCase().trim();
            this.parameters = new MimeTypeParameterList(string.substring(n2));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        MimeType.checkValidity(this.primaryType, "Primary type is invalid");
        MimeType.checkValidity(this.subType, "Sub type is invalid");
    }

    static void checkValidity(String string, String string2) throws MimeTypeParseException {
        int n = string.length();
        if (n == 0) {
            throw new MimeTypeParseException(string2, string);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (MimeType.isValidChar(c)) continue;
            throw new MimeTypeParseException(string2, string);
        }
    }

    static boolean isValidChar(char c) {
        return c > ' ' && c <= '~' && TSPECIALS.indexOf(c) == -1;
    }
}

