/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandlerDataSource;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;
import javax.activation.URLDataSource;
import javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private static final DataFlavor[] NO_FLAVORS = new DataFlavor[0];
    private static DataContentHandlerFactory factory = null;
    private final DataSource dataSource;
    private DataSource objDataSource;
    private Object object;
    private String objectMimeType;
    private CommandMap currentCommandMap;
    private DataFlavor[] transferFlavors = NO_FLAVORS;
    private DataContentHandler dataContentHandler;
    private DataContentHandler factoryDCH;
    private DataContentHandlerFactory oldFactory;
    private String shortType;

    public DataHandler(DataSource dataSource) {
        this.dataSource = dataSource;
        this.oldFactory = factory;
    }

    public DataHandler(Object object, String string) {
        this.dataSource = null;
        this.object = object;
        this.objectMimeType = string;
        this.oldFactory = factory;
    }

    public DataHandler(URL uRL) {
        this.dataSource = new URLDataSource(uRL);
        this.oldFactory = factory;
    }

    public DataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.objDataSource == null) {
            this.objDataSource = new DataHandlerDataSource(this);
        }
        return this.objDataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getInputStream();
        }
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        if (dataContentHandler == null) {
            throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getShortType());
        }
        if (dataContentHandler instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dataContentHandler).getDCH() == null) {
            throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getShortType());
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        DataContentHandlerWriter dataContentHandlerWriter = new DataContentHandlerWriter(dataContentHandler, this.object, this.objectMimeType, pipedOutputStream);
        Thread thread = new Thread(dataContentHandlerWriter, "DataHandler.getInputStream");
        thread.start();
        return new PipedInputStream(pipedOutputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataSource != null) {
            InputStream inputStream = this.dataSource.getInputStream();
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            dataContentHandler.writeTo(this.object, this.objectMimeType, outputStream);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getOutputStream();
        }
        return null;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (factory != this.oldFactory || this.transferFlavors == NO_FLAVORS) {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            this.transferFlavors = dataContentHandler.getTransferDataFlavors();
        }
        return this.transferFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        return dataContentHandler.getTransferData(dataFlavor, this.dataSource);
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        if (commandMap != this.currentCommandMap || commandMap == null) {
            this.transferFlavors = NO_FLAVORS;
            this.dataContentHandler = null;
            this.currentCommandMap = commandMap;
        }
    }

    public CommandInfo[] getPreferredCommands() {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getPreferredCommands(this.getShortType());
    }

    public CommandInfo[] getAllCommands() {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getAllCommands(this.getShortType());
    }

    public CommandInfo getCommand(String string) {
        CommandMap commandMap = this.getCommandMap();
        return commandMap.getCommand(this.getShortType(), string);
    }

    public Object getContent() throws IOException {
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        return dataContentHandler.getContent(this.getDataSource());
    }

    public Object getBean(CommandInfo commandInfo) {
        try {
            return commandInfo.getCommandObject(this, this.getClass().getClassLoader());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.err);
            return null;
        }
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory dataContentHandlerFactory) {
        block4: {
            if (factory != null) {
                throw new Error("DataContentHandlerFactory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    if (dataContentHandlerFactory == null || DataHandler.class.getClassLoader() == dataContentHandlerFactory.getClass().getClassLoader()) break block4;
                    throw securityException;
                }
            }
        }
        factory = dataContentHandlerFactory;
    }

    private synchronized String getShortType() {
        if (this.shortType == null) {
            String string = this.getContentType();
            try {
                MimeType mimeType = new MimeType(string);
                this.shortType = mimeType.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = string;
            }
        }
        return this.shortType;
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = NO_FLAVORS;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String string = this.getShortType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(string);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            CommandMap commandMap = this.getCommandMap();
            this.dataContentHandler = commandMap.createDataContentHandler(string);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    static class DataContentHandlerWriter
    implements Runnable {
        DataContentHandler dch;
        Object object;
        String mimeType;
        OutputStream out;

        DataContentHandlerWriter(DataContentHandler dataContentHandler, Object object, String string, OutputStream outputStream) {
            this.dch = dataContentHandler;
            this.object = object;
            this.mimeType = string;
            this.out = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block8: {
                this.dch.writeTo(this.object, this.mimeType, this.out);
                Object var3_1 = null;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                break block8;
                {
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        try {
                            this.out.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

