/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import gnu.java.util.EmptyEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    static final int ENDNRD = 4;
    private final String name;
    private final RandomAccessFile raf;
    private LinkedHashMap<String, ZipEntry> entries;
    private boolean closed = false;

    private RandomAccessFile openFile(String string, File file) throws ZipException, IOException {
        try {
            return string != null ? new RandomAccessFile(string, "r") : new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            ZipException zipException = new ZipException(fileNotFoundException.getMessage());
            zipException.initCause(fileNotFoundException);
            throw zipException;
        }
    }

    public ZipFile(String string) throws ZipException, IOException {
        this.raf = this.openFile(string, null);
        this.name = string;
        this.checkZipFile();
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        if (n != 1 && n != 5) {
            throw new IllegalArgumentException("invalid mode");
        }
        if ((n & 4) != 0) {
            file.deleteOnExit();
        }
        this.raf = this.openFile(null, file);
        this.name = file.getPath();
        this.checkZipFile();
    }

    private void checkZipFile() throws ZipException {
        boolean bl = false;
        try {
            byte[] byArray = new byte[4];
            this.raf.readFully(byArray);
            int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            bl = (long)n == 67324752L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ZipException("Not a valid zip file");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ZipFile has closed: " + this.name);
        }
    }

    private void readEntries() throws ZipException, IOException {
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, 4096);
        long l = this.raf.length() - 22L;
        long l2 = Math.max(0L, l - 65536L);
        do {
            if (l < l2) {
                throw new ZipException("central directory not found, probably not a zip file: " + this.name);
            }
            partialInputStream.seek(l--);
        } while ((long)partialInputStream.readLeInt() != 101010256L);
        if (partialInputStream.skip(6L) != 6L) {
            throw new EOFException(this.name);
        }
        int n = partialInputStream.readLeShort();
        if (partialInputStream.skip(4L) != 4L) {
            throw new EOFException(this.name);
        }
        int n2 = partialInputStream.readLeInt();
        this.entries = new LinkedHashMap(n + n / 2);
        partialInputStream.seek(n2);
        for (int i = 0; i < n; ++i) {
            if ((long)partialInputStream.readLeInt() != 33639248L) {
                throw new ZipException("Wrong Central Directory signature: " + this.name);
            }
            partialInputStream.skip(4L);
            int n3 = partialInputStream.readLeShort();
            if ((n3 & 1) != 0) {
                throw new ZipException("invalid CEN header (encrypted entry)");
            }
            int n4 = partialInputStream.readLeShort();
            int n5 = partialInputStream.readLeInt();
            int n6 = partialInputStream.readLeInt();
            int n7 = partialInputStream.readLeInt();
            int n8 = partialInputStream.readLeInt();
            int n9 = partialInputStream.readLeShort();
            int n10 = partialInputStream.readLeShort();
            int n11 = partialInputStream.readLeShort();
            partialInputStream.skip(8L);
            int n12 = partialInputStream.readLeInt();
            String string = partialInputStream.readString(n9);
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n4);
            zipEntry.setCrc((long)n6 & 0xFFFFFFFFL);
            zipEntry.setSize((long)n8 & 0xFFFFFFFFL);
            zipEntry.setCompressedSize((long)n7 & 0xFFFFFFFFL);
            zipEntry.setDOSTime(n5);
            if (n10 > 0) {
                byte[] byArray = new byte[n10];
                partialInputStream.readFully(byArray);
                zipEntry.setExtra(byArray);
            }
            if (n11 > 0) {
                zipEntry.setComment(partialInputStream.readString(n11));
            }
            zipEntry.offset = n12;
            this.entries.put(string, zipEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile == null) {
            return;
        }
        RandomAccessFile randomAccessFile2 = randomAccessFile;
        synchronized (randomAccessFile2) {
            this.closed = true;
            this.entries = null;
            randomAccessFile.close();
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed && this.raf != null) {
            this.close();
        }
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.checkClosed();
        try {
            return new ZipEntryEnumeration(this.getEntries().values().iterator());
        }
        catch (IOException iOException) {
            return new EmptyEnumeration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, ZipEntry> getEntries() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.checkClosed();
            if (this.entries == null) {
                this.readEntries();
            }
            return this.entries;
        }
    }

    public ZipEntry getEntry(String string) {
        this.checkClosed();
        try {
            LinkedHashMap<String, ZipEntry> linkedHashMap = this.getEntries();
            ZipEntry zipEntry = linkedHashMap.get(string);
            if (zipEntry == null && !string.endsWith("/")) {
                zipEntry = linkedHashMap.get(string + '/');
            }
            return zipEntry != null ? new ZipEntry(zipEntry, string) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.checkClosed();
        LinkedHashMap<String, ZipEntry> linkedHashMap = this.getEntries();
        String string = zipEntry.getName();
        ZipEntry zipEntry2 = linkedHashMap.get(string);
        if (zipEntry2 == null) {
            return null;
        }
        PartialInputStream partialInputStream = new PartialInputStream(this.raf, 1024);
        partialInputStream.seek(zipEntry2.offset);
        if ((long)partialInputStream.readLeInt() != 67324752L) {
            throw new ZipException("Wrong Local header signature: " + string);
        }
        partialInputStream.skip(4L);
        if (zipEntry2.getMethod() != partialInputStream.readLeShort()) {
            throw new ZipException("Compression method mismatch: " + string);
        }
        partialInputStream.skip(16L);
        int n = partialInputStream.readLeShort();
        int n2 = partialInputStream.readLeShort();
        partialInputStream.skip(n + n2);
        partialInputStream.setLength(zipEntry2.getCompressedSize());
        int n3 = zipEntry2.getMethod();
        switch (n3) {
            case 0: {
                return partialInputStream;
            }
            case 8: {
                partialInputStream.addDummyByte();
                Inflater inflater = new Inflater(true);
                final int n4 = (int)zipEntry.getSize();
                return new InflaterInputStream(partialInputStream, inflater){

                    public int available() throws IOException {
                        if (n4 == -1) {
                            return super.available();
                        }
                        if (super.available() != 0) {
                            return n4 - this.inf.getTotalOut();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("Unknown compression method " + n3);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        this.checkClosed();
        try {
            return this.getEntries().size();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static final class PartialInputStream
    extends InputStream {
        private static final Charset UTF8CHARSET = Charset.forName("UTF-8");
        private CharsetDecoder utf8Decoder;
        private final RandomAccessFile raf;
        private final byte[] buffer;
        private long bufferOffset;
        private int pos;
        private long end;
        private int dummyByteCount;

        public PartialInputStream(RandomAccessFile randomAccessFile, int n) throws IOException {
            this.raf = randomAccessFile;
            this.buffer = new byte[n];
            this.bufferOffset = -this.buffer.length;
            this.pos = this.buffer.length;
            this.end = randomAccessFile.length();
        }

        void setLength(long l) {
            this.end = this.bufferOffset + (long)this.pos + l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer() throws IOException {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                long l = this.end - this.bufferOffset;
                if (l == 0L && this.dummyByteCount > 0) {
                    this.buffer[0] = 0;
                    this.dummyByteCount = 0;
                } else {
                    this.raf.seek(this.bufferOffset);
                    this.raf.readFully(this.buffer, 0, (int)Math.min((long)this.buffer.length, l));
                }
            }
        }

        public int available() {
            long l = this.end - (this.bufferOffset + (long)this.pos);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public int read() throws IOException {
            if (this.bufferOffset + (long)this.pos >= this.end + (long)this.dummyByteCount) {
                return -1;
            }
            if (this.pos == this.buffer.length) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((long)n2 > this.end + (long)this.dummyByteCount - (this.bufferOffset + (long)this.pos) && (n2 = (int)(this.end + (long)this.dummyByteCount - (this.bufferOffset + (long)this.pos))) == 0) {
                return -1;
            }
            int n3 = Math.min(this.buffer.length - this.pos, n2);
            System.arraycopy(this.buffer, this.pos, byArray, n, n3);
            this.pos += n3;
            n += n3;
            n2 -= n3;
            while (n2 > 0) {
                this.bufferOffset += (long)this.buffer.length;
                this.pos = 0;
                this.fillBuffer();
                int n4 = Math.min(this.buffer.length, n2);
                System.arraycopy(this.buffer, this.pos, byArray, n, n4);
                this.pos += n4;
                n += n4;
                n2 -= n4;
                n3 += n4;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l < 0L) {
                return 0L;
            }
            if (l > this.end - (this.bufferOffset + (long)this.pos)) {
                l = this.end - (this.bufferOffset + (long)this.pos);
            }
            this.seek(this.bufferOffset + (long)this.pos + l);
            return l;
        }

        void seek(long l) throws IOException {
            long l2 = l - this.bufferOffset;
            if (l2 >= 0L && l2 <= (long)this.buffer.length) {
                this.pos = (int)l2;
            } else {
                this.bufferOffset = l;
                this.pos = 0;
                this.fillBuffer();
            }
        }

        void readFully(byte[] byArray) throws IOException {
            if (this.read(byArray, 0, byArray.length) != byArray.length) {
                throw new EOFException();
            }
        }

        void readFully(byte[] byArray, int n, int n2) throws IOException {
            if (this.read(byArray, n, n2) != n2) {
                throw new EOFException();
            }
        }

        int readLeShort() throws IOException {
            int n;
            if (this.pos + 1 < this.buffer.length) {
                n = this.buffer[this.pos + 0] & 0xFF | (this.buffer[this.pos + 1] & 0xFF) << 8;
                this.pos += 2;
            } else {
                int n2 = this.read();
                int n3 = this.read();
                if (n3 == -1) {
                    throw new EOFException();
                }
                n = n2 & 0xFF | (n3 & 0xFF) << 8;
            }
            return n;
        }

        int readLeInt() throws IOException {
            int n;
            if (this.pos + 3 < this.buffer.length) {
                n = this.buffer[this.pos + 0] & 0xFF | (this.buffer[this.pos + 1] & 0xFF) << 8 | (this.buffer[this.pos + 2] & 0xFF | (this.buffer[this.pos + 3] & 0xFF) << 8) << 16;
                this.pos += 4;
            } else {
                int n2 = this.read();
                int n3 = this.read();
                int n4 = this.read();
                int n5 = this.read();
                if (n5 == -1) {
                    throw new EOFException();
                }
                n = n2 & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF | (n5 & 0xFF) << 8) << 16;
            }
            return n;
        }

        private String decodeChars(byte[] byArray, int n, int n2) throws IOException {
            String string;
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && byArray[n3] <= 127; --n3) {
            }
            if (n3 < 0) {
                string = new String(byArray, 0, n, n2);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
                if (this.utf8Decoder == null) {
                    this.utf8Decoder = UTF8CHARSET.newDecoder();
                }
                this.utf8Decoder.reset();
                char[] cArray = this.utf8Decoder.decode(byteBuffer).array();
                string = String.valueOf(cArray);
            }
            return string;
        }

        String readString(int n) throws IOException {
            if ((long)n > this.end - (this.bufferOffset + (long)this.pos)) {
                throw new EOFException();
            }
            String string = null;
            try {
                if (this.buffer.length - this.pos >= n) {
                    string = this.decodeChars(this.buffer, this.pos, n);
                    this.pos += n;
                } else {
                    byte[] byArray = new byte[n];
                    this.readFully(byArray);
                    string = this.decodeChars(byArray, 0, n);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            return string;
        }

        public void addDummyByte() {
            this.dummyByteCount = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipEntryEnumeration
    implements Enumeration<ZipEntry> {
        private final Iterator<ZipEntry> elements;

        public ZipEntryEnumeration(Iterator<ZipEntry> iterator) {
            this.elements = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.hasNext();
        }

        @Override
        public ZipEntry nextElement() {
            return (ZipEntry)this.elements.next().clone();
        }
    }
}

