/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.RE;
import gnu.java.util.regex.REMatch;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private CharSequence input;
    private CharIndexed inputCharIndexed;
    private int position;
    private int appendPosition;
    private REMatch match;
    private int regionStart;
    private int regionEnd;
    private boolean transparentBounds;
    private int anchoringBounds;

    Matcher(Pattern pattern2, CharSequence charSequence) {
        this.pattern = pattern2;
        this.input = charSequence;
        this.inputCharIndexed = RE.makeCharIndexed(charSequence, 0);
        this.regionStart = 0;
        this.regionEnd = charSequence.length();
        this.transparentBounds = false;
        this.anchoringBounds = 0;
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) throws IllegalStateException {
        this.assertMatchOp();
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        stringBuffer.append(RE.getReplacement(string, this.match, 512));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return stringBuffer;
    }

    public int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public int end(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(n);
    }

    public boolean find() {
        boolean bl = this.match == null;
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.position, this.anchoringBounds) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), this.position, this.anchoringBounds);
        if (this.match != null) {
            int n = this.match.getEndIndex();
            if (n > this.input.length()) {
                this.match = null;
                return false;
            }
            if (!bl && n == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = n;
            return true;
        }
        return false;
    }

    public boolean find(int n) {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, n, this.anchoringBounds) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), n, this.anchoringBounds);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public String group(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(n);
    }

    public String replaceFirst(String string) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, string, this.position, 512);
    }

    public String replaceAll(String string) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, string, this.position, 512);
    }

    public int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public boolean lookingAt() {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.regionStart, this.anchoringBounds | 0x1000 | 0x40) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), 0, this.anchoringBounds | 0x1000);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public boolean matches() {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.regionStart, this.anchoringBounds | 0x100 | 0x1000 | 0x40) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), 0, this.anchoringBounds | 0x100 | 0x1000);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                if (this.position == this.input.length()) {
                    return true;
                }
            }
            this.match = null;
        }
        return false;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.position = 0;
        this.match = null;
        this.regionStart = 0;
        this.regionEnd = this.input.length();
        this.appendPosition = 0;
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.input = charSequence;
        this.inputCharIndexed = RE.makeCharIndexed(charSequence, 0);
        return this.reset();
    }

    public int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public int start(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(n);
    }

    public boolean hitEnd() {
        return this.inputCharIndexed.hitEnd();
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(this.getClass().getName()).append("[pattern=").append(this.pattern.pattern()).append(" region=").append(this.regionStart).append(",").append(this.regionEnd).append(" anchoringBounds=").append(this.anchoringBounds == 0).append(" transparentBounds=").append(this.transparentBounds).append(" lastmatch=").append(this.match == null ? "" : this.match.toString()).append("]");
        return cPStringBuilder.toString();
    }

    private void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }

    public Matcher region(int n, int n2) {
        int n3 = this.input.length();
        if (n < 0) {
            throw new IndexOutOfBoundsException("The start position was less than zero.");
        }
        if (n >= n3) {
            throw new IndexOutOfBoundsException("The start position is after the end of the input.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The end position was less than zero.");
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("The end position is after the end of the input.");
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("The start position is after the end position.");
        }
        this.reset();
        this.regionStart = n;
        this.regionEnd = n2;
        return this;
    }

    public int regionStart() {
        return this.regionStart;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean bl) {
        this.transparentBounds = bl;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds == 0;
    }

    public Matcher useAnchoringBounds(boolean bl) {
        this.anchoringBounds = bl ? 0 : 48;
        return this;
    }

    public MatchResult toMatchResult() {
        Matcher matcher = new Matcher(this.pattern, this.input);
        if (this.match != null) {
            matcher.match = (REMatch)this.match.clone();
        }
        return matcher;
    }

    public static String quoteReplacement(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$' || c == '\\') {
                cPStringBuilder.append('\\');
            }
            cPStringBuilder.append(c);
        }
        return cPStringBuilder.toString();
    }
}

