/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.util.jar.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest
implements Cloneable {
    private final Attributes mainAttr;
    private final Map<String, Attributes> entries;

    public Manifest() {
        this.mainAttr = new Attributes();
        this.entries = new Hashtable<String, Attributes>();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this();
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        this.mainAttr = new Attributes(manifest.getMainAttributes());
        this.entries = new Hashtable<String, Attributes>(manifest.getEntries());
    }

    public Attributes getMainAttributes() {
        return this.mainAttr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        return this.getEntries().get(string);
    }

    public void clear() {
        this.mainAttr.clear();
        this.entries.clear();
    }

    public void read(InputStream inputStream) throws IOException {
        JarUtils.readMFManifest(this.getMainAttributes(), this.getEntries(), inputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        JarUtils.writeMFManifest(this.getMainAttributes(), this.getEntries(), outputStream);
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object object) {
        return object instanceof Manifest && this.mainAttr.equals(((Manifest)object).mainAttr) && this.entries.equals(((Manifest)object).entries);
    }

    public int hashCode() {
        return this.mainAttr.hashCode() ^ this.entries.hashCode();
    }
}

