/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarEntry
extends ZipEntry {
    Attributes attr;
    JarFile jarfile;

    public JarEntry(String string) throws NullPointerException, IllegalArgumentException {
        super(string);
        this.attr = null;
        this.jarfile = null;
    }

    public JarEntry(ZipEntry zipEntry) {
        super(zipEntry);
        this.attr = null;
        this.jarfile = null;
    }

    public JarEntry(JarEntry jarEntry) {
        super(jarEntry);
        try {
            this.attr = jarEntry.getAttributes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jarfile = jarEntry.jarfile;
    }

    public Attributes getAttributes() throws IOException {
        if (this.attr != null) {
            return (Attributes)this.attr.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getCertificates() {
        if (this.jarfile != null) {
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                Set set;
                if (this.jarfile.entryCerts != null && (set = (Set)this.jarfile.entryCerts.get(this.getName())) != null && this.jarfile.verified.get(this.getName()) == Boolean.TRUE) {
                    return set.toArray(new Certificate[set.size()]);
                }
            }
        }
        return null;
    }
}

