/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueuedLongSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414692L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile long state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;

    protected AbstractQueuedLongSynchronizer() {
    }

    protected final long getState() {
        return this.state;
    }

    protected final void setState(long l) {
        this.state = l;
    }

    protected final boolean compareAndSetState(long l, long l2) {
        return unsafe.compareAndSwapLong(this, stateOffset, l, l2);
    }

    private Node enq(Node node2) {
        Node node3;
        while (true) {
            if ((node3 = this.tail) == null) {
                Node node4 = new Node();
                node4.next = node2;
                node2.prev = node4;
                if (!this.compareAndSetHead(node4)) continue;
                this.tail = node2;
                return node4;
            }
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) break;
        }
        node3.next = node2;
        return node3;
    }

    private Node addWaiter(Node node2) {
        Node node3 = new Node(Thread.currentThread(), node2);
        Node node4 = this.tail;
        if (node4 != null) {
            node3.prev = node4;
            if (this.compareAndSetTail(node4, node3)) {
                node4.next = node3;
                return node3;
            }
        }
        this.enq(node3);
        return node3;
    }

    private void setHead(Node node2) {
        this.head = node2;
        node2.thread = null;
        node2.prev = null;
    }

    private void unparkSuccessor(Node node2) {
        AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, -1, 0);
        Node node3 = node2.next;
        if (node3 == null || node3.waitStatus > 0) {
            node3 = null;
            Node node4 = this.tail;
            while (node4 != null && node4 != node2) {
                if (node4.waitStatus <= 0) {
                    node3 = node4;
                }
                node4 = node4.prev;
            }
        }
        if (node3 != null) {
            LockSupport.unpark(node3.thread);
        }
    }

    private void setHeadAndPropagate(Node node2, long l) {
        Node node3;
        this.setHead(node2);
        if (l > 0L && node2.waitStatus != 0 && ((node3 = node2.next) == null || node3.isShared())) {
            this.unparkSuccessor(node2);
        }
    }

    private void cancelAcquire(Node node2) {
        if (node2 != null) {
            node2.thread = null;
            node2.waitStatus = 1;
            this.unparkSuccessor(node2);
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node2, Node node3) {
        int n = node2.waitStatus;
        if (n < 0) {
            return true;
        }
        if (n > 0) {
            node3.prev = node2.prev;
        } else {
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node2, long l) {
        try {
            boolean bl = false;
            while (true) {
                Node node3;
                if ((node3 = node2.predecessor()) == this.head && this.tryAcquire(l)) {
                    this.setHead(node2);
                    node3.next = null;
                    return bl;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
    }

    private void doAcquireInterruptibly(long l) throws InterruptedException {
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node node3;
            do {
                if ((node3 = node2.predecessor()) != this.head || !this.tryAcquire(l)) continue;
                this.setHead(node2);
                node3.next = null;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    private boolean doAcquireNanos(long l, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        try {
            do {
                Node node3;
                if ((node3 = node2.predecessor()) == this.head && this.tryAcquire(l)) {
                    this.setHead(node2);
                    node3.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    this.cancelAcquire(node2);
                    return false;
                }
                if (l2 > 1000L && AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2)) {
                    LockSupport.parkNanos(this, l2);
                }
                long l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    private void doAcquireShared(long l) {
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            boolean bl = false;
            while (true) {
                long l2;
                Node node3;
                if ((node3 = node2.predecessor()) == this.head && (l2 = this.tryAcquireShared(l)) >= 0L) {
                    this.setHeadAndPropagate(node2, l2);
                    node3.next = null;
                    if (bl) {
                        AbstractQueuedLongSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
    }

    private void doAcquireSharedInterruptibly(long l) throws InterruptedException {
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            Node node3;
            do {
                long l2;
                if ((node3 = node2.predecessor()) != this.head || (l2 = this.tryAcquireShared(l)) < 0L) continue;
                this.setHeadAndPropagate(node2, l2);
                node3.next = null;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    private boolean doAcquireSharedNanos(long l, long l2) throws InterruptedException {
        long l3 = System.nanoTime();
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            do {
                long l4;
                Node node3;
                if ((node3 = node2.predecessor()) == this.head && (l4 = this.tryAcquireShared(l)) >= 0L) {
                    this.setHeadAndPropagate(node2, l4);
                    node3.next = null;
                    return true;
                }
                if (l2 <= 0L) {
                    this.cancelAcquire(node2);
                    return false;
                }
                if (l2 > 1000L && AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node3, node2)) {
                    LockSupport.parkNanos(this, l2);
                }
                l4 = System.nanoTime();
                l2 -= l4 - l3;
                l3 = l4;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node2);
            throw runtimeException;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(long l) {
        throw new UnsupportedOperationException();
    }

    protected long tryAcquireShared(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(long l) {
        if (!this.tryAcquire(l) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), l)) {
            AbstractQueuedLongSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(l)) {
            this.doAcquireInterruptibly(l);
        }
    }

    public final boolean tryAcquireNanos(long l, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(l) || this.doAcquireNanos(l, l2);
    }

    public final boolean release(long l) {
        if (this.tryRelease(l)) {
            Node node2 = this.head;
            if (node2 != null && node2.waitStatus != 0) {
                this.unparkSuccessor(node2);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(long l) {
        if (this.tryAcquireShared(l) < 0L) {
            this.doAcquireShared(l);
        }
    }

    public final void acquireSharedInterruptibly(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(l) < 0L) {
            this.doAcquireSharedInterruptibly(l);
        }
    }

    public final boolean tryAcquireSharedNanos(long l, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(l) >= 0L || this.doAcquireSharedNanos(l, l2);
    }

    public final boolean releaseShared(long l) {
        if (this.tryReleaseShared(l)) {
            Node node2 = this.head;
            if (node2 != null && node2.waitStatus != 0) {
                this.unparkSuccessor(node2);
            }
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread thread;
        Node node2;
        Node node3 = this.head;
        if (node3 != null && (node2 = node3.next) != null && node2.prev == this.head && (thread = node2.thread) != null || (node3 = this.head) != null && (node2 = node3.next) != null && node2.prev == this.head && (thread = node2.thread) != null) {
            return thread;
        }
        Node node4 = this.tail;
        Thread thread2 = null;
        while (node4 != null && node4 != this.head) {
            Thread thread3 = node4.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node4 = node4.prev;
        }
        return thread2;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node node2 = this.tail;
        while (node2 != null) {
            if (node2.thread == thread) {
                return true;
            }
            node2 = node2.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node2;
        Node node3 = this.head;
        return node3 != null && (node2 = node3.next) != null && node2.nextWaiter != Node.SHARED;
    }

    final boolean isFirst(Thread thread) {
        Node node2;
        Node node3 = this.head;
        return node3 == null || (node2 = node3.next) != null && node2.thread == thread || this.fullIsFirst(thread);
    }

    final boolean fullIsFirst(Thread thread) {
        Node node2;
        Thread thread2 = null;
        Node node3 = this.head;
        if (node3 != null && (node2 = node3.next) != null && node2.prev == this.head && (thread2 = node2.thread) != null) {
            return thread2 == thread;
        }
        Node node4 = this.tail;
        while (node4 != null && node4 != this.head) {
            Thread thread3 = node4.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node4 = node4.prev;
        }
        return thread2 == thread || thread2 == null;
    }

    public final int getQueueLength() {
        int n = 0;
        Node node2 = this.tail;
        while (node2 != null) {
            if (node2.thread != null) {
                ++n;
            }
            node2 = node2.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node2 = this.tail;
        while (node2 != null) {
            Thread thread = node2.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node2 = node2.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node2 = this.tail;
        while (node2 != null) {
            Thread thread;
            if (!node2.isShared() && (thread = node2.thread) != null) {
                arrayList.add(thread);
            }
            node2 = node2.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node2 = this.tail;
        while (node2 != null) {
            Thread thread;
            if (node2.isShared() && (thread = node2.thread) != null) {
                arrayList.add(thread);
            }
            node2 = node2.prev;
        }
        return arrayList;
    }

    public String toString() {
        long l = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + l + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node2) {
        if (node2.waitStatus == -2 || node2.prev == null) {
            return false;
        }
        if (node2.next != null) {
            return true;
        }
        return this.findNodeFromTail(node2);
    }

    private boolean findNodeFromTail(Node node2) {
        Node node3 = this.tail;
        while (node3 != node2) {
            if (node3 == null) {
                return false;
            }
            node3 = node3.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node2) {
        if (!AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, -2, 0)) {
            return false;
        }
        Node node3 = this.enq(node2);
        int n = node3.waitStatus;
        if (n > 0 || !AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node3, n, -1)) {
            LockSupport.unpark(node2.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node2) {
        if (AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, -2, 0)) {
            this.enq(node2);
            return true;
        }
        while (!this.isOnSyncQueue(node2)) {
            Thread.yield();
        }
        return false;
    }

    final long fullyRelease(Node node2) {
        try {
            long l = this.getState();
            if (this.release(l)) {
                return l;
            }
        }
        catch (RuntimeException runtimeException) {
            node2.waitStatus = 1;
            throw runtimeException;
        }
        node2.waitStatus = 1;
        throw new IllegalMonitorStateException();
    }

    public final boolean owns(ConditionObject conditionObject) {
        if (conditionObject == null) {
            throw new NullPointerException();
        }
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node2) {
        return unsafe.compareAndSwapObject(this, headOffset, null, node2);
    }

    private final boolean compareAndSetTail(Node node2, Node node3) {
        return unsafe.compareAndSwapObject(this, tailOffset, node2, node3);
    }

    private static final boolean compareAndSetWaitStatus(Node node2, int n, int n2) {
        return unsafe.compareAndSwapInt(node2, waitStatusOffset, n, n2);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node node2 = new Node(Thread.currentThread(), -2);
            Node node3 = this.lastWaiter;
            if (node3 == null) {
                this.firstWaiter = node2;
            } else {
                node3.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node node2) {
            do {
                if ((this.firstWaiter = node2.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                node2.nextWaiter = null;
            } while (!AbstractQueuedLongSynchronizer.this.transferForSignal(node2) && (node2 = this.firstWaiter) != null);
        }

        private void doSignalAll(Node node2) {
            Node node3;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                node3 = node2.nextWaiter;
                node2.nextWaiter = null;
                AbstractQueuedLongSynchronizer.this.transferForSignal(node2);
            } while ((node2 = node3) != null);
        }

        private boolean isOnConditionQueue(Node node2) {
            return node2.next != null || node2 == this.lastWaiter;
        }

        private void unlinkCancelledWaiter(Node node2) {
            Node node3 = this.firstWaiter;
            Node node4 = null;
            while (node3 != null) {
                if (node3 == node2) {
                    Node node5 = node3.nextWaiter;
                    if (node4 == null) {
                        this.firstWaiter = node5;
                    } else {
                        node4.nextWaiter = node5;
                    }
                    if (this.lastWaiter != node2) break;
                    this.lastWaiter = node4;
                    break;
                }
                node4 = node3;
                node3 = node3.nextWaiter;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node2 = this.firstWaiter;
            if (node2 != null) {
                this.doSignal(node2);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node2 = this.firstWaiter;
            if (node2 != null) {
                this.doSignalAll(node2);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node2 = this.addConditionWaiter();
            long l = AbstractQueuedLongSynchronizer.this.fullyRelease(node2);
            boolean bl = false;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node2)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                bl = true;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node2, l) || bl) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node2) {
            return Thread.interrupted() ? (AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node2) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int n) throws InterruptedException {
            if (n == -1) {
                throw new InterruptedException();
            }
            if (n == 1) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            long l = AbstractQueuedLongSynchronizer.this.fullyRelease(node2);
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node2)) {
                LockSupport.park(this);
                n = this.checkInterruptWhileWaiting(node2);
                if (n == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node2, l) && n != -1) {
                n = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
        }

        @Override
        public final long awaitNanos(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            long l2 = AbstractQueuedLongSynchronizer.this.fullyRelease(node2);
            long l3 = System.nanoTime();
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node2)) {
                if (l <= 0L) {
                    AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkNanos(this, l);
                n = this.checkInterruptWhileWaiting(node2);
                if (n != 0) break;
                long l4 = System.nanoTime();
                l -= l4 - l3;
                l3 = l4;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node2, l2) && n != -1) {
                n = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return l - (System.nanoTime() - l3);
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            if (date == null) {
                throw new NullPointerException();
            }
            long l = date.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            long l2 = AbstractQueuedLongSynchronizer.this.fullyRelease(node2);
            boolean bl = false;
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node2)) {
                if (System.currentTimeMillis() > l) {
                    bl = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkUntil(this, l);
                n = this.checkInterruptWhileWaiting(node2);
                if (n == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node2, l2) && n != -1) {
                n = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return !bl;
        }

        @Override
        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            long l2 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            long l3 = AbstractQueuedLongSynchronizer.this.fullyRelease(node2);
            long l4 = System.nanoTime();
            boolean bl = false;
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node2)) {
                if (l2 <= 0L) {
                    bl = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkNanos(this, l2);
                n = this.checkInterruptWhileWaiting(node2);
                if (n != 0) break;
                long l5 = System.nanoTime();
                l2 -= l5 - l4;
                l4 = l5;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node2, l3) && n != -1) {
                n = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return !bl;
        }

        final boolean isOwnedBy(AbstractQueuedLongSynchronizer abstractQueuedLongSynchronizer) {
            return abstractQueuedLongSynchronizer == AbstractQueuedLongSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node2 = this.firstWaiter;
            while (node2 != null) {
                if (node2.waitStatus == -2) {
                    return true;
                }
                node2 = node2.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node node2 = this.firstWaiter;
            while (node2 != null) {
                if (node2.waitStatus == -2) {
                    ++n;
                }
                node2 = node2.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node2 = this.firstWaiter;
            while (node2 != null) {
                Thread thread;
                if (node2.waitStatus == -2 && (thread = node2.thread) != null) {
                    arrayList.add(thread);
                }
                node2 = node2.nextWaiter;
            }
            return arrayList;
        }
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node node2 = this.prev;
            if (node2 == null) {
                throw new NullPointerException();
            }
            return node2;
        }

        Node() {
        }

        Node(Thread thread, Node node2) {
            this.nextWaiter = node2;
            this.thread = thread;
        }

        Node(Thread thread, int n) {
            this.waitStatus = n;
            this.thread = thread;
        }
    }
}

