/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private transient E[] data;

    public CopyOnWriteArrayList() {
        this.data = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this.data = new Object[collection.size()];
        int n = 0;
        for (E e : collection) {
            this.data[n++] = e;
        }
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.data = (Object[])EArray.clone();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        E[] EArray = this.data;
        for (int i = 0; i < EArray.length; ++i) {
            if (!CopyOnWriteArrayList.equals(object, EArray[i])) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(E e, int n) {
        E[] EArray = this.data;
        for (int i = n; i < EArray.length; ++i) {
            if (!CopyOnWriteArrayList.equals(e, EArray[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        E[] EArray = this.data;
        for (int i = EArray.length - 1; i >= 0; --i) {
            if (!CopyOnWriteArrayList.equals(object, EArray[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(E e, int n) {
        E[] EArray = this.data;
        for (int i = n; i >= 0; --i) {
            if (!CopyOnWriteArrayList.equals(e, EArray[i])) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        CopyOnWriteArrayList copyOnWriteArrayList = null;
        try {
            copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copyOnWriteArrayList;
    }

    @Override
    public Object[] toArray() {
        E[] EArray = this.data;
        Object[] objectArray = new Object[EArray.length];
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.data;
        if (objectArray.length < EArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), EArray.length);
        } else if (objectArray.length > EArray.length) {
            objectArray[EArray.length] = null;
        }
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        return objectArray;
    }

    @Override
    public E get(int n) {
        return this.data[n];
    }

    @Override
    public synchronized E set(int n, E e) {
        E e2 = this.data[n];
        Object[] objectArray = (Object[])this.data.clone();
        objectArray[n] = e;
        this.data = objectArray;
        return e2;
    }

    @Override
    public synchronized boolean add(E e) {
        E[] EArray = this.data;
        Object[] objectArray = new Object[EArray.length + 1];
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        objectArray[EArray.length] = e;
        this.data = objectArray;
        return true;
    }

    @Override
    public synchronized void add(int n, E e) {
        E[] EArray = this.data;
        Object[] objectArray = new Object[EArray.length + 1];
        System.arraycopy(EArray, 0, objectArray, 0, n);
        objectArray[n] = e;
        System.arraycopy(EArray, n, objectArray, n + 1, EArray.length - n);
        this.data = objectArray;
    }

    @Override
    public synchronized E remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        E[] EArray = this.data;
        Object[] objectArray = new Object[EArray.length - 1];
        E e = EArray[n];
        if (n > 0) {
            System.arraycopy(EArray, 0, objectArray, 0, n);
        }
        System.arraycopy(EArray, n + 1, objectArray, n, EArray.length - n - 1);
        this.data = objectArray;
        return e;
    }

    @Override
    public synchronized boolean remove(Object object) {
        E[] EArray = this.data;
        int n = EArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray = new Object[n - 1];
        int n2 = -1;
        for (int i = 0; i < EArray.length; ++i) {
            if (CopyOnWriteArrayList.equals(object, EArray[i])) {
                n2 = i;
                break;
            }
            if (i >= objectArray.length) continue;
            objectArray[i] = EArray[i];
        }
        if (n2 < 0) {
            return false;
        }
        System.arraycopy(EArray, n2 + 1, objectArray, n2, EArray.length - n2 - 1);
        this.data = objectArray;
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        if (collection.size() == 0) {
            return false;
        }
        E[] EArray = this.data;
        Object[] objectArray = new Object[this.data.length];
        boolean bl = false;
        int n = 0;
        for (E e : EArray) {
            if (collection.contains(e)) {
                bl = true;
                continue;
            }
            objectArray[n++] = e;
        }
        if (!bl) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        this.data = objectArray2;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        if (collection.size() == 0) {
            this.clear();
            return true;
        }
        E[] EArray = this.data;
        Object[] objectArray = new Object[this.data.length];
        int n = 0;
        for (E e : EArray) {
            if (!collection.contains(e)) continue;
            objectArray[n++] = e;
        }
        if (n == EArray.length) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        this.data = objectArray2;
        return true;
    }

    @Override
    public synchronized void clear() {
        this.data = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.data.length, collection);
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        E[] EArray = this.data;
        Iterator<? extends E> iterator = collection.iterator();
        Object[] objectArray = new Object[EArray.length + n2];
        if (n != 0) {
            System.arraycopy(EArray, 0, objectArray, 0, n);
        }
        int n3 = n;
        for (E e : collection) {
            objectArray[n++] = e;
        }
        System.arraycopy(EArray, n3, objectArray, 0, EArray.length - n3);
        this.data = objectArray;
        return true;
    }

    public synchronized boolean addIfAbsent(E e) {
        if (this.contains(e)) {
            return false;
        }
        this.add(e);
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> collection) {
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        E[] EArray = this.data;
        Object[] objectArray = new Object[n];
        n = 0;
        for (E e : collection) {
            if (this.contains(e)) continue;
            objectArray[n++] = e;
        }
        if (n == 0) {
            return 0;
        }
        Object[] objectArray2 = new Object[EArray.length + n];
        System.arraycopy(EArray, 0, objectArray2, 0, EArray.length);
        System.arraycopy(objectArray, 0, objectArray2, EArray.length, n);
        this.data = objectArray2;
        return n;
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list2 = (List)object;
            if (list2.size() != this.size()) {
                return false;
            }
            Iterator iterator = list2.iterator();
            for (E e : this) {
                if (e.equals(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (E e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            E[] iteratorData;
            int currentElement;
            {
                this.iteratorData = CopyOnWriteArrayList.this.data;
                this.currentElement = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentElement < this.iteratorData.length;
            }

            @Override
            public E next() {
                return this.iteratorData[this.currentElement++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size());
        }
        return new ListIterator<E>(){
            E[] iteratorData;
            int currentElement;
            {
                this.iteratorData = CopyOnWriteArrayList.this.data;
                this.currentElement = n;
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }

            @Override
            public boolean hasNext() {
                return this.currentElement < this.iteratorData.length;
            }

            @Override
            public boolean hasPrevious() {
                return this.currentElement > 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iteratorData[this.currentElement++];
            }

            @Override
            public int nextIndex() {
                return this.currentElement + 1;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.iteratorData[--this.currentElement];
            }

            @Override
            public int previousIndex() {
                return this.currentElement - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }
        };
    }

    @Override
    public synchronized List<E> subList(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException(n + " > " + n2);
        }
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, n, n2);
        }
        return new SubList(this, n, n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < this.data.length; ++i) {
            objectOutputStream.writeObject(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = objectInputStream.readObject();
        }
    }

    static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    Object[] getArray() {
        return this.data;
    }

    static /* synthetic */ Object[] access$002(CopyOnWriteArrayList copyOnWriteArrayList, Object[] objectArray) {
        copyOnWriteArrayList.data = objectArray;
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RandomAccessSubList<E>
    extends SubList<E>
    implements RandomAccess {
        RandomAccessSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            super(copyOnWriteArrayList, n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubList<E>
    extends AbstractList<E> {
        final CopyOnWriteArrayList<E> backingList;
        final int offset;
        int size;
        E[] data;

        SubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n, int n2) {
            this.backingList = copyOnWriteArrayList;
            this.data = ((CopyOnWriteArrayList)copyOnWriteArrayList).data;
            this.offset = n;
            this.size = n2 - n;
        }

        void checkMod() {
            if (this.data != ((CopyOnWriteArrayList)this.backingList).data) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int n) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                Object[] objectArray = ((CopyOnWriteArrayList)this.backingList).data;
                Object[] objectArray2 = new Object[objectArray.length - this.size];
                int n = this.size + this.offset;
                System.arraycopy(objectArray, 0, objectArray2, 0, this.offset);
                System.arraycopy(objectArray, n, objectArray2, this.offset, objectArray.length - n);
                CopyOnWriteArrayList.access$002(this.backingList, objectArray2);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(n);
                E e2 = this.backingList.set(n + this.offset, e);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                return e2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(n);
                return this.backingList.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsInclusive(n);
                this.backingList.add(n + this.offset, e);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(n);
                E e = this.backingList.remove(n + this.offset);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                --this.size;
                return e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsInclusive(n);
                int n2 = collection.size();
                boolean bl = this.backingList.addAll(this.offset + n, collection);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                this.size += n2;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                return this.addAll(this.size, collection);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            return new ListIterator<E>(){
                private final ListIterator<E> i;
                private int position;
                {
                    this.i = SubList.this.backingList.listIterator(n + SubList.this.offset);
                    this.position = n;
                }

                @Override
                public boolean hasNext() {
                    return this.position < SubList.this.size;
                }

                @Override
                public boolean hasPrevious() {
                    return this.position > 0;
                }

                @Override
                public E next() {
                    if (this.position == SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                @Override
                public E previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }
            };
        }
    }
}

