/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "head");
    private volatile transient Node<E> head = new Node<Object>(null, null);
    private volatile transient Node<E> tail = this.head;

    private boolean casTail(Node<E> node2, Node<E> node3) {
        return tailUpdater.compareAndSet(this, node2, node3);
    }

    private boolean casHead(Node<E> node2, Node<E> node3) {
        return headUpdater.compareAndSet(this, node2, node3);
    }

    public ConcurrentLinkedQueue() {
    }

    public ConcurrentLinkedQueue(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node2 = new Node<E>(e, null);
        while (true) {
            Node<E> node3 = this.tail;
            Node<E> node4 = node3.getNext();
            if (node3 != this.tail) continue;
            if (node4 == null) {
                if (!node3.casNext(node4, node2)) continue;
                this.casTail(node3, node2);
                return true;
            }
            this.casTail(node3, node4);
        }
    }

    @Override
    public E poll() {
        E e;
        Node<E> node2;
        while (true) {
            Node<E> node3 = this.head;
            Node<E> node4 = this.tail;
            node2 = node3.getNext();
            if (node3 != this.head) continue;
            if (node3 == node4) {
                if (node2 == null) {
                    return null;
                }
                this.casTail(node4, node2);
                continue;
            }
            if (this.casHead(node3, node2) && (e = node2.getItem()) != null) break;
        }
        node2.setItem(null);
        return e;
    }

    @Override
    public E peek() {
        while (true) {
            Node<E> node2 = this.head;
            Node<E> node3 = this.tail;
            Node<E> node4 = node2.getNext();
            if (node2 != this.head) continue;
            if (node2 == node3) {
                if (node4 == null) {
                    return null;
                }
                this.casTail(node3, node4);
                continue;
            }
            E e = node4.getItem();
            if (e != null) {
                return e;
            }
            this.casHead(node2, node4);
        }
    }

    Node<E> first() {
        while (true) {
            Node<E> node2 = this.head;
            Node<E> node3 = this.tail;
            Node<E> node4 = node2.getNext();
            if (node2 != this.head) continue;
            if (node2 == node3) {
                if (node4 == null) {
                    return null;
                }
                this.casTail(node3, node4);
                continue;
            }
            if (node4.getItem() != null) {
                return node4;
            }
            this.casHead(node2, node4);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int n = 0;
        for (Node<E> node2 = this.first(); node2 != null && (node2.getItem() == null || ++n != Integer.MAX_VALUE); node2 = node2.getNext()) {
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        for (Node<E> node2 = this.first(); node2 != null; node2 = node2.getNext()) {
            E e = node2.getItem();
            if (e == null || !object.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        for (Node<E> node2 = this.first(); node2 != null; node2 = node2.getNext()) {
            E e = node2.getItem();
            if (e == null || !object.equals(e) || !node2.casItem(e, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (Node<E> node2 = this.first(); node2 != null; node2 = node2.getNext()) {
            E e = node2.getItem();
            if (e == null) continue;
            objectOutputStream.writeObject(e);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.head = new Node<Object>(null, null);
        this.tail = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node node2;
            this.lastRet = this.nextNode;
            Object e = this.nextItem;
            Node node3 = node2 = this.nextNode == null ? ConcurrentLinkedQueue.this.first() : this.nextNode.getNext();
            while (true) {
                if (node2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return e;
                }
                Object e2 = node2.getItem();
                if (e2 != null) {
                    this.nextNode = node2;
                    this.nextItem = e2;
                    return e;
                }
                node2 = node2.getNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node<Object> node2 = this.lastRet;
            if (node2 == null) {
                throw new IllegalStateException();
            }
            node2.setItem(null);
            this.lastRet = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        private volatile E item;
        private volatile Node<E> next;
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater<Node, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");

        Node(E e) {
            this.item = e;
        }

        Node(E e, Node<E> node2) {
            this.item = e;
            this.next = node2;
        }

        E getItem() {
            return this.item;
        }

        boolean casItem(E e, E e2) {
            return itemUpdater.compareAndSet(this, e, e2);
        }

        void setItem(E e) {
            itemUpdater.set(this, e);
        }

        Node<E> getNext() {
            return this.next;
        }

        boolean casNext(Node<E> node2, Node<E> node3) {
            return nextUpdater.compareAndSet(this, node2, node3);
        }

        void setNext(Node<E> node2) {
            nextUpdater.set(this, node2);
        }
    }
}

