/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.util.ZoneInfo;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;
import java.util.VMTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private String ID;
    private static TimeZone defaultZone0;
    private static final long serialVersionUID = 3581463369166924961L;
    private static String zoneinfo_dir;
    private static String[] availableIDs;
    private static HashMap aliases0;
    private static HashMap timezones0;

    private static synchronized TimeZone defaultZone() {
        if (defaultZone0 == null) {
            defaultZone0 = (TimeZone)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    TimeZone timeZone = null;
                    String string = System.getProperty("user.timezone");
                    if (string != null && !string.equals("")) {
                        timeZone = TimeZone.getDefaultTimeZone(string);
                    }
                    if (timeZone == null) {
                        timeZone = VMTimeZone.getDefaultTimeZoneId();
                    }
                    if (timeZone == null) {
                        timeZone = TimeZone.getTimeZone("GMT");
                    }
                    return timeZone;
                }
            });
        }
        return defaultZone0;
    }

    static HashMap timezones() {
        if (timezones0 == null) {
            HashMap hashMap;
            timezones0 = hashMap = new HashMap();
            zoneinfo_dir = SystemProperties.getProperty("gnu.java.util.zoneinfo.dir");
            if (zoneinfo_dir != null && !new File(zoneinfo_dir).isDirectory()) {
                zoneinfo_dir = null;
            }
            if (zoneinfo_dir != null) {
                aliases0 = new HashMap();
                aliases0.put("ACT", "Australia/Darwin");
                aliases0.put("AET", "Australia/Sydney");
                aliases0.put("AGT", "America/Argentina/Buenos_Aires");
                aliases0.put("ART", "Africa/Cairo");
                aliases0.put("AST", "America/Juneau");
                aliases0.put("BST", "Asia/Colombo");
                aliases0.put("CAT", "Africa/Gaborone");
                aliases0.put("CNT", "America/St_Johns");
                aliases0.put("CST", "CST6CDT");
                aliases0.put("CTT", "Asia/Brunei");
                aliases0.put("EAT", "Indian/Comoro");
                aliases0.put("ECT", "CET");
                aliases0.put("EST", "EST5EDT");
                aliases0.put("EST5", "EST5EDT");
                aliases0.put("IET", "EST5EDT");
                aliases0.put("IST", "Asia/Calcutta");
                aliases0.put("JST", "Asia/Seoul");
                aliases0.put("MIT", "Pacific/Niue");
                aliases0.put("MST", "MST7MDT");
                aliases0.put("MST7", "MST7MDT");
                aliases0.put("NET", "Indian/Mauritius");
                aliases0.put("NST", "Pacific/Auckland");
                aliases0.put("PLT", "Indian/Kerguelen");
                aliases0.put("PNT", "MST7MDT");
                aliases0.put("PRT", "America/Anguilla");
                aliases0.put("PST", "PST8PDT");
                aliases0.put("SST", "Pacific/Ponape");
                aliases0.put("VST", "Asia/Bangkok");
                return hashMap;
            }
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(-39600000, "MIT");
            timezones0.put("MIT", simpleTimeZone);
            timezones0.put("Pacific/Apia", simpleTimeZone);
            timezones0.put("Pacific/Midway", simpleTimeZone);
            timezones0.put("Pacific/Niue", simpleTimeZone);
            timezones0.put("Pacific/Pago_Pago", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-36000000, "America/Adak", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Adak", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-36000000, "HST");
            timezones0.put("HST", simpleTimeZone);
            timezones0.put("Pacific/Fakaofo", simpleTimeZone);
            timezones0.put("Pacific/Honolulu", simpleTimeZone);
            timezones0.put("Pacific/Johnston", simpleTimeZone);
            timezones0.put("Pacific/Rarotonga", simpleTimeZone);
            timezones0.put("Pacific/Tahiti", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-34200000, "Pacific/Marquesas");
            timezones0.put("Pacific/Marquesas", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-32400000, "AST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("AST", simpleTimeZone);
            timezones0.put("America/Anchorage", simpleTimeZone);
            timezones0.put("America/Juneau", simpleTimeZone);
            timezones0.put("America/Nome", simpleTimeZone);
            timezones0.put("America/Yakutat", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-32400000, "Pacific/Gambier");
            timezones0.put("Pacific/Gambier", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-28800000, "America/Tijuana", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Tijuana", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-28800000, "PST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("PST", simpleTimeZone);
            timezones0.put("PST8PDT", simpleTimeZone);
            timezones0.put("America/Dawson", simpleTimeZone);
            timezones0.put("America/Los_Angeles", simpleTimeZone);
            timezones0.put("America/Vancouver", simpleTimeZone);
            timezones0.put("America/Whitehorse", simpleTimeZone);
            timezones0.put("US/Pacific-New", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-28800000, "Pacific/Pitcairn");
            timezones0.put("Pacific/Pitcairn", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-25200000, "America/Chihuahua", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Chihuahua", simpleTimeZone);
            timezones0.put("America/Mazatlan", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-25200000, "MST7");
            timezones0.put("MST7", simpleTimeZone);
            timezones0.put("PNT", simpleTimeZone);
            timezones0.put("America/Dawson_Creek", simpleTimeZone);
            timezones0.put("America/Hermosillo", simpleTimeZone);
            timezones0.put("America/Phoenix", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-25200000, "MST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("MST", simpleTimeZone);
            timezones0.put("MST7MDT", simpleTimeZone);
            timezones0.put("America/Boise", simpleTimeZone);
            timezones0.put("America/Cambridge_Bay", simpleTimeZone);
            timezones0.put("America/Denver", simpleTimeZone);
            timezones0.put("America/Edmonton", simpleTimeZone);
            timezones0.put("America/Inuvik", simpleTimeZone);
            timezones0.put("America/Shiprock", simpleTimeZone);
            timezones0.put("America/Yellowknife", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-21600000, "America/Cancun", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Cancun", simpleTimeZone);
            timezones0.put("America/Merida", simpleTimeZone);
            timezones0.put("America/Mexico_City", simpleTimeZone);
            timezones0.put("America/Monterrey", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-21600000, "America/Belize");
            timezones0.put("America/Belize", simpleTimeZone);
            timezones0.put("America/Costa_Rica", simpleTimeZone);
            timezones0.put("America/El_Salvador", simpleTimeZone);
            timezones0.put("America/Guatemala", simpleTimeZone);
            timezones0.put("America/Managua", simpleTimeZone);
            timezones0.put("America/Regina", simpleTimeZone);
            timezones0.put("America/Swift_Current", simpleTimeZone);
            timezones0.put("America/Tegucigalpa", simpleTimeZone);
            timezones0.put("Pacific/Galapagos", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-21600000, "CST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("CST", simpleTimeZone);
            timezones0.put("CST6CDT", simpleTimeZone);
            timezones0.put("America/Chicago", simpleTimeZone);
            timezones0.put("America/Indiana/Knox", simpleTimeZone);
            timezones0.put("America/Indiana/Petersburg", simpleTimeZone);
            timezones0.put("America/Indiana/Vincennes", simpleTimeZone);
            timezones0.put("America/Menominee", simpleTimeZone);
            timezones0.put("America/North_Dakota/Center", simpleTimeZone);
            timezones0.put("America/North_Dakota/New_Salem", simpleTimeZone);
            timezones0.put("America/Rainy_River", simpleTimeZone);
            timezones0.put("America/Rankin_Inlet", simpleTimeZone);
            timezones0.put("America/Winnipeg", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-21600000, "Pacific/Easter", 9, 2, 7, 79200000, 2, 2, 7, 79200000);
            timezones0.put("Pacific/Easter", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-18000000, "EST5");
            timezones0.put("EST5", simpleTimeZone);
            timezones0.put("IET", simpleTimeZone);
            timezones0.put("America/Atikokan", simpleTimeZone);
            timezones0.put("America/Bogota", simpleTimeZone);
            timezones0.put("America/Cayman", simpleTimeZone);
            timezones0.put("America/Eirunepe", simpleTimeZone);
            timezones0.put("America/Guayaquil", simpleTimeZone);
            timezones0.put("America/Jamaica", simpleTimeZone);
            timezones0.put("America/Lima", simpleTimeZone);
            timezones0.put("America/Panama", simpleTimeZone);
            timezones0.put("America/Rio_Branco", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-18000000, "America/Havana", 3, 1, 1, 0, 9, -1, 1, 3600000);
            timezones0.put("America/Havana", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-18000000, "America/Grand_Turk", 3, 1, 1, 0, 9, -1, 1, 0);
            timezones0.put("America/Grand_Turk", simpleTimeZone);
            timezones0.put("America/Port-au-Prince", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-18000000, "EST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("EST", simpleTimeZone);
            timezones0.put("EST5EDT", simpleTimeZone);
            timezones0.put("America/Detroit", simpleTimeZone);
            timezones0.put("America/Indiana/Indianapolis", simpleTimeZone);
            timezones0.put("America/Indiana/Marengo", simpleTimeZone);
            timezones0.put("America/Indiana/Vevay", simpleTimeZone);
            timezones0.put("America/Iqaluit", simpleTimeZone);
            timezones0.put("America/Kentucky/Louisville", simpleTimeZone);
            timezones0.put("America/Kentucky/Monticello", simpleTimeZone);
            timezones0.put("America/Montreal", simpleTimeZone);
            timezones0.put("America/Nassau", simpleTimeZone);
            timezones0.put("America/New_York", simpleTimeZone);
            timezones0.put("America/Nipigon", simpleTimeZone);
            timezones0.put("America/Pangnirtung", simpleTimeZone);
            timezones0.put("America/Thunder_Bay", simpleTimeZone);
            timezones0.put("America/Toronto", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "America/Asuncion", 9, 3, 1, 0, 2, 2, 1, 0);
            timezones0.put("America/Asuncion", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "PRT");
            timezones0.put("PRT", simpleTimeZone);
            timezones0.put("America/Anguilla", simpleTimeZone);
            timezones0.put("America/Antigua", simpleTimeZone);
            timezones0.put("America/Aruba", simpleTimeZone);
            timezones0.put("America/Barbados", simpleTimeZone);
            timezones0.put("America/Blanc-Sablon", simpleTimeZone);
            timezones0.put("America/Boa_Vista", simpleTimeZone);
            timezones0.put("America/Caracas", simpleTimeZone);
            timezones0.put("America/Curacao", simpleTimeZone);
            timezones0.put("America/Dominica", simpleTimeZone);
            timezones0.put("America/Grenada", simpleTimeZone);
            timezones0.put("America/Guadeloupe", simpleTimeZone);
            timezones0.put("America/Guyana", simpleTimeZone);
            timezones0.put("America/La_Paz", simpleTimeZone);
            timezones0.put("America/Manaus", simpleTimeZone);
            timezones0.put("America/Martinique", simpleTimeZone);
            timezones0.put("America/Montserrat", simpleTimeZone);
            timezones0.put("America/Port_of_Spain", simpleTimeZone);
            timezones0.put("America/Porto_Velho", simpleTimeZone);
            timezones0.put("America/Puerto_Rico", simpleTimeZone);
            timezones0.put("America/Santo_Domingo", simpleTimeZone);
            timezones0.put("America/St_Kitts", simpleTimeZone);
            timezones0.put("America/St_Lucia", simpleTimeZone);
            timezones0.put("America/St_Thomas", simpleTimeZone);
            timezones0.put("America/St_Vincent", simpleTimeZone);
            timezones0.put("America/Tortola", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "America/Campo_Grande", 10, 1, 1, 0, 1, -1, 1, 0);
            timezones0.put("America/Campo_Grande", simpleTimeZone);
            timezones0.put("America/Cuiaba", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "America/Goose_Bay", 2, 2, 1, 60000, 10, 1, 1, 60000);
            timezones0.put("America/Goose_Bay", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "America/Glace_Bay", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Glace_Bay", simpleTimeZone);
            timezones0.put("America/Halifax", simpleTimeZone);
            timezones0.put("America/Moncton", simpleTimeZone);
            timezones0.put("America/Thule", simpleTimeZone);
            timezones0.put("Atlantic/Bermuda", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "America/Santiago", 9, 9, -1, 0, 2, 9, -1, 0);
            timezones0.put("America/Santiago", simpleTimeZone);
            timezones0.put("Antarctica/Palmer", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-14400000, "Atlantic/Stanley", 8, 1, 1, 0x6DDD00, 3, 3, 1, 0x6DDD00);
            timezones0.put("Atlantic/Stanley", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-12600000, "CNT", 2, 2, 1, 60000, 10, 1, 1, 60000);
            timezones0.put("CNT", simpleTimeZone);
            timezones0.put("America/St_Johns", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-10800000, "America/Godthab", 2, 30, -7, 79200000, 9, 30, -7, 82800000);
            timezones0.put("America/Godthab", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-10800000, "America/Miquelon", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Miquelon", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-10800000, "America/Montevideo", 9, 1, 1, 0x6DDD00, 2, 2, 1, 0x6DDD00);
            timezones0.put("America/Montevideo", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-10800000, "America/Sao_Paulo", 10, 1, 1, 0, 1, -1, 1, 0);
            timezones0.put("America/Sao_Paulo", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-10800000, "AGT");
            timezones0.put("AGT", simpleTimeZone);
            timezones0.put("America/Araguaina", simpleTimeZone);
            timezones0.put("America/Argentina/Buenos_Aires", simpleTimeZone);
            timezones0.put("America/Argentina/Catamarca", simpleTimeZone);
            timezones0.put("America/Argentina/Cordoba", simpleTimeZone);
            timezones0.put("America/Argentina/Jujuy", simpleTimeZone);
            timezones0.put("America/Argentina/La_Rioja", simpleTimeZone);
            timezones0.put("America/Argentina/Mendoza", simpleTimeZone);
            timezones0.put("America/Argentina/Rio_Gallegos", simpleTimeZone);
            timezones0.put("America/Argentina/San_Juan", simpleTimeZone);
            timezones0.put("America/Argentina/Tucuman", simpleTimeZone);
            timezones0.put("America/Argentina/Ushuaia", simpleTimeZone);
            timezones0.put("America/Bahia", simpleTimeZone);
            timezones0.put("America/Belem", simpleTimeZone);
            timezones0.put("America/Cayenne", simpleTimeZone);
            timezones0.put("America/Fortaleza", simpleTimeZone);
            timezones0.put("America/Maceio", simpleTimeZone);
            timezones0.put("America/Paramaribo", simpleTimeZone);
            timezones0.put("America/Recife", simpleTimeZone);
            timezones0.put("Antarctica/Rothera", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-7200000, "America/Noronha");
            timezones0.put("America/Noronha", simpleTimeZone);
            timezones0.put("Atlantic/South_Georgia", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-3600000, "America/Scoresbysund", 2, -1, 1, 0, 9, -1, 1, 3600000);
            timezones0.put("America/Scoresbysund", simpleTimeZone);
            timezones0.put("Atlantic/Azores", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde");
            timezones0.put("Atlantic/Cape_Verde", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0, "GMT");
            timezones0.put("GMT", simpleTimeZone);
            timezones0.put("UTC", simpleTimeZone);
            timezones0.put("Africa/Abidjan", simpleTimeZone);
            timezones0.put("Africa/Accra", simpleTimeZone);
            timezones0.put("Africa/Bamako", simpleTimeZone);
            timezones0.put("Africa/Banjul", simpleTimeZone);
            timezones0.put("Africa/Bissau", simpleTimeZone);
            timezones0.put("Africa/Casablanca", simpleTimeZone);
            timezones0.put("Africa/Conakry", simpleTimeZone);
            timezones0.put("Africa/Dakar", simpleTimeZone);
            timezones0.put("Africa/El_Aaiun", simpleTimeZone);
            timezones0.put("Africa/Freetown", simpleTimeZone);
            timezones0.put("Africa/Lome", simpleTimeZone);
            timezones0.put("Africa/Monrovia", simpleTimeZone);
            timezones0.put("Africa/Nouakchott", simpleTimeZone);
            timezones0.put("Africa/Ouagadougou", simpleTimeZone);
            timezones0.put("Africa/Sao_Tome", simpleTimeZone);
            timezones0.put("America/Danmarkshavn", simpleTimeZone);
            timezones0.put("Atlantic/Reykjavik", simpleTimeZone);
            timezones0.put("Atlantic/St_Helena", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 0x6DDD00);
            timezones0.put("WET", simpleTimeZone);
            timezones0.put("Atlantic/Canary", simpleTimeZone);
            timezones0.put("Atlantic/Faroe", simpleTimeZone);
            timezones0.put("Atlantic/Madeira", simpleTimeZone);
            timezones0.put("Europe/Dublin", simpleTimeZone);
            timezones0.put("Europe/Guernsey", simpleTimeZone);
            timezones0.put("Europe/Isle_of_Man", simpleTimeZone);
            timezones0.put("Europe/Jersey", simpleTimeZone);
            timezones0.put("Europe/Lisbon", simpleTimeZone);
            timezones0.put("Europe/London", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(3600000, "Africa/Algiers");
            timezones0.put("Africa/Algiers", simpleTimeZone);
            timezones0.put("Africa/Bangui", simpleTimeZone);
            timezones0.put("Africa/Brazzaville", simpleTimeZone);
            timezones0.put("Africa/Douala", simpleTimeZone);
            timezones0.put("Africa/Kinshasa", simpleTimeZone);
            timezones0.put("Africa/Lagos", simpleTimeZone);
            timezones0.put("Africa/Libreville", simpleTimeZone);
            timezones0.put("Africa/Luanda", simpleTimeZone);
            timezones0.put("Africa/Malabo", simpleTimeZone);
            timezones0.put("Africa/Ndjamena", simpleTimeZone);
            timezones0.put("Africa/Niamey", simpleTimeZone);
            timezones0.put("Africa/Porto-Novo", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(3600000, "Africa/Windhoek", 8, 1, 1, 0x6DDD00, 3, 1, 1, 0x6DDD00);
            timezones0.put("Africa/Windhoek", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("CET", simpleTimeZone);
            timezones0.put("ECT", simpleTimeZone);
            timezones0.put("MET", simpleTimeZone);
            timezones0.put("Africa/Ceuta", simpleTimeZone);
            timezones0.put("Africa/Tunis", simpleTimeZone);
            timezones0.put("Arctic/Longyearbyen", simpleTimeZone);
            timezones0.put("Atlantic/Jan_Mayen", simpleTimeZone);
            timezones0.put("Europe/Amsterdam", simpleTimeZone);
            timezones0.put("Europe/Andorra", simpleTimeZone);
            timezones0.put("Europe/Belgrade", simpleTimeZone);
            timezones0.put("Europe/Berlin", simpleTimeZone);
            timezones0.put("Europe/Bratislava", simpleTimeZone);
            timezones0.put("Europe/Brussels", simpleTimeZone);
            timezones0.put("Europe/Budapest", simpleTimeZone);
            timezones0.put("Europe/Copenhagen", simpleTimeZone);
            timezones0.put("Europe/Gibraltar", simpleTimeZone);
            timezones0.put("Europe/Ljubljana", simpleTimeZone);
            timezones0.put("Europe/Luxembourg", simpleTimeZone);
            timezones0.put("Europe/Madrid", simpleTimeZone);
            timezones0.put("Europe/Malta", simpleTimeZone);
            timezones0.put("Europe/Monaco", simpleTimeZone);
            timezones0.put("Europe/Oslo", simpleTimeZone);
            timezones0.put("Europe/Paris", simpleTimeZone);
            timezones0.put("Europe/Podgorica", simpleTimeZone);
            timezones0.put("Europe/Prague", simpleTimeZone);
            timezones0.put("Europe/Rome", simpleTimeZone);
            timezones0.put("Europe/San_Marino", simpleTimeZone);
            timezones0.put("Europe/Sarajevo", simpleTimeZone);
            timezones0.put("Europe/Skopje", simpleTimeZone);
            timezones0.put("Europe/Stockholm", simpleTimeZone);
            timezones0.put("Europe/Tirane", simpleTimeZone);
            timezones0.put("Europe/Vaduz", simpleTimeZone);
            timezones0.put("Europe/Vatican", simpleTimeZone);
            timezones0.put("Europe/Vienna", simpleTimeZone);
            timezones0.put("Europe/Warsaw", simpleTimeZone);
            timezones0.put("Europe/Zagreb", simpleTimeZone);
            timezones0.put("Europe/Zurich", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "ART", 3, -1, 6, 0, 8, -1, 5, 86400000);
            timezones0.put("ART", simpleTimeZone);
            timezones0.put("Africa/Cairo", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "CAT");
            timezones0.put("CAT", simpleTimeZone);
            timezones0.put("Africa/Blantyre", simpleTimeZone);
            timezones0.put("Africa/Bujumbura", simpleTimeZone);
            timezones0.put("Africa/Gaborone", simpleTimeZone);
            timezones0.put("Africa/Harare", simpleTimeZone);
            timezones0.put("Africa/Johannesburg", simpleTimeZone);
            timezones0.put("Africa/Kigali", simpleTimeZone);
            timezones0.put("Africa/Lubumbashi", simpleTimeZone);
            timezones0.put("Africa/Lusaka", simpleTimeZone);
            timezones0.put("Africa/Maputo", simpleTimeZone);
            timezones0.put("Africa/Maseru", simpleTimeZone);
            timezones0.put("Africa/Mbabane", simpleTimeZone);
            timezones0.put("Africa/Tripoli", simpleTimeZone);
            timezones0.put("Asia/Jerusalem", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "Asia/Amman", 2, -1, 5, 0, 9, -1, 6, 3600000);
            timezones0.put("Asia/Amman", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "Asia/Beirut", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Beirut", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "Asia/Damascus", 3, 1, 0, 0, 9, 1, 0, 0);
            timezones0.put("Asia/Damascus", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "Asia/Gaza", 3, 1, 0, 0, 9, 3, 6, 0);
            timezones0.put("Asia/Gaza", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 10800000, 9, -1, 1, 14400000);
            timezones0.put("EET", simpleTimeZone);
            timezones0.put("Asia/Istanbul", simpleTimeZone);
            timezones0.put("Asia/Nicosia", simpleTimeZone);
            timezones0.put("Europe/Athens", simpleTimeZone);
            timezones0.put("Europe/Bucharest", simpleTimeZone);
            timezones0.put("Europe/Chisinau", simpleTimeZone);
            timezones0.put("Europe/Helsinki", simpleTimeZone);
            timezones0.put("Europe/Istanbul", simpleTimeZone);
            timezones0.put("Europe/Kiev", simpleTimeZone);
            timezones0.put("Europe/Mariehamn", simpleTimeZone);
            timezones0.put("Europe/Nicosia", simpleTimeZone);
            timezones0.put("Europe/Riga", simpleTimeZone);
            timezones0.put("Europe/Simferopol", simpleTimeZone);
            timezones0.put("Europe/Sofia", simpleTimeZone);
            timezones0.put("Europe/Tallinn", simpleTimeZone);
            timezones0.put("Europe/Uzhgorod", simpleTimeZone);
            timezones0.put("Europe/Vilnius", simpleTimeZone);
            timezones0.put("Europe/Zaporozhye", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(0x6DDD00, "Europe/Kaliningrad", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Europe/Kaliningrad", simpleTimeZone);
            timezones0.put("Europe/Minsk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(10800000, "Asia/Baghdad", 3, 1, 0, 10800000, 9, 1, 0, 14400000);
            timezones0.put("Asia/Baghdad", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(10800000, "Europe/Moscow", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Europe/Moscow", simpleTimeZone);
            timezones0.put("Europe/Volgograd", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(10800000, "EAT");
            timezones0.put("EAT", simpleTimeZone);
            timezones0.put("Africa/Addis_Ababa", simpleTimeZone);
            timezones0.put("Africa/Asmara", simpleTimeZone);
            timezones0.put("Africa/Dar_es_Salaam", simpleTimeZone);
            timezones0.put("Africa/Djibouti", simpleTimeZone);
            timezones0.put("Africa/Kampala", simpleTimeZone);
            timezones0.put("Africa/Khartoum", simpleTimeZone);
            timezones0.put("Africa/Mogadishu", simpleTimeZone);
            timezones0.put("Africa/Nairobi", simpleTimeZone);
            timezones0.put("Antarctica/Syowa", simpleTimeZone);
            timezones0.put("Asia/Aden", simpleTimeZone);
            timezones0.put("Asia/Bahrain", simpleTimeZone);
            timezones0.put("Asia/Kuwait", simpleTimeZone);
            timezones0.put("Asia/Qatar", simpleTimeZone);
            timezones0.put("Asia/Riyadh", simpleTimeZone);
            timezones0.put("Indian/Antananarivo", simpleTimeZone);
            timezones0.put("Indian/Comoro", simpleTimeZone);
            timezones0.put("Indian/Mayotte", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(12600000, "Asia/Tehran");
            timezones0.put("Asia/Tehran", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(14400000, "Asia/Baku", 2, -1, 1, 14400000, 9, -1, 1, 18000000);
            timezones0.put("Asia/Baku", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(14400000, "Asia/Yerevan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yerevan", simpleTimeZone);
            timezones0.put("Europe/Samara", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(14400000, "NET");
            timezones0.put("NET", simpleTimeZone);
            timezones0.put("Asia/Dubai", simpleTimeZone);
            timezones0.put("Asia/Muscat", simpleTimeZone);
            timezones0.put("Asia/Tbilisi", simpleTimeZone);
            timezones0.put("Indian/Mahe", simpleTimeZone);
            timezones0.put("Indian/Mauritius", simpleTimeZone);
            timezones0.put("Indian/Reunion", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(16200000, "Asia/Kabul");
            timezones0.put("Asia/Kabul", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(18000000, "Asia/Yekaterinburg", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yekaterinburg", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(18000000, "PLT");
            timezones0.put("PLT", simpleTimeZone);
            timezones0.put("Asia/Aqtau", simpleTimeZone);
            timezones0.put("Asia/Aqtobe", simpleTimeZone);
            timezones0.put("Asia/Ashgabat", simpleTimeZone);
            timezones0.put("Asia/Dushanbe", simpleTimeZone);
            timezones0.put("Asia/Karachi", simpleTimeZone);
            timezones0.put("Asia/Oral", simpleTimeZone);
            timezones0.put("Asia/Samarkand", simpleTimeZone);
            timezones0.put("Asia/Tashkent", simpleTimeZone);
            timezones0.put("Indian/Kerguelen", simpleTimeZone);
            timezones0.put("Indian/Maldives", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(19800000, "BST");
            timezones0.put("BST", simpleTimeZone);
            timezones0.put("IST", simpleTimeZone);
            timezones0.put("Asia/Calcutta", simpleTimeZone);
            timezones0.put("Asia/Colombo", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(20700000, "Asia/Katmandu");
            timezones0.put("Asia/Katmandu", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(21600000, "Antarctica/Mawson");
            timezones0.put("Antarctica/Mawson", simpleTimeZone);
            timezones0.put("Antarctica/Vostok", simpleTimeZone);
            timezones0.put("Asia/Almaty", simpleTimeZone);
            timezones0.put("Asia/Bishkek", simpleTimeZone);
            timezones0.put("Asia/Dhaka", simpleTimeZone);
            timezones0.put("Asia/Qyzylorda", simpleTimeZone);
            timezones0.put("Asia/Thimphu", simpleTimeZone);
            timezones0.put("Indian/Chagos", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(21600000, "Asia/Novosibirsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Novosibirsk", simpleTimeZone);
            timezones0.put("Asia/Omsk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(23400000, "Asia/Rangoon");
            timezones0.put("Asia/Rangoon", simpleTimeZone);
            timezones0.put("Indian/Cocos", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(25200000, "VST");
            timezones0.put("VST", simpleTimeZone);
            timezones0.put("Antarctica/Davis", simpleTimeZone);
            timezones0.put("Asia/Bangkok", simpleTimeZone);
            timezones0.put("Asia/Jakarta", simpleTimeZone);
            timezones0.put("Asia/Phnom_Penh", simpleTimeZone);
            timezones0.put("Asia/Pontianak", simpleTimeZone);
            timezones0.put("Asia/Saigon", simpleTimeZone);
            timezones0.put("Asia/Vientiane", simpleTimeZone);
            timezones0.put("Indian/Christmas", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(25200000, "Asia/Hovd", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Hovd", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(25200000, "Asia/Krasnoyarsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Krasnoyarsk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(28800000, "CTT");
            timezones0.put("CTT", simpleTimeZone);
            timezones0.put("Antarctica/Casey", simpleTimeZone);
            timezones0.put("Asia/Brunei", simpleTimeZone);
            timezones0.put("Asia/Chongqing", simpleTimeZone);
            timezones0.put("Asia/Harbin", simpleTimeZone);
            timezones0.put("Asia/Hong_Kong", simpleTimeZone);
            timezones0.put("Asia/Kashgar", simpleTimeZone);
            timezones0.put("Asia/Kuala_Lumpur", simpleTimeZone);
            timezones0.put("Asia/Kuching", simpleTimeZone);
            timezones0.put("Asia/Macau", simpleTimeZone);
            timezones0.put("Asia/Makassar", simpleTimeZone);
            timezones0.put("Asia/Manila", simpleTimeZone);
            timezones0.put("Asia/Shanghai", simpleTimeZone);
            timezones0.put("Asia/Singapore", simpleTimeZone);
            timezones0.put("Asia/Taipei", simpleTimeZone);
            timezones0.put("Asia/Urumqi", simpleTimeZone);
            timezones0.put("Australia/Perth", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(28800000, "Asia/Irkutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Irkutsk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(28800000, "Asia/Ulaanbaatar", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Ulaanbaatar", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(31500000, "Australia/Eucla");
            timezones0.put("Australia/Eucla", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(32400000, "Asia/Choibalsan", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Choibalsan", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(32400000, "JST");
            timezones0.put("JST", simpleTimeZone);
            timezones0.put("Asia/Dili", simpleTimeZone);
            timezones0.put("Asia/Jayapura", simpleTimeZone);
            timezones0.put("Asia/Pyongyang", simpleTimeZone);
            timezones0.put("Asia/Seoul", simpleTimeZone);
            timezones0.put("Asia/Tokyo", simpleTimeZone);
            timezones0.put("Pacific/Palau", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(32400000, "Asia/Yakutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yakutsk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("Australia/Adelaide", simpleTimeZone);
            timezones0.put("Australia/Broken_Hill", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(34200000, "ACT");
            timezones0.put("ACT", simpleTimeZone);
            timezones0.put("Australia/Darwin", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(36000000, "Antarctica/DumontDUrville");
            timezones0.put("Antarctica/DumontDUrville", simpleTimeZone);
            timezones0.put("Australia/Brisbane", simpleTimeZone);
            timezones0.put("Australia/Lindeman", simpleTimeZone);
            timezones0.put("Pacific/Guam", simpleTimeZone);
            timezones0.put("Pacific/Port_Moresby", simpleTimeZone);
            timezones0.put("Pacific/Saipan", simpleTimeZone);
            timezones0.put("Pacific/Truk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(36000000, "Asia/Sakhalin", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Sakhalin", simpleTimeZone);
            timezones0.put("Asia/Vladivostok", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(36000000, "Australia/Currie", 9, 1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("Australia/Currie", simpleTimeZone);
            timezones0.put("Australia/Hobart", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(36000000, "AET", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("AET", simpleTimeZone);
            timezones0.put("Australia/Melbourne", simpleTimeZone);
            timezones0.put("Australia/Sydney", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(37800000, "Australia/Lord_Howe", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00, 1800000);
            timezones0.put("Australia/Lord_Howe", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(39600000, "Asia/Magadan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Magadan", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(39600000, "SST");
            timezones0.put("SST", simpleTimeZone);
            timezones0.put("Pacific/Efate", simpleTimeZone);
            timezones0.put("Pacific/Guadalcanal", simpleTimeZone);
            timezones0.put("Pacific/Kosrae", simpleTimeZone);
            timezones0.put("Pacific/Noumea", simpleTimeZone);
            timezones0.put("Pacific/Ponape", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(41400000, "Pacific/Norfolk");
            timezones0.put("Pacific/Norfolk", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(43200000, "NST", 9, 1, 1, 0x6DDD00, 2, 3, 1, 10800000);
            timezones0.put("NST", simpleTimeZone);
            timezones0.put("Antarctica/McMurdo", simpleTimeZone);
            timezones0.put("Antarctica/South_Pole", simpleTimeZone);
            timezones0.put("Pacific/Auckland", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(43200000, "Asia/Anadyr", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Anadyr", simpleTimeZone);
            timezones0.put("Asia/Kamchatka", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(43200000, "Pacific/Fiji");
            timezones0.put("Pacific/Fiji", simpleTimeZone);
            timezones0.put("Pacific/Funafuti", simpleTimeZone);
            timezones0.put("Pacific/Kwajalein", simpleTimeZone);
            timezones0.put("Pacific/Majuro", simpleTimeZone);
            timezones0.put("Pacific/Nauru", simpleTimeZone);
            timezones0.put("Pacific/Tarawa", simpleTimeZone);
            timezones0.put("Pacific/Wake", simpleTimeZone);
            timezones0.put("Pacific/Wallis", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(45900000, "Pacific/Chatham", 9, 1, 1, 9900000, 2, 3, 1, 13500000);
            timezones0.put("Pacific/Chatham", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(46800000, "Pacific/Enderbury");
            timezones0.put("Pacific/Enderbury", simpleTimeZone);
            timezones0.put("Pacific/Tongatapu", simpleTimeZone);
            simpleTimeZone = new SimpleTimeZone(50400000, "Pacific/Kiritimati");
            timezones0.put("Pacific/Kiritimati", simpleTimeZone);
        }
        return timezones0;
    }

    static TimeZone getDefaultTimeZone(String string) {
        String string2 = null;
        try {
            int n;
            char c;
            int n2 = string.length();
            int n3 = 0;
            while ((c = string.charAt(n3)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++n3 < n2) {
            }
            if (n3 >= n2) {
                return TimeZone.getTimeZoneInternal(string);
            }
            string2 = string.substring(0, n3);
            int n4 = n3;
            while (((c = string.charAt(n3++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && n3 < n2) {
            }
            if (n3 < n2) {
                --n3;
            }
            Object object = string.substring(n4, n3);
            n4 = n3;
            int n5 = ((String)object).charAt(0) == '+' || ((String)object).charAt(0) == '-' ? TimeZone.parseTime(((String)object).substring(1)) : TimeZone.parseTime((String)object);
            if (((String)object).charAt(0) == '-') {
                n5 = -n5;
            }
            n5 = -n5;
            if (n3 >= n2) {
                object = TimeZone.getTimeZoneInternal(string2);
                if (object != null && ((TimeZone)object).getRawOffset() == n5) {
                    return object;
                }
                return new SimpleTimeZone(n5, string2);
            }
            while ((c = string.charAt(n3)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++n3 < n2) {
            }
            if (n3 >= n2) {
                object = TimeZone.getTimeZoneInternal(string2);
                if (object != null && ((TimeZone)object).getRawOffset() == n5 && ((TimeZone)object).useDaylightTime()) {
                    return object;
                }
                return new SimpleTimeZone(n5, string2);
            }
            n4 = n3;
            while (((c = string.charAt(n3++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && n3 < n2) {
            }
            if (n3 < n2) {
                --n3;
            }
            if (n3 == n4 && (c == ',' || c == ';')) {
                n = n5 + 3600000;
            } else {
                object = string.substring(n4, n3);
                n4 = n3;
                n = ((String)object).charAt(0) == '+' || ((String)object).charAt(0) == '-' ? TimeZone.parseTime(((String)object).substring(1)) : TimeZone.parseTime((String)object);
                if (((String)object).charAt(0) == '-') {
                    n = -n;
                }
                n = -n;
            }
            if (n3 >= n2) {
                object = TimeZone.getTimeZoneInternal(string2);
                if (object != null && ((TimeZone)object).getRawOffset() == n5 && ((TimeZone)object).useDaylightTime() && ((TimeZone)object).getDSTSavings() == n - n5) {
                    return object;
                }
                return new SimpleTimeZone(n5, string2);
            }
            if (string.charAt(n3) == ',' || string.charAt(n3) == ';') {
                int n6;
                String string3;
                int n7;
                String string4;
                int n8 = ++n3;
                while (string.charAt(n3) != ',' && string.charAt(n3) != ';') {
                    ++n3;
                }
                String string5 = string.substring(n8, n3);
                String string6 = string.substring(++n3);
                n3 = string5.indexOf(47);
                if (n3 != -1) {
                    string4 = string5.substring(0, n3);
                    n7 = TimeZone.parseTime(string5.substring(n3 + 1));
                } else {
                    string4 = string5;
                    n7 = 0x6DDD00;
                }
                n3 = string6.indexOf(47);
                if (n3 != -1) {
                    string3 = string6.substring(0, n3);
                    n6 = TimeZone.parseTime(string6.substring(n3 + 1));
                } else {
                    string3 = string6;
                    n6 = 0x6DDD00;
                }
                int[] nArray = TimeZone.getDateParams(string4);
                int[] nArray2 = TimeZone.getDateParams(string3);
                return new SimpleTimeZone(n5, string2, nArray[0], nArray[1], nArray[2], n7, nArray2[0], nArray2[1], nArray2[2], n6, n - n5);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static int[] getDateParams(String string) {
        int n;
        int n2;
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        if (string.charAt(0) == 'M' || string.charAt(0) == 'm') {
            int n3 = Integer.parseInt(string.substring(1, string.indexOf(46)));
            int n4 = Integer.parseInt(string.substring(string.indexOf(46) + 1, string.lastIndexOf(46)));
            int n5 = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
            int n6 = n4 == 5 ? -1 : (n4 - 1) * 7 + 1;
            return new int[]{--n3, n6, ++n5};
        }
        if (string.charAt(0) != 'J' || string.charAt(0) != 'j') {
            n2 = Integer.parseInt(string.substring(1));
            ++n2;
            nArray = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        } else {
            n2 = Integer.parseInt(string);
        }
        for (n = 11; n > 0 && nArray[n] >= n2; --n) {
        }
        int n7 = n;
        return new int[]{n7, n2 -= nArray[n], 0};
    }

    private static int parseTime(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) != ':'; ++n) {
        }
        n2 = 3600000 * Integer.parseInt(string.substring(0, n));
        if (n >= string.length()) {
            return n2;
        }
        int n3 = ++n;
        while (n < string.length() && string.charAt(n) != ':') {
            ++n;
        }
        n2 += 60000 * Integer.parseInt(string.substring(n3, n));
        if (n >= string.length()) {
            return n2;
        }
        return n2 += 1000 * Integer.parseInt(string.substring(++n));
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l) {
        return this.inDaylightTime(new Date(l)) ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
    }

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault());
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        try {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            String[][] stringArray = dateFormatSymbols.getZoneStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i][0].equals(this.getID())) continue;
                if (!bl) {
                    if (n == 0) {
                        return stringArray[i][2];
                    }
                    return stringArray[i][1];
                }
                if (n == 0) {
                    return stringArray[i][4];
                }
                return stringArray[i][3];
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.getDefaultDisplayName(bl);
    }

    private String getDefaultDisplayName(boolean bl) {
        int n = this.getRawOffset();
        if (bl && this instanceof SimpleTimeZone) {
            n += ((SimpleTimeZone)this).getDSTSavings();
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder(9);
        cPStringBuilder.append("GMT");
        int n2 = Math.abs(n /= 60000) / 60;
        int n3 = Math.abs(n) % 60;
        if (n3 != 0 || n2 != 0) {
            cPStringBuilder.append(n >= 0 ? (char)'+' : '-');
            cPStringBuilder.append((char)(48 + n2 / 10));
            cPStringBuilder.append((char)(48 + n2 % 10));
            cPStringBuilder.append(':');
            cPStringBuilder.append((char)(48 + n3 / 10));
            cPStringBuilder.append((char)(48 + n3 % 10));
        }
        return cPStringBuilder.toString();
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public int getDSTSavings() {
        return this.useDaylightTime() ? 3600000 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static TimeZone getTimeZoneInternal(String string) {
        TimeZone timeZone = null;
        TimeZone timeZone2 = null;
        int n = 0;
        while (n < 2) {
            Object object = TimeZone.class;
            // MONITORENTER : java.util.TimeZone.class
            timeZone = (TimeZone)TimeZone.timezones().get(string);
            if (timeZone != null) {
                if (!timeZone.getID().equals(string)) {
                    timeZone = (TimeZone)timeZone.clone();
                    timeZone.setID(string);
                    TimeZone.timezones().put(string, timeZone);
                }
                // MONITOREXIT : object
                return timeZone;
            }
            if (timeZone2 != null) {
                TimeZone.timezones().put(string, timeZone2);
                // MONITOREXIT : object
                return timeZone2;
            }
            // MONITOREXIT : object
            if (n == 1) return null;
            if (zoneinfo_dir == null) {
                return null;
            }
            object = (String)aliases0.get(string);
            if (object == null) {
                object = string;
            }
            if ((timeZone2 = ZoneInfo.readTZFile(string, zoneinfo_dir + File.separatorChar + (String)object)) == null) {
                return null;
            }
            ++n;
        }
        return null;
    }

    public static TimeZone getTimeZone(String string) {
        TimeZone timeZone;
        if (string.startsWith("GMT") && string.length() > 3) {
            int n = 3;
            int n2 = 1;
            if (string.charAt(n) == '-') {
                n2 = -1;
                ++n;
            } else if (string.charAt(n) == '+') {
                ++n;
            }
            try {
                int n3;
                int n4;
                String string2 = string.substring(n);
                int n5 = string2.indexOf(":");
                if (n5 != -1) {
                    n4 = Integer.parseInt(string2.substring(0, n5));
                    n3 = Integer.parseInt(string2.substring(n5 + 1));
                } else {
                    int n6 = string2.length();
                    if (n6 <= 2) {
                        n4 = Integer.parseInt(string2);
                        n3 = 0;
                    } else {
                        n4 = Integer.parseInt(string2.substring(0, n6 - 2));
                        n3 = Integer.parseInt(string2.substring(n6 - 2));
                    }
                }
                CPStringBuilder cPStringBuilder = new CPStringBuilder(9);
                cPStringBuilder.append("GMT");
                cPStringBuilder.append(n2 >= 0 ? (char)'+' : '-');
                cPStringBuilder.append((char)(48 + n4 / 10));
                cPStringBuilder.append((char)(48 + n4 % 10));
                cPStringBuilder.append(':');
                cPStringBuilder.append((char)(48 + n3 / 10));
                cPStringBuilder.append((char)(48 + n3 % 10));
                string = cPStringBuilder.toString();
                return new SimpleTimeZone((n4 * 3600000 + n3 * 60000) * n2, string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((timeZone = TimeZone.getTimeZoneInternal(string)) != null) {
            return timeZone;
        }
        return new SimpleTimeZone(0, "GMT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableIDs(int n) {
        String[] stringArray = TimeZone.class;
        synchronized (TimeZone.class) {
            HashMap hashMap = TimeZone.timezones();
            int n2 = 0;
            if (zoneinfo_dir == null) {
                for (Map.Entry object2 : hashMap.entrySet()) {
                    if (((TimeZone)object2.getValue()).getRawOffset() != n) continue;
                    ++n2;
                }
                String[] stringArray2 = new String[n2];
                n2 = 0;
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((TimeZone)entry.getValue()).getRawOffset() != n) continue;
                    stringArray2[n2++] = (String)entry.getKey();
                }
                // ** MonitorExit[stringArray] (shouldn't be in output)
                return stringArray2;
            }
            // ** MonitorExit[stringArray] (shouldn't be in output)
            stringArray = TimeZone.getAvailableIDs();
            int n3 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                TimeZone timeZone = TimeZone.getTimeZoneInternal(stringArray[n2]);
                if (timeZone == null || timeZone.getRawOffset() != n) {
                    stringArray[n2] = null;
                    continue;
                }
                ++n3;
            }
            String[] stringArray2 = new String[n3];
            n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n3++] = stringArray[i];
            }
            return stringArray2;
        }
    }

    private static int getAvailableIDs(File file, String string, ArrayList arrayList) {
        String[] stringArray = file.list();
        int n = stringArray.length;
        boolean bl = string.length() == 0;
        arrayList.add(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl && (stringArray[i].equals("posix") || stringArray[i].equals("right") || stringArray[i].endsWith(".tab") || aliases0.get(stringArray[i]) != null)) {
                stringArray[i] = null;
                --n;
                continue;
            }
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                n += TimeZone.getAvailableIDs(file2, string + stringArray[i] + File.separatorChar, arrayList) - 1;
                stringArray[i] = null;
                continue;
            }
            stringArray[i] = string + stringArray[i];
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableIDs() {
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            HashMap hashMap = TimeZone.timezones();
            if (zoneinfo_dir == null) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return hashMap.keySet().toArray(new String[hashMap.size()]);
            }
            if (availableIDs != null) {
                String[] stringArray = new String[availableIDs.length];
                for (int i = 0; i < availableIDs.length; ++i) {
                    stringArray[i] = availableIDs[i];
                }
                // ** MonitorExit[clazz] (shouldn't be in output)
                return stringArray;
            }
            File file = new File(zoneinfo_dir);
            ArrayList arrayList = new ArrayList(30);
            int n = TimeZone.getAvailableIDs(file, "", arrayList) + aliases0.size();
            availableIDs = new String[n];
            String[] stringArray = new String[n];
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] object = (String[])arrayList.get(i);
                for (int j = 0; j < object.length; ++j) {
                    if (object[j] == null) continue;
                    TimeZone.availableIDs[n] = object[j];
                    stringArray[n++] = object[j];
                }
            }
            for (Map.Entry entry : aliases0.entrySet()) {
                TimeZone.availableIDs[n] = (String)entry.getKey();
                stringArray[n++] = (String)entry.getKey();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return stringArray;
        }
    }

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.defaultZone().clone();
    }

    public static void setDefault(TimeZone timeZone) {
        defaultZone0 = timeZone;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone.getRawOffset() == this.getRawOffset();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static {
        availableIDs = null;
    }
}

