/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int rawOffset;
    private boolean useDaylight;
    private int dstSavings = 3600000;
    private int startYear;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private int startMode;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode = 0;
    private int endMonth;
    private int endMode;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode = 0;
    private byte[] monthLength = monthArr;
    private static final byte[] monthArr = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int serialVersionOnStream = 2;
    private static final long serialVersionUID = -403250971215465050L;
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    public static final int UTC_TIME = 2;

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = false;
        this.startYear = 0;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = true;
        this.setStartRule(n2, n3, n4, n5);
        this.setEndRule(n6, n7, n8, n9);
        if (n2 == n6) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this(n, string, n2, n3, n4, n5, n6, n7, n8, n9);
        this.dstSavings = n10;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this(n, string, n2, n3, n4, n5, n7, n8, n9, n10);
        if (n6 < 0 || n6 > 2) {
            throw new IllegalArgumentException("startTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        if (n11 < 0 || n11 > 2) {
            throw new IllegalArgumentException("endTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        this.dstSavings = n12;
        this.startTimeMode = n6;
        this.endTimeMode = n11;
    }

    public void setStartYear(int n) {
        this.startYear = n;
        this.useDaylight = true;
    }

    private int checkRule(int n, int n2, int n3) {
        if (n < 0 || n > 11) {
            throw new IllegalArgumentException("month out of range");
        }
        int n4 = this.getDaysInMonth(n, 1);
        if (n3 == 0) {
            if (n2 <= 0 || n2 > n4) {
                throw new IllegalArgumentException("day out of range");
            }
            return 1;
        }
        if (n3 > 0) {
            if (Math.abs(n2) > (n4 + 6) / 7) {
                throw new IllegalArgumentException("dayOfWeekInMonth out of range");
            }
            if (n3 > 7) {
                throw new IllegalArgumentException("dayOfWeek out of range");
            }
            return 2;
        }
        if (n2 == 0 || Math.abs(n2) > n4) {
            throw new IllegalArgumentException("day out of range");
        }
        if (n3 < -7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (n2 < 0) {
            return 4;
        }
        return 3;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMode = this.checkRule(n, n2, n3);
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = Math.abs(n3);
        this.startTime = n4;
        this.startTimeMode = 0;
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setStartRule(n, n2, -n3, n4);
        } else {
            this.setStartRule(n, -n2, -n3, n4);
        }
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMode = this.checkRule(n, n2, n3);
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = Math.abs(n3);
        this.endTime = n4;
        this.endTimeMode = 0;
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setEndRule(n, n2, -n3, n4);
        } else {
            this.setEndRule(n, -n2, -n3, n4);
        }
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getDaysInMonth(n3, n2);
        if (n4 < 1 || n4 > n7) {
            throw new IllegalArgumentException("day out of range");
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException("month out of range:" + n3);
        }
        int n8 = 0;
        if (this.useDaylight && n == 1 && n2 >= this.startYear) {
            boolean bl;
            int n9 = n2;
            int n10 = this.startTime + (this.startTimeMode == 2 ? this.rawOffset : 0);
            boolean bl2 = bl = !this.isBefore(n2, n3, n4, n5, n6, this.startMode, this.startMonth, this.startDay, this.startDayOfWeek, n10);
            if ((n6 += this.dstSavings) >= 86400000) {
                n6 -= 86400000;
                n5 = n5 % 7 + 1;
                if (++n4 > n7) {
                    n4 = 1;
                    if (n3++ == 11) {
                        n3 = 0;
                        ++n2;
                    }
                }
            }
            n10 = this.endTime + (this.endTimeMode == 2 ? this.rawOffset : 0);
            if (this.endTimeMode != 0) {
                n10 += this.dstSavings;
            }
            boolean bl3 = this.isBefore(n2, n3, n4, n5, n6, this.endMode, this.endMonth, this.endDay, this.endDayOfWeek, n10);
            if (n2 != n9) {
                bl = false;
            }
            n8 = this.startMonth < this.endMonth ? (bl && bl3 ? this.dstSavings : 0) : (bl3 || bl ? this.dstSavings : 0);
        }
        return this.rawOffset + n8;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public void setDSTSavings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal value for dstSavings");
        }
        this.dstSavings = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private int getDaysInMonth(int n, int n2) {
        if (n == 1) {
            if ((n2 & 3) != 0) {
                return 28;
            }
            if (n2 < 1582) {
                return 29;
            }
            return n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28;
        }
        return monthArr[n];
    }

    private boolean isBefore(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (n2 != n7) {
            return n2 < n7;
        }
        switch (n6) {
            case 1: {
                if (n3 == n8) break;
                return n3 < n8;
            }
            case 2: {
                n3 += n9 - n4;
                n3 = n8 < 0 ? (n3 -= this.getDaysInMonth(n2, n) + 7) : (n3 += 6);
                int n11 = n3 / 7;
                if (n11 != n8) {
                    return n11 < n8;
                }
                if (n4 == n9) break;
                return n4 < n9;
            }
            case 4: {
                n8 = Math.abs(n8) - 6;
            }
            case 3: {
                if ((n3 -= (n4 < n9 ? 7 : 0) + n4 - n9) < n8) {
                    return true;
                }
                if (n4 == n9 && n3 < n8 + 7) break;
                return false;
            }
        }
        return n5 < n10;
    }

    public boolean inDaylightTime(Date date) {
        Calendar calendar = Calendar.getInstance(this);
        calendar.setTime(date);
        return calendar.get(16) != 0;
    }

    public synchronized int hashCode() {
        return this.rawOffset ^ (this.useDaylight ? this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime : 0);
    }

    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        if (simpleTimeZone.hashCode() != this.hashCode() || !this.getID().equals(simpleTimeZone.getID()) || this.rawOffset != simpleTimeZone.rawOffset || this.useDaylight != simpleTimeZone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        return this.startYear == simpleTimeZone.startYear && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        if (simpleTimeZone.hashCode() != this.hashCode() || this.rawOffset != simpleTimeZone.rawOffset || this.useDaylight != simpleTimeZone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        return this.startYear == simpleTimeZone.startYear && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode : "") + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream == 0) {
            this.dstSavings = 3600000;
            this.endMode = 2;
            this.startMode = 2;
            this.startTimeMode = 0;
            this.endTimeMode = 0;
            this.serialVersionOnStream = 2;
        } else {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.read(byArray, 0, n);
            if (n >= 4) {
                this.startDay = byArray[0];
                this.startDayOfWeek = byArray[1];
                this.endDay = byArray[2];
                this.endDayOfWeek = byArray[3];
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        switch (this.startMode) {
            case 1: {
                this.startDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.startDay = (this.startDay + 6) / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.endDay = (this.endDay + 6) / 7;
            }
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray, 0, byArray.length);
    }
}

