/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.ServiceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private Class<S> spi;
    private ClassLoader loader;
    private List<S> cache;
    private Iterator<S> serviceIt;

    private ServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        this.spi = clazz;
        this.loader = classLoader;
        this.cache = new ArrayList<S>();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private Iterator<S> cacheIt;
            {
                this.cacheIt = ServiceLoader.this.cache.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.cacheIt.hasNext()) {
                    return true;
                }
                if (ServiceLoader.this.serviceIt == null) {
                    ServiceLoader.this.serviceIt = ServiceFactory.lookupProviders(ServiceLoader.this.spi, ServiceLoader.this.loader, true);
                }
                return ServiceLoader.this.serviceIt.hasNext();
            }

            @Override
            public S next() {
                if (this.cacheIt.hasNext()) {
                    return this.cacheIt.next();
                }
                if (ServiceLoader.this.serviceIt == null) {
                    ServiceLoader.this.serviceIt = ServiceFactory.lookupProviders(ServiceLoader.this.spi, ServiceLoader.this.loader, true);
                }
                Object e = ServiceLoader.this.serviceIt.next();
                ServiceLoader.this.cache.add(e);
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        return ServiceLoader.load(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new ServiceLoader<S>(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        return ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader().getParent());
    }

    public void reload() {
        this.cache.clear();
    }

    public String toString() {
        return this.getClass().getName() + "[spi=" + this.spi + ",loader=" + this.loader + "]";
    }
}

