/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner
implements Iterator<String> {
    private static final String NOT_LONG = "\" is not a long";
    private static final String ERR_PREFIX = "\"";
    private static final String NOT_INT = "\" is not an integer";
    private static final String NOT_DOUBLE = "\" is not a double";
    private static final String NOT_BYTE = "\" is not a byte";
    private static final String NOT_BOOLEAN = "\" is not a boolean";
    private static final String IS_NOT = "\" is not ";
    private static final String DEFAULT_PATTERN_S = "\\p{javaWhitespace}+";
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static final String BIG_INTEGER = "BigInteger";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private IOException lastIOException = null;
    private InputStream bIS = null;
    private final int MaxBufferLen = 1000000;
    private final int MIN_BUF_LEN = 100;
    private final int MAX_PREFIX = 10000;
    private String actBuffer = new String();
    private int currentRadix = 10;
    private Locale actLocale = Locale.getDefault();
    private Pattern p = DEFAULT_PATTERN;
    private int actPos = 0;
    private final byte[] tmpBuffer = new byte[this.MaxBufferLen];
    private String charsetName = null;
    private Matcher myMatcher = this.p.matcher(this.actBuffer);
    private MatchResult actResult = null;
    private Readable readableSource = null;
    private ReadableByteChannel rbcSource = null;
    private boolean isClosed = false;
    private String lastFound = null;
    private boolean lastFoundPresent = false;
    private int lastNextPos = 0;
    private int lastPatternHash = 0;
    private int last_RegionStart = 0;
    private int last_RegionEnd = 0;
    private boolean last_anchor = false;
    private boolean last_transparent = false;
    private MatchResult lastResult = null;
    private int procesedChars = 0;
    private boolean needInput = false;
    private boolean skipped = false;
    private boolean doSkipp = false;
    private boolean matchValid = false;
    private NumberFormat actFormat = NumberFormat.getInstance(this.actLocale);
    private DecimalFormat df = (DecimalFormat)this.actFormat;
    private boolean useLocale = true;
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.actLocale);

    public Scanner(File file) throws FileNotFoundException {
        this(file, null);
    }

    public Scanner(File file, String string) throws FileNotFoundException {
        this(new FileInputStream(file), string);
    }

    public Scanner(InputStream inputStream) {
        this(inputStream, null);
    }

    public Scanner(InputStream inputStream, String string) {
        this.bIS = new BufferedInputStream(inputStream);
        this.charsetName = string;
        this.myFillBuffer();
    }

    public Scanner(Readable readable) {
        this.readableSource = readable;
        this.myFillBuffer();
    }

    public Scanner(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, null);
    }

    public Scanner(ReadableByteChannel readableByteChannel, String string) {
        this.charsetName = string;
        this.rbcSource = readableByteChannel;
        this.myFillBuffer();
    }

    public Scanner(String string) {
        this.actBuffer = new String(string);
        this.myMatcher.reset(this.actBuffer);
    }

    public void close() {
        try {
            if (this.bIS != null) {
                this.bIS.close();
            }
            if (this.rbcSource != null) {
                this.rbcSource.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            this.lastIOException = iOException;
        }
    }

    public Pattern delimiter() {
        return this.p;
    }

    public String findInLine(Pattern pattern2) throws NoSuchElementException {
        String string = this.myNextLine(false);
        return this.myFindPInStr(pattern2, string, 0);
    }

    public String findInLine(String string) {
        return this.findInLine(Pattern.compile(string));
    }

    public String findWithinHorizon(Pattern pattern2, int n) throws IllegalArgumentException, IllegalStateException {
        if (n < 0) {
            throw new IllegalArgumentException(n + " is negative");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Scanner is closed");
        }
        this.doSkipp = true;
        String string = this.myFindPInStr(pattern2, this.actBuffer, n);
        if (string != null) {
            this.actPos += string.length();
        }
        return string;
    }

    public String findWithinHorizon(String string, int n) throws IllegalArgumentException, IllegalStateException {
        return this.findWithinHorizon(Pattern.compile(string), n);
    }

    @Override
    public boolean hasNext() throws IllegalStateException {
        String string = null;
        try {
            string = this.myCoreNext(false, this.p);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return string != null && string.length() > 0;
    }

    public boolean hasNext(Pattern pattern2) throws IllegalStateException {
        String string = this.myNext(pattern2, false);
        return string != null && string.length() > 0;
    }

    public boolean hasNext(String string) throws IllegalStateException {
        return this.hasNext(Pattern.compile(string));
    }

    public boolean hasNextBigDecimal() throws IllegalStateException {
        try {
            this.myBigDecimal(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextBigInteger() throws IllegalStateException {
        return this.hasNextBigInteger(this.currentRadix);
    }

    public boolean hasNextBigInteger(int n) throws IllegalStateException {
        try {
            this.myNextBigInteger(n, false, BIG_INTEGER);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextBoolean() throws IllegalStateException {
        try {
            this.myNextBoolean(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextByte() throws IllegalStateException {
        return this.hasNextByte(this.currentRadix);
    }

    public boolean hasNextByte(int n) throws IllegalStateException {
        try {
            this.myNextByte(n, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextDouble() throws IllegalStateException {
        try {
            this.myNextDouble(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextFloat() throws IllegalStateException {
        try {
            this.myNextDouble(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextInt() throws IllegalStateException {
        return this.hasNextInt(this.currentRadix);
    }

    public boolean hasNextInt(int n) throws IllegalStateException {
        try {
            this.myNextInt(n, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextLine() throws IllegalStateException {
        return this.myNextLine(false) != null;
    }

    public boolean hasNextLong() throws IllegalStateException {
        return this.hasNextLong(this.currentRadix);
    }

    public boolean hasNextLong(int n) throws IllegalStateException {
        try {
            this.myNextLong(n, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextShort() throws IllegalStateException {
        return this.hasNextShort(this.currentRadix);
    }

    public boolean hasNextShort(int n) throws IllegalStateException {
        try {
            this.myNextShort(n, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public boolean isUseLocale() {
        return this.useLocale;
    }

    public Locale locale() {
        return this.actLocale;
    }

    public MatchResult match() {
        return this.actResult;
    }

    @Override
    public String next() throws NoSuchElementException, IllegalStateException {
        return this.myCoreNext(true, this.p);
    }

    public String next(Pattern pattern2) throws NoSuchElementException, IllegalStateException {
        return this.myNext(pattern2, true);
    }

    public String next(String string) throws NoSuchElementException, IllegalStateException {
        return this.next(Pattern.compile(string));
    }

    public BigDecimal nextBigDecimal() throws NoSuchElementException, IllegalStateException {
        return this.myBigDecimal(true);
    }

    public BigInteger nextBigInteger() throws NoSuchElementException, IllegalStateException {
        return this.nextBigInteger(this.currentRadix);
    }

    public BigInteger nextBigInteger(int n) throws NoSuchElementException, IllegalStateException {
        return this.myNextBigInteger(n, true, BIG_INTEGER);
    }

    public boolean nextBoolean() throws NoSuchElementException, IllegalStateException {
        return this.myNextBoolean(true);
    }

    public byte nextByte() throws NoSuchElementException, IllegalStateException {
        return this.nextByte(this.currentRadix);
    }

    public byte nextByte(int n) throws NoSuchElementException, IllegalStateException {
        return this.myNextByte(n, true);
    }

    public double nextDouble() throws NoSuchElementException, IllegalStateException {
        return this.myNextDouble(true);
    }

    public float nextFloat() throws NoSuchElementException, IllegalStateException {
        return (float)this.myNextDouble(true);
    }

    public int nextInt() throws NoSuchElementException, IllegalStateException {
        return this.nextInt(this.currentRadix);
    }

    public int nextInt(int n) throws NoSuchElementException, IllegalStateException {
        return this.myNextInt(n, true);
    }

    public String nextLine() throws NoSuchElementException, IllegalStateException {
        return this.myNextLine(true);
    }

    public long nextLong() throws NoSuchElementException, IllegalStateException {
        return this.nextLong(this.currentRadix);
    }

    public long nextLong(int n) throws NoSuchElementException, IllegalStateException {
        return this.myNextLong(n, true);
    }

    public short nextShort() throws NoSuchElementException {
        return this.nextShort(this.currentRadix);
    }

    public short nextShort(int n) throws NoSuchElementException {
        return this.myNextShort(n, true);
    }

    public int radix() {
        return this.currentRadix;
    }

    @Override
    public void remove() {
    }

    public void setUseLocale(boolean bl) {
        this.useLocale = bl;
    }

    public Scanner skip(Pattern pattern2) throws NoSuchElementException {
        this.doSkipp = true;
        Matcher matcher = pattern2.matcher(this.actBuffer);
        matcher.region(this.actPos - 1, this.actBuffer.length());
        boolean bl = matcher.find();
        bl = this.myFillBuffer_loop(matcher, this.actPos - 1, bl);
        int n = matcher.end();
        this.actPos = n + 1;
        this.doSkipp = false;
        this.skipped = true;
        this.actResult = null;
        if (!bl) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public Scanner skip(String string) {
        return this.skip(Pattern.compile(string));
    }

    public String toString() {
        String string;
        String string2 = string = this.getClass().getName();
        string2 = "[delimiters=" + this.p.pattern() + "]";
        string = string + string2;
        string2 = "[position=" + (this.procesedChars + this.actPos) + "]";
        string = string + string2;
        string2 = "[match valid=" + this.matchValid + "]";
        string = string + string2;
        string2 = "[need input=" + this.needInput + "]";
        string = string + string2;
        string2 = "[source closed=" + this.isClosed + "]";
        string = string + string2;
        string2 = "[skipped=" + this.skipped + "]";
        string = string + string2;
        string2 = "[group separator=\\" + this.dfs.getGroupingSeparator() + "]";
        string = string + string2;
        string2 = "[decimal separator=\\" + this.dfs.getDecimalSeparator() + "]";
        string = string + string2;
        string2 = "[positive prefix=" + this.myConvert(this.df.getPositivePrefix()) + "]";
        string = string + string2;
        string2 = "[negative prefix=" + this.myConvert(this.df.getNegativePrefix()) + "]";
        string = string + string2;
        string2 = "[positive suffix=" + this.myConvert(this.df.getPositiveSuffix()) + "]";
        string = string + string2;
        string2 = "[negative suffix=" + this.myConvert(this.df.getNegativeSuffix()) + "]";
        string = string + string2;
        string2 = "[NaN string=" + this.myConvert(this.dfs.getNaN()) + "]";
        string = string + string2;
        string2 = "[infinity string=" + this.myConvert(this.dfs.getInfinity()) + "]";
        string = string + string2;
        return string;
    }

    public Scanner useDelimiter(Pattern pattern2) {
        if (pattern2 != null) {
            this.p = pattern2;
            this.myMatcher = this.p.matcher(this.actBuffer);
        }
        return this;
    }

    public Scanner useDelimiter(String string) {
        return this.useDelimiter(Pattern.compile(string));
    }

    public Scanner useLocale(Locale locale) {
        if (locale != null) {
            this.actLocale = locale;
            this.actFormat = NumberFormat.getInstance(this.actLocale);
            this.dfs = new DecimalFormatSymbols(this.actLocale);
            this.df = (DecimalFormat)this.actFormat;
        }
        return this;
    }

    public Scanner useRadix(int n) throws IllegalArgumentException {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException();
        }
        this.currentRadix = n;
        return this;
    }

    private String myApplyLocale(String string, int n) throws ParseException {
        if (this.useLocale && n == 10) {
            String string2 = this.actFormat.parse(string).toString();
            return string2;
        }
        return string;
    }

    private String myApplyLocaleBD(String string) throws ParseException {
        if (!this.useLocale || this.currentRadix != 10) {
            return string;
        }
        String string2 = this.df.getNegativePrefix();
        String string3 = this.df.getNegativeSuffix();
        String string4 = this.df.getPositivePrefix();
        String string5 = this.df.getPositiveSuffix();
        char c = this.dfs.getDecimalSeparator();
        boolean bl = false;
        String string6 = null;
        String string7 = "";
        int n = string.indexOf(c);
        int n2 = string.indexOf(c, n + 1);
        if (n2 > 0) {
            throw new ParseException("more than one Decimal seperators", n2);
        }
        string6 = string.substring(0, n);
        if (string2.length() > 0 && string.substring(0, string2.length()).equals(string2) || string3.length() > 0 && string.substring(string.length() - string3.length()).equals(string3)) {
            string6 = string6 + string3;
            bl = true;
        } else if (string4.length() > 0 && string.substring(0, string4.length()).equals(string4) || string5.length() > 0 && string.substring(string.length() - string5.length()).equals(string5)) {
            string6 = string6 + string5;
        }
        string7 = this.actFormat.parse(string6).toString();
        string7 = bl ? string7 + "." + string.substring(string.indexOf(c) + 1, string.length() - string3.length()) : string7 + "." + string.substring(string.indexOf(c) + 1, string.length() - string5.length());
        return string7;
    }

    private BigDecimal myBigDecimal(boolean bl) throws InputMismatchException {
        String string = this.myCoreNext(bl, this.p);
        try {
            string = this.myApplyLocaleBD(string);
        }
        catch (ParseException parseException) {
            throw new InputMismatchException(ERR_PREFIX + string + IS_NOT + "BigDecimal!!");
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal;
    }

    private String myConvert(String string) {
        if (string != null && string.length() > 0) {
            return "\\Q" + string + "\\E";
        }
        return string;
    }

    private String myCoreNext(boolean bl, Pattern pattern2) throws NoSuchElementException {
        int n;
        if (this.isClosed) {
            throw new IllegalStateException("Scanner closed");
        }
        if (this.shallUseLastFound(pattern2 != null ? pattern2 : this.p)) {
            if (this.last_RegionEnd != this.myMatcher.regionEnd()) {
                System.out.println(this.last_RegionEnd + " != " + this.myMatcher.regionEnd() + " (" + (this.last_RegionEnd - this.myMatcher.regionEnd()) + ")");
            }
            if (bl) {
                this.actPos = this.lastNextPos;
                this.lastFoundPresent = false;
                this.actResult = this.lastResult;
            }
            return this.lastFound;
        }
        boolean bl2 = false;
        String string = null;
        if (this.actPos > this.MAX_PREFIX) {
            this.procesedChars += this.actPos;
            this.actBuffer = this.actBuffer.substring(this.actPos);
            this.actPos = 0;
            this.myMatcher = pattern2.matcher(this.actBuffer);
        }
        if ((n = this.actBuffer.length() - this.actPos) < this.MIN_BUF_LEN) {
            this.myFillBuffer();
        }
        bl2 = this.myMatcher.find(this.actPos);
        bl2 = this.myFillBuffer_loop(this.myMatcher, this.actPos, bl2);
        this.needInput = false;
        if (bl2) {
            int n2 = this.doSkipp ? this.myMatcher.end() : this.myMatcher.start();
            string = this.actBuffer.substring(this.actPos, n2);
            this.lastNextPos = this.myMatcher.end();
            if (bl) {
                this.actPos = this.lastNextPos;
            } else {
                this.lastFound = string;
                this.lastFoundPresent = true;
                this.lastPatternHash = pattern2.hashCode();
            }
            this.last_RegionStart = this.myMatcher.regionStart();
            this.last_RegionEnd = this.myMatcher.regionEnd();
            this.last_anchor = this.myMatcher.hasAnchoringBounds();
            this.last_transparent = this.myMatcher.hasTransparentBounds();
        } else if (this.myMatcher.hitEnd()) {
            string = this.actBuffer.substring(this.actPos);
            if (string.length() == 0) {
                string = null;
            }
            this.lastNextPos = this.actBuffer.length();
            if (bl) {
                this.actPos = this.lastNextPos;
            } else {
                this.lastFound = string;
                this.lastFoundPresent = true;
                this.lastPatternHash = pattern2.hashCode();
            }
            this.last_RegionStart = this.myMatcher.regionStart();
            this.last_RegionEnd = this.myMatcher.regionEnd();
            this.last_anchor = this.myMatcher.hasAnchoringBounds();
            this.last_transparent = this.myMatcher.hasTransparentBounds();
        } else {
            throw new NoSuchElementException();
        }
        if (bl) {
            this.actResult = this.myMatcher.toMatchResult();
            this.matchValid = this.actResult != null;
        } else {
            this.lastResult = this.myMatcher.toMatchResult();
        }
        this.skipped = this.doSkipp;
        this.doSkipp = false;
        return string;
    }

    private void myFillBuffer() {
        CharBuffer charBuffer = null;
        ByteBuffer byteBuffer = null;
        if (this.bIS != null) {
            try {
                int n = this.bIS.read(this.tmpBuffer);
                if (n < 0) {
                    return;
                }
                String string = this.charsetName != null ? new String(this.tmpBuffer, 0, n, this.charsetName) : new String(this.tmpBuffer, 0, n);
                this.actBuffer = this.actBuffer + string;
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        } else if (this.readableSource != null) {
            try {
                charBuffer = CharBuffer.allocate(1000);
                this.needInput = true;
                int n = this.readableSource.read(charBuffer);
                if (n < 0) {
                    return;
                }
                this.needInput = false;
                String string = new String(charBuffer.array());
                this.actBuffer = this.actBuffer + string;
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        } else if (this.rbcSource != null) {
            try {
                byteBuffer = ByteBuffer.allocate(1000);
                this.needInput = true;
                int n = this.rbcSource.read(byteBuffer);
                this.needInput = false;
                if (n < 0) {
                    return;
                }
                String string = this.charsetName != null ? new String(byteBuffer.array(), 0, n, this.charsetName) : new String(byteBuffer.array(), 0, n);
                this.actBuffer = this.actBuffer + string;
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        }
        this.myMatcher.reset(this.actBuffer);
    }

    private boolean myFillBuffer_loop(Matcher matcher, int n, boolean bl) {
        int n2 = this.actBuffer.length();
        while (matcher.hitEnd() && (this.bIS != null || this.readableSource != null || this.rbcSource != null)) {
            this.myFillBuffer();
            if (n2 == this.actBuffer.length()) break;
            bl = matcher.find(n);
            this.needInput = true;
        }
        return bl;
    }

    private String myFindPInStr(Pattern pattern2, String string, int n) {
        String string2 = null;
        int n2 = this.actPos;
        Matcher matcher = this.myMatcher;
        this.myMatcher = pattern2.matcher(string);
        if (n > 0) {
            this.myMatcher.useAnchoringBounds(true);
            this.myMatcher.useTransparentBounds(true);
            this.myMatcher.region(this.actPos, this.actPos + n);
        }
        string2 = this.myCoreNext(true, pattern2);
        this.myMatcher = matcher;
        this.actPos = n2;
        this.skipped = true;
        return string2;
    }

    private String myNext(Pattern pattern2, boolean bl) {
        Matcher matcher = this.myMatcher;
        String string = this.actBuffer;
        String string2 = this.myCoreNext(bl, this.p);
        this.myMatcher = pattern2.matcher(string2);
        this.actBuffer = string2;
        int n = this.actPos;
        this.actPos = 0;
        String string3 = this.myCoreNext(bl, pattern2);
        this.actPos = n;
        this.actBuffer = string;
        this.myMatcher = matcher;
        this.skipped = true;
        return string3;
    }

    private BigInteger myNextBigInteger(int n, boolean bl, String string) {
        String string2 = this.myPrepareForNext(this.p, bl);
        try {
            string2 = this.myApplyLocale(string2, n);
            BigInteger bigInteger = new BigInteger(string2, n);
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string2 + IS_NOT + string);
    }

    private boolean myNextBoolean(boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new InputMismatchException(ERR_PREFIX + string + NOT_BOOLEAN);
    }

    private byte myNextByte(int n, boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        try {
            string = this.myApplyLocale(string, n);
            byte by = Byte.parseByte(string, n);
            return by;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string + NOT_BYTE);
    }

    private double myNextDouble(boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        try {
            string = this.myApplyLocale(string, 10);
            double d = Double.parseDouble(string);
            if (("" + d).equals(string)) {
                return d;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string + NOT_DOUBLE);
    }

    private int myNextInt(int n, boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        try {
            string = this.myApplyLocale(string, n);
            int n2 = Integer.parseInt(string, n);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string + NOT_INT);
    }

    private String myNextLine(boolean bl) {
        return this.myPrepareForNext(Pattern.compile(NEW_LINE), bl);
    }

    private long myNextLong(int n, boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        try {
            string = this.myApplyLocale(string, n);
            long l = Long.parseLong(string, n);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string + NOT_LONG);
    }

    private short myNextShort(int n, boolean bl) throws InputMismatchException {
        String string = this.myPrepareForNext(this.p, bl);
        try {
            string = this.myApplyLocale(string, n);
            short s = Short.parseShort(string, n);
            return s;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new InputMismatchException(ERR_PREFIX + string + "\" is not a short");
    }

    private String myPrepareForNext(Pattern pattern2, boolean bl) {
        Pattern pattern3 = this.p;
        this.useDelimiter(pattern2);
        String string = this.myCoreNext(bl, pattern2);
        this.useDelimiter(pattern3);
        return string;
    }

    private boolean shallUseLastFound(Pattern pattern2) {
        if (this.lastFoundPresent && this.lastPatternHash == pattern2.hashCode() && this.last_RegionStart == this.myMatcher.regionStart() && this.last_anchor == this.myMatcher.hasAnchoringBounds() && this.last_transparent == this.myMatcher.hasTransparentBounds()) {
            if (this.last_RegionEnd != this.myMatcher.regionEnd()) {
                int n = this.myMatcher.regionEnd() - this.last_RegionEnd - this.MAX_PREFIX;
                if (n > 0 && n < 20) {
                    this.last_RegionEnd = this.myMatcher.regionEnd();
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

