/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<T>
extends AbstractSequentialList<T>
implements List<T>,
Deque<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient Entry<T> first;
    transient Entry<T> last;
    transient int size = 0;

    Entry<T> getEntry(int n) {
        Entry<T> entry;
        if (n < this.size / 2) {
            entry = this.first;
            while (n-- > 0) {
                entry = entry.next;
            }
        } else {
            entry = this.last;
            while (++n < this.size) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    void removeEntry(Entry<T> entry) {
        ++this.modCount;
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        } else if (entry == this.first) {
            this.first = entry.next;
            entry.next.previous = null;
        } else if (entry == this.last) {
            this.last = entry.previous;
            entry.previous.next = null;
        } else {
            entry.next.previous = entry.previous;
            entry.previous.next = entry.next;
        }
    }

    private void checkBoundsInclusive(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    public LinkedList() {
    }

    public LinkedList(Collection<? extends T> collection) {
        this.addAll(collection);
    }

    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    @Override
    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object t = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return t;
    }

    @Override
    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object t = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return t;
    }

    @Override
    public void addFirst(T t) {
        Entry<T> entry = new Entry<T>(t);
        ++this.modCount;
        if (this.size == 0) {
            this.last = entry;
            this.first = this.last;
        } else {
            entry.next = this.first;
            this.first.previous = entry;
            this.first = entry;
        }
        ++this.size;
    }

    @Override
    public void addLast(T t) {
        this.addLastEntry(new Entry<T>(t));
    }

    private void addLastEntry(Entry<T> entry) {
        ++this.modCount;
        if (this.size == 0) {
            this.last = entry;
            this.first = this.last;
        } else {
            entry.previous = this.last;
            this.last.next = entry;
            this.last = entry;
        }
        ++this.size;
    }

    @Override
    public boolean contains(Object object) {
        Entry<T> entry = this.first;
        while (entry != null) {
            if (LinkedList.equals(object, entry.data)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T t) {
        this.addLastEntry(new Entry<T>(t));
        return true;
    }

    @Override
    public boolean remove(Object object) {
        Entry<T> entry = this.first;
        while (entry != null) {
            if (LinkedList.equals(object, entry.data)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        this.checkBoundsInclusive(n);
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        Iterator<T> iterator = collection.iterator();
        Entry<T> entry = null;
        Entry<T> entry2 = null;
        if (n != this.size) {
            entry = this.getEntry(n);
            entry2 = entry.previous;
        } else {
            entry2 = this.last;
        }
        Entry<T> entry3 = new Entry<T>(iterator.next());
        entry3.previous = entry2;
        Entry<T> entry4 = entry3;
        Entry<T> entry5 = entry3;
        for (int i = 1; i < n2; ++i) {
            entry3 = new Entry<T>(iterator.next());
            entry3.previous = entry4;
            entry4.next = entry3;
            entry4 = entry3;
        }
        ++this.modCount;
        this.size += n2;
        entry4.next = entry;
        if (entry != null) {
            entry.previous = entry3;
        } else {
            this.last = entry3;
        }
        if (entry2 != null) {
            entry2.next = entry5;
        } else {
            this.first = entry5;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.first = null;
            this.last = null;
            this.size = 0;
        }
    }

    @Override
    public T get(int n) {
        this.checkBoundsExclusive(n);
        return this.getEntry((int)n).data;
    }

    @Override
    public T set(int n, T t) {
        this.checkBoundsExclusive(n);
        Entry<T> entry = this.getEntry(n);
        Object t2 = entry.data;
        entry.data = t;
        return t2;
    }

    @Override
    public void add(int n, T t) {
        this.checkBoundsInclusive(n);
        Entry<T> entry = new Entry<T>(t);
        if (n < this.size) {
            ++this.modCount;
            Entry<T> entry2 = this.getEntry(n);
            entry.next = entry2;
            entry.previous = entry2.previous;
            if (entry2.previous == null) {
                this.first = entry;
            } else {
                entry2.previous.next = entry;
            }
            entry2.previous = entry;
            ++this.size;
        } else {
            this.addLastEntry(entry);
        }
    }

    @Override
    public T remove(int n) {
        this.checkBoundsExclusive(n);
        Entry<T> entry = this.getEntry(n);
        this.removeEntry(entry);
        return entry.data;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        Entry<T> entry = this.first;
        while (entry != null) {
            if (LinkedList.equals(object, entry.data)) {
                return n;
            }
            ++n;
            entry = entry.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        Entry<T> entry = this.last;
        while (entry != null) {
            if (LinkedList.equals(object, entry.data)) {
                return n;
            }
            --n;
            entry = entry.previous;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        this.checkBoundsInclusive(n);
        return new LinkedListItr(n);
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        linkedList.clear();
        linkedList.addAll(this);
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Entry<T> entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    @Override
    public <S> S[] toArray(S[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        Entry<T> entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    @Override
    public boolean offer(T t) {
        return this.add(t);
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry<T> entry = this.first;
        while (entry != null) {
            objectOutputStream.writeObject(entry.data);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        while (--n >= 0) {
            this.addLastEntry(new Entry<Object>(objectInputStream.readObject()));
        }
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new Iterator<T>(){
            private int knownMod;
            private Entry<T> next;
            private Entry<T> lastReturned;
            private int position;
            {
                this.knownMod = LinkedList.this.modCount;
                this.next = LinkedList.this.last;
                this.position = LinkedList.this.size() - 1;
            }

            private void checkMod() {
                if (this.knownMod != LinkedList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                this.checkMod();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                --this.position;
                this.lastReturned = this.next;
                this.next = this.lastReturned.previous;
                return this.lastReturned.data;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                LinkedList.this.removeEntry(this.lastReturned);
                this.lastReturned = null;
                ++this.knownMod;
            }
        };
    }

    @Override
    public boolean offerFirst(T t) {
        this.addFirst(t);
        return true;
    }

    @Override
    public boolean offerLast(T t) {
        return this.add(t);
    }

    @Override
    public T peekFirst() {
        return this.peek();
    }

    @Override
    public T peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    public T pollFirst() {
        return this.poll();
    }

    @Override
    public T pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public void push(T t) {
        this.addFirst(t);
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        Entry<T> entry = this.last;
        while (entry != null) {
            if (LinkedList.equals(object, entry.data)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.previous;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LinkedListItr<I>
    implements ListIterator<I> {
        private int knownMod;
        private Entry<I> next;
        private Entry<I> previous;
        private Entry<I> lastReturned;
        private int position;

        LinkedListItr(int n) {
            this.knownMod = LinkedList.this.modCount;
            if (n == LinkedList.this.size) {
                this.next = null;
                this.previous = LinkedList.this.last;
            } else {
                this.next = LinkedList.this.getEntry(n);
                this.previous = this.next.previous;
            }
            this.position = n;
        }

        private void checkMod() {
            if (this.knownMod != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public I next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.previous = this.next;
            this.lastReturned = this.previous;
            this.next = this.lastReturned.next;
            return (I)this.lastReturned.data;
        }

        @Override
        public I previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            --this.position;
            this.next = this.previous;
            this.lastReturned = this.next;
            this.previous = this.lastReturned.previous;
            return (I)this.lastReturned.data;
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                --this.position;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            LinkedList.this.removeEntry(this.lastReturned);
            ++this.knownMod;
            this.lastReturned = null;
        }

        @Override
        public void add(I i) {
            this.checkMod();
            ++LinkedList.this.modCount;
            ++this.knownMod;
            ++LinkedList.this.size;
            ++this.position;
            Entry<I> entry = new Entry<I>(i);
            entry.previous = this.previous;
            entry.next = this.next;
            if (this.previous != null) {
                this.previous.next = entry;
            } else {
                LinkedList.this.first = entry;
            }
            if (this.next != null) {
                this.next.previous = entry;
            } else {
                LinkedList.this.last = entry;
            }
            this.previous = entry;
            this.lastReturned = null;
        }

        @Override
        public void set(I i) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<T> {
        T data;
        Entry<T> next;
        Entry<T> previous;

        Entry(T t) {
            this.data = t;
        }
    }
}

