/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry<K, V>[] buckets;
    transient int modCount;
    transient int size;
    private transient Set<K> keys;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entries;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(map.size() * 2, 11), 0.75f);
        this.putAll(map);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Enumeration<K> keys() {
        return new KeyEnumerator();
    }

    @Override
    public Enumeration<V> elements() {
        return new ValueEnumerator();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry<K, V> hashEntry = this.buckets[i];
            while (hashEntry != null) {
                if (hashEntry.value.equals(object)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return (V)hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public synchronized V put(K k, V v) {
        int n = this.hash(k);
        HashEntry<K, V> hashEntry = this.buckets[n];
        if (v == null) {
            throw new NullPointerException();
        }
        while (hashEntry != null) {
            if (hashEntry.key.equals(k)) {
                Object object = hashEntry.value;
                hashEntry.value = v;
                return (V)object;
            }
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(k);
        }
        hashEntry = new HashEntry<K, V>(k, v);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        HashEntry<K, V> hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return (V)hashEntry.value;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> map2 = map;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (entry instanceof AbstractMap.SimpleEntry) {
                AbstractMap.SimpleEntry simpleEntry = (AbstractMap.SimpleEntry)entry;
                this.put(simpleEntry.key, simpleEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashtable.buckets = new HashEntry[this.buckets.length];
        hashtable.putAllInternal(this);
        hashtable.keys = null;
        hashtable.values = null;
        hashtable.entries = null;
        return hashtable;
    }

    public synchronized String toString() {
        EntryIterator entryIterator = new EntryIterator();
        CPStringBuilder cPStringBuilder = new CPStringBuilder("{");
        for (int i = this.size; i > 0; --i) {
            cPStringBuilder.append(entryIterator.next());
            if (i <= 1) continue;
            cPStringBuilder.append(", ");
        }
        cPStringBuilder.append("}");
        return cPStringBuilder.toString();
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            AbstractSet abstractSet = new AbstractSet<K>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (object == null) {
                        return false;
                    }
                    return Hashtable.this.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    return Hashtable.this.remove(object) != null;
                }
            };
            this.keys = new Collections.SynchronizedSet<K>((Object)this, abstractSet);
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            AbstractCollection abstractCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection<V>(this, abstractCollection);
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            AbstractSet abstractSet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return Hashtable.this.getEntry(object) != null;
                }

                @Override
                public boolean remove(Object object) {
                    HashEntry hashEntry = Hashtable.this.getEntry(object);
                    if (hashEntry != null) {
                        Hashtable.this.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet<Map.Entry<K, V>>((Object)this, abstractSet);
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)object).entrySet());
    }

    @Override
    public synchronized int hashCode() {
        EntryIterator entryIterator = new EntryIterator();
        int n = 0;
        for (int i = this.size; i > 0; --i) {
            n += ((Map.Entry)entryIterator.next()).hashCode();
        }
        return n;
    }

    private int hash(Object object) {
        int n = object.hashCode() % this.buckets.length;
        return n < 0 ? -n : n;
    }

    HashEntry<K, V> getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Object k = ((Map.Entry)object).getKey();
        if (k == null) {
            return null;
        }
        int n = this.hash(k);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.equals(object)) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    void putAllInternal(Map<? extends K, ? extends V> map) {
        Map<K, V> map2 = map;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            ++this.size;
            K k = entry.getKey();
            int n = this.hash(k);
            HashEntry<K, V> hashEntry = new HashEntry<K, V>(k, entry.getValue());
            hashEntry.next = this.buckets[n];
            this.buckets[n] = hashEntry;
        }
    }

    protected void rehash() {
        HashEntry<K, V>[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry<K, V> hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                HashEntry hashEntry2;
                int n2 = this.hash(hashEntry.key);
                HashEntry<K, V> hashEntry3 = this.buckets[n2];
                if (hashEntry3 != null) {
                    hashEntry2 = hashEntry3.next;
                    while (hashEntry2 != null) {
                        hashEntry3 = hashEntry2;
                        hashEntry2 = hashEntry3.next;
                    }
                    hashEntry3.next = hashEntry;
                } else {
                    this.buckets[n2] = hashEntry;
                }
                hashEntry2 = hashEntry.next;
                hashEntry.next = null;
                hashEntry = hashEntry2;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        EntryIterator entryIterator = new EntryIterator();
        while (entryIterator.hasNext()) {
            HashEntry hashEntry = (HashEntry)entryIterator.next();
            objectOutputStream.writeObject(hashEntry.key);
            objectOutputStream.writeObject(hashEntry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buckets = new HashEntry[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueEnumerator
    implements Enumeration<V> {
        private final EntryEnumerator enumerator;

        ValueEnumerator() {
            this.enumerator = new EntryEnumerator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumerator.hasMoreElements();
        }

        @Override
        public V nextElement() {
            HashEntry hashEntry = (HashEntry)this.enumerator.nextElement();
            Object object = null;
            if (hashEntry != null) {
                object = hashEntry.value;
            }
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyEnumerator
    implements Enumeration<K> {
        private final EntryEnumerator enumerator;

        KeyEnumerator() {
            this.enumerator = new EntryEnumerator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumerator.hasMoreElements();
        }

        @Override
        public K nextElement() {
            HashEntry hashEntry = (HashEntry)this.enumerator.nextElement();
            Object object = null;
            if (hashEntry != null) {
                object = hashEntry.key;
            }
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryEnumerator
    implements Enumeration<Map.Entry<K, V>> {
        int count;
        int idx;
        HashEntry<K, V> next;

        EntryEnumerator() {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count > 0;
        }

        @Override
        public Map.Entry<K, V> nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                if (this.idx <= 0) {
                    return null;
                }
                hashEntry = Hashtable.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            return hashEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<V> {
        private final EntryIterator iterator;

        ValueIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return ((HashEntry)this.iterator.next()).value;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private final EntryIterator iterator;

        KeyIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return ((HashEntry)this.iterator.next()).key;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        int knownMod;
        int count;
        int idx;
        HashEntry<K, V> last;
        HashEntry<K, V> next;

        EntryIterator() {
            this.knownMod = Hashtable.this.modCount;
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                if (this.idx <= 0) {
                    return null;
                }
                hashEntry = Hashtable.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            return hashEntry;
        }

        @Override
        public void remove() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            Hashtable.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashEntry<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        HashEntry<K, V> next;

        HashEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            return super.setValue(v);
        }
    }
}

