/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<T, String> map;

    public HashSet() {
        this(16, 0.75f);
    }

    public HashSet(int n) {
        this(n, 0.75f);
    }

    public HashSet(int n, float f) {
        this.map = this.init(n, f);
    }

    public HashSet(Collection<? extends T> collection) {
        this(Math.max(2 * collection.size(), 16));
        this.addAll(collection);
    }

    @Override
    public boolean add(T t) {
        return this.map.put(t, "") == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        HashSet hashSet = null;
        try {
            hashSet = (HashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashSet.map = (HashMap)this.map.clone();
        return hashSet;
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator(0);
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public int size() {
        return this.map.size;
    }

    HashMap init(int n, float f) {
        return new HashMap(n, f);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Iterator iterator = this.map.iterator(0);
        objectOutputStream.writeInt(this.map.buckets.length);
        objectOutputStream.writeFloat(this.map.loadFactor);
        objectOutputStream.writeInt(this.map.size);
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.map = this.init(objectInputStream.readInt(), objectInputStream.readFloat());
        for (int i = objectInputStream.readInt(); i > 0; --i) {
            this.map.put(objectInputStream.readObject(), "");
        }
    }
}

