/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    private int threshold;
    final float loadFactor;
    transient HashEntry<K, V>[] buckets;
    transient int modCount;
    transient int size;
    private transient Set<Map.Entry<K, V>> entries;

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(Math.max(map.size() * 2, 16), 0.75f);
        this.putAll(map);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (HashMap.equals(object, hashEntry.key)) {
                return (V)hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (HashMap.equals(object, hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        int n;
        int n2 = this.hash(k);
        HashEntry<K, V> hashEntry = this.buckets[n2];
        int n3 = n = k == null ? 0 : k.hashCode();
        while (hashEntry != null) {
            int n4;
            int n5 = n4 = hashEntry.key == null ? 0 : hashEntry.key.hashCode();
            if (n == n4 && HashMap.equals(k, hashEntry.key)) {
                hashEntry.access();
                Object object = hashEntry.value;
                hashEntry.value = v;
                return (V)object;
            }
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            n2 = this.hash(k);
        }
        this.addEntry(k, v, n2, true);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> map2 = map;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (entry instanceof AbstractMap.SimpleEntry) {
                AbstractMap.SimpleEntry simpleEntry = (AbstractMap.SimpleEntry)entry;
                this.put(simpleEntry.key, simpleEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object);
        HashEntry<K, V> hashEntry = this.buckets[n];
        HashEntry<K, V> hashEntry2 = null;
        while (hashEntry != null) {
            if (HashMap.equals(object, hashEntry.key)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.cleanup();
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry<K, V> hashEntry = this.buckets[i];
            while (hashEntry != null) {
                if (HashMap.equals(object, hashEntry.value)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.buckets = new HashEntry[this.buckets.length];
        hashMap.putAllInternal(this);
        hashMap.entries = null;
        return hashMap;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator<K> iterator() {
                    return HashMap.this.iterator(0);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    int n = HashMap.this.size;
                    HashMap.this.remove(object);
                    return n != HashMap.this.size;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return HashMap.this.iterator(1);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return HashMap.this.iterator(2);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.getEntry(object) != null;
                }

                @Override
                public boolean remove(Object object) {
                    HashEntry hashEntry = HashMap.this.getEntry(object);
                    if (hashEntry != null) {
                        HashMap.this.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(K k, V v, int n, boolean bl) {
        HashEntry<K, V> hashEntry = new HashEntry<K, V>(k, v);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
    }

    final HashEntry<K, V> getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)object;
        Object k = entry.getKey();
        int n = this.hash(k);
        HashEntry<K, V> hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (HashMap.equals(hashEntry.key, k)) {
                return HashMap.equals(hashEntry.value, entry.getValue()) ? hashEntry : null;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    final int hash(Object object) {
        return object == null ? 0 : Math.abs(object.hashCode() % this.buckets.length);
    }

    <T> Iterator<T> iterator(int n) {
        return new HashIterator(n);
    }

    void putAllInternal(Map<? extends K, ? extends V> map) {
        Map<K, V> map2 = map;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            ++this.size;
            K k = entry.getKey();
            int n = this.hash(k);
            this.addEntry(k, entry.getValue(), n, false);
        }
    }

    private void rehash() {
        HashEntry<K, V>[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry<K, V> hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                int n2 = this.hash(hashEntry.key);
                HashEntry<K, V> hashEntry2 = this.buckets[n2];
                HashEntry hashEntry3 = hashEntry.next;
                hashEntry.next = this.buckets[n2];
                this.buckets[n2] = hashEntry;
                hashEntry = hashEntry3;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.iterator(2);
        while (iterator.hasNext()) {
            HashEntry hashEntry = (HashEntry)iterator.next();
            objectOutputStream.writeObject(hashEntry.key);
            objectOutputStream.writeObject(hashEntry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.buckets = new HashEntry[objectInputStream.readInt()];
        this.size = n = objectInputStream.readInt();
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            this.addEntry(object, objectInputStream.readObject(), this.hash(object), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashIterator<T>
    implements Iterator<T> {
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry last;
        private HashEntry next;

        HashIterator(int n) {
            this.knownMod = HashMap.this.modCount;
            this.count = HashMap.this.size;
            this.idx = HashMap.this.buckets.length;
            this.type = n;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public T next() {
            if (this.knownMod != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = HashMap.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            if (this.type == 1) {
                return (T)hashEntry.value;
            }
            if (this.type == 0) {
                return (T)hashEntry.key;
            }
            return (T)hashEntry;
        }

        @Override
        public void remove() {
            if (this.knownMod != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashEntry<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        HashEntry<K, V> next;

        HashEntry(K k, V v) {
            super(k, v);
        }

        void access() {
        }

        V cleanup() {
            return (V)this.value;
        }
    }
}

