/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.UnknownFormatConversionException;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable out;
    private Locale locale;
    private boolean closed;
    private IOException ioException;
    private String format;
    private int index;
    private int length;
    private Locale fmtLocale;
    private static final String FLAGS = "--#+ 0,(";
    private static final String lineSeparator = SystemProperties.getProperty("line.separator");

    public Formatter() {
        this(null, Locale.getDefault());
    }

    public Formatter(Locale locale) {
        this(null, locale);
    }

    public Formatter(Appendable appendable) {
        this(appendable, Locale.getDefault());
    }

    public Formatter(Appendable appendable, Locale locale) {
        this.out = appendable == null ? new StringBuilder() : appendable;
        this.locale = locale;
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public Formatter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, string, Locale.getDefault());
    }

    public Formatter(File file, String string, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string), locale);
    }

    public Formatter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public Formatter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, string, Locale.getDefault());
    }

    public Formatter(OutputStream outputStream, String string, Locale locale) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, string), locale);
    }

    public Formatter(PrintStream printStream) {
        this((Appendable)printStream);
    }

    public Formatter(String string) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(string)));
    }

    public Formatter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(string, string2, Locale.getDefault());
    }

    public Formatter(String string, String string2, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2), locale);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    public void flush() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        try {
            if (this.out instanceof Flushable) {
                ((Flushable)((Object)this.out)).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getName(int n) {
        int n2 = Integer.numberOfTrailingZeros(n);
        return FLAGS.substring(n2, n2 + 1);
    }

    private void checkFlags(int n, int n2, char c) {
        if ((n &= ~n2) != 0) {
            throw new FormatFlagsConversionMismatchException(this.getName(n), c);
        }
    }

    private void noPrecision(int n) {
        if (n != -1) {
            throw new IllegalFormatPrecisionException(n);
        }
    }

    private void applyLocalization(CPStringBuilder cPStringBuilder, int n, int n2, boolean bl) {
        int n3;
        int n4;
        DecimalFormatSymbols decimalFormatSymbols = this.fmtLocale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(this.fmtLocale);
        char c = decimalFormatSymbols.getZeroDigit();
        int n5 = -1;
        for (n4 = cPStringBuilder.length() - 1; n4 >= 0; --n4) {
            n3 = cPStringBuilder.charAt(n4);
            if (n3 >= 48 && n3 <= 57) {
                cPStringBuilder.setCharAt(n4, (char)(n3 - 48 + c));
                continue;
            }
            if (n3 != 46) continue;
            assert (n5 == -1);
            n5 = n4;
        }
        if (n5 != -1) {
            cPStringBuilder.deleteCharAt(n5);
            cPStringBuilder.insert(n5, decimalFormatSymbols.getDecimalSeparator());
        }
        if ((n & 0x40) != 0) {
            n4 = decimalFormatSymbols.getGroupingSeparator();
            n3 = 3;
            int n6 = n5 == -1 ? cPStringBuilder.length() : n5;
            for (int i = n6 - n3; i > 0; i -= n3) {
                cPStringBuilder.insert(i, (char)n4);
            }
        }
        if ((n & 0x20) != 0) {
            for (n4 = n2 - cPStringBuilder.length(); n4 > 0; --n4) {
                cPStringBuilder.insert(0, c);
            }
        }
        if (bl) {
            if ((n & 0x80) != 0) {
                cPStringBuilder.insert(0, '(');
                cPStringBuilder.append(')');
            } else {
                cPStringBuilder.insert(0, '-');
            }
        } else if ((n & 8) != 0) {
            cPStringBuilder.insert(0, '+');
        } else if ((n & 0x10) != 0) {
            cPStringBuilder.insert(0, ' ');
        }
    }

    private void genericFormat(String string, int n, int n2, int n3) throws IOException {
        int n4;
        boolean bl;
        if ((n & 2) != 0) {
            string = this.fmtLocale == null ? string.toUpperCase() : string.toUpperCase(this.fmtLocale);
        }
        if (n3 >= 0 && string.length() > n3) {
            string = string.substring(0, n3);
        }
        boolean bl2 = bl = (n & 1) != 0;
        if (bl && n2 == -1) {
            throw new MissingFormatWidthException("fixme");
        }
        if (!bl && string.length() < n2) {
            for (n4 = n2 - string.length(); n4 > 0; --n4) {
                this.out.append(' ');
            }
        }
        this.out.append(string);
        if (bl && string.length() < n2) {
            for (n4 = n2 - string.length(); n4 > 0; --n4) {
                this.out.append(' ');
            }
        }
    }

    private void booleanFormat(Object object, int n, int n2, int n3, char c) throws IOException {
        this.checkFlags(n, 3, c);
        String string = object instanceof Boolean ? String.valueOf((Boolean)object) : (object == null ? "false" : "true");
        this.genericFormat(string, n, n2, n3);
    }

    private void hashCodeFormat(Object object, int n, int n2, int n3, char c) throws IOException {
        this.checkFlags(n, 3, c);
        this.genericFormat(object == null ? "null" : Integer.toHexString(object.hashCode()), n, n2, n3);
    }

    private void stringFormat(Object object, int n, int n2, int n3, char c) throws IOException {
        if (object instanceof Formattable) {
            this.checkFlags(n, 7, c);
            Formattable formattable = (Formattable)object;
            formattable.formatTo(this, n, n2, n3);
        } else {
            this.checkFlags(n, 3, c);
            this.genericFormat(object == null ? "null" : object.toString(), n, n2, n3);
        }
    }

    private void characterFormat(Object object, int n, int n2, int n3, char c) throws IOException {
        int n4;
        this.checkFlags(n, 3, c);
        this.noPrecision(n3);
        if (object instanceof Character) {
            n4 = ((Character)object).charValue();
        } else if (object instanceof Byte) {
            n4 = (char)((Byte)object).byteValue();
        } else if (object instanceof Short) {
            n4 = (char)((Short)object).shortValue();
        } else if (object instanceof Integer) {
            n4 = (Integer)object;
            if (!Character.isValidCodePoint(n4)) {
                throw new IllegalFormatCodePointException(n4);
            }
        } else {
            throw new IllegalFormatConversionException(c, object.getClass());
        }
        String string = new String(Character.toChars(n4));
        this.genericFormat(string, n, n2, n3);
    }

    private void percentFormat(int n, int n2, int n3) throws IOException {
        this.checkFlags(n, 1, '%');
        this.noPrecision(n3);
        this.genericFormat("%", n, n2, n3);
    }

    private void newLineFormat(int n, int n2, int n3) throws IOException {
        this.checkFlags(n, 0, 'n');
        this.noPrecision(n3);
        if (n2 != -1) {
            throw new IllegalFormatWidthException(n2);
        }
        this.genericFormat(lineSeparator, n, n2, n3);
    }

    private CPStringBuilder basicIntegralConversion(Object object, int n, int n2, int n3, int n4, char c) {
        String string;
        assert (n4 == 8 || n4 == 10 || n4 == 16);
        this.noPrecision(n3);
        if ((n & 8) != 0 && (n & 0x10) != 0) {
            throw new IllegalFormatFlagsException(this.getName(n));
        }
        if ((n & 1) != 0 && n2 == -1) {
            throw new MissingFormatWidthException("fixme");
        }
        int n5 = 35;
        n5 = n4 == 10 ? (n5 |= 0xD8) : (n5 |= 4);
        if (object instanceof BigInteger) {
            this.checkFlags(n, n5 | 8 | 0x10 | 0x80, c);
            BigInteger bigInteger = (BigInteger)object;
            string = bigInteger.toString(n4);
        } else if (object instanceof Number && !(object instanceof Float) && !(object instanceof Double)) {
            this.checkFlags(n, n5, c);
            long l = ((Number)object).longValue();
            string = n4 == 8 ? Long.toOctalString(l) : (n4 == 16 ? Long.toHexString(l) : Long.toString(l));
        } else {
            throw new IllegalFormatConversionException(c, object.getClass());
        }
        return new CPStringBuilder(string);
    }

    private void hexOrOctalConversion(Object object, int n, int n2, int n3, int n4, char c) throws IOException {
        int n5;
        assert (n4 == 8 || n4 == 16);
        CPStringBuilder cPStringBuilder = this.basicIntegralConversion(object, n, n2, n3, n4, c);
        int n6 = 0;
        if (cPStringBuilder.charAt(0) == '-') {
            ++n6;
        } else if ((n & 8) != 0) {
            cPStringBuilder.insert(n6, '+');
            ++n6;
        } else if ((n & 0x10) != 0) {
            cPStringBuilder.insert(n6, ' ');
            ++n6;
        }
        if ((n & 4) != 0) {
            cPStringBuilder.insert(n6, n4 == 8 ? "0" : "0x");
            n6 += n4 == 8 ? 1 : 2;
        }
        if ((n5 = cPStringBuilder.length()) < n2) {
            char c2;
            char c3 = c2 = (n & 0x20) != 0 ? (char)'0' : ' ';
            if ((n & 1) != 0) {
                if (c2 == ' ') {
                    n6 = cPStringBuilder.length();
                }
            } else {
                n6 = 0;
            }
            while (n5++ < n2) {
                cPStringBuilder.insert(n6, c2);
            }
        }
        String string = cPStringBuilder.toString();
        if ((n & 2) != 0) {
            string = this.fmtLocale == null ? string.toUpperCase() : string.toUpperCase(this.fmtLocale);
        }
        this.out.append(string);
    }

    private void decimalConversion(Object object, int n, int n2, int n3, char c) throws IOException {
        CPStringBuilder cPStringBuilder = this.basicIntegralConversion(object, n, n2, n3, 10, c);
        boolean bl = false;
        if (cPStringBuilder.charAt(0) == '-') {
            cPStringBuilder.deleteCharAt(0);
            bl = true;
        }
        this.applyLocalization(cPStringBuilder, n, n2, bl);
        this.genericFormat(cPStringBuilder.toString(), n, n2, n3);
    }

    private void singleDateTimeConversion(CPStringBuilder cPStringBuilder, Calendar calendar, char c, DateFormatSymbols dateFormatSymbols) {
        int n = cPStringBuilder.length();
        int n2 = -1;
        switch (c) {
            case 'H': {
                cPStringBuilder.append(calendar.get(11));
                n2 = 2;
                break;
            }
            case 'I': {
                cPStringBuilder.append(calendar.get(10));
                n2 = 2;
                break;
            }
            case 'k': {
                cPStringBuilder.append(calendar.get(11));
                break;
            }
            case 'l': {
                cPStringBuilder.append(calendar.get(10));
                break;
            }
            case 'M': {
                cPStringBuilder.append(calendar.get(12));
                n2 = 2;
                break;
            }
            case 'S': {
                cPStringBuilder.append(calendar.get(13));
                n2 = 2;
                break;
            }
            case 'N': {
                n2 = 9;
                break;
            }
            case 'p': {
                int n3 = calendar.get(9);
                cPStringBuilder.append(dateFormatSymbols.getAmPmStrings()[n3]);
                break;
            }
            case 'z': {
                int n4 = calendar.get(15) / 60000;
                cPStringBuilder.append(n4);
                n2 = 4;
                if (n4 >= 0) break;
                ++n;
                break;
            }
            case 'Z': {
                int n5 = calendar.get(15) / 3600000;
                String[][] stringArray = dateFormatSymbols.getZoneStrings();
                cPStringBuilder.append(stringArray[n5 + 12][1]);
                break;
            }
            case 's': {
                long l = calendar.getTime().getTime();
                cPStringBuilder.append(l / 1000L);
                break;
            }
            case 'Q': {
                long l = calendar.getTime().getTime();
                cPStringBuilder.append(l);
                break;
            }
            case 'B': {
                int n6 = calendar.get(2);
                cPStringBuilder.append(dateFormatSymbols.getMonths()[n6]);
                break;
            }
            case 'b': 
            case 'h': {
                int n7 = calendar.get(2);
                cPStringBuilder.append(dateFormatSymbols.getShortMonths()[n7]);
                break;
            }
            case 'A': {
                int n8 = calendar.get(7);
                cPStringBuilder.append(dateFormatSymbols.getWeekdays()[n8]);
                break;
            }
            case 'a': {
                int n9 = calendar.get(7);
                cPStringBuilder.append(dateFormatSymbols.getShortWeekdays()[n9]);
                break;
            }
            case 'C': {
                cPStringBuilder.append(calendar.get(1) / 100);
                n2 = 2;
                break;
            }
            case 'Y': {
                cPStringBuilder.append(calendar.get(1));
                n2 = 4;
                break;
            }
            case 'y': {
                cPStringBuilder.append(calendar.get(1) % 100);
                n2 = 2;
                break;
            }
            case 'j': {
                cPStringBuilder.append(calendar.get(6));
                n2 = 3;
                break;
            }
            case 'm': {
                cPStringBuilder.append(calendar.get(2) + 1);
                n2 = 2;
                break;
            }
            case 'd': {
                cPStringBuilder.append(calendar.get(5));
                n2 = 2;
                break;
            }
            case 'e': {
                cPStringBuilder.append(calendar.get(5));
                break;
            }
            case 'R': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'H', dateFormatSymbols);
                cPStringBuilder.append(':');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'M', dateFormatSymbols);
                break;
            }
            case 'T': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'H', dateFormatSymbols);
                cPStringBuilder.append(':');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'M', dateFormatSymbols);
                cPStringBuilder.append(':');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'S', dateFormatSymbols);
                break;
            }
            case 'r': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'I', dateFormatSymbols);
                cPStringBuilder.append(':');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'M', dateFormatSymbols);
                cPStringBuilder.append(':');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'S', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'p', dateFormatSymbols);
                break;
            }
            case 'D': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'm', dateFormatSymbols);
                cPStringBuilder.append('/');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'd', dateFormatSymbols);
                cPStringBuilder.append('/');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'y', dateFormatSymbols);
                break;
            }
            case 'F': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'Y', dateFormatSymbols);
                cPStringBuilder.append('-');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'm', dateFormatSymbols);
                cPStringBuilder.append('-');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'd', dateFormatSymbols);
                break;
            }
            case 'c': {
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'a', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'b', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'd', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'T', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'Z', dateFormatSymbols);
                cPStringBuilder.append(' ');
                this.singleDateTimeConversion(cPStringBuilder, calendar, 'Y', dateFormatSymbols);
                break;
            }
            default: {
                throw new UnknownFormatConversionException(String.valueOf(c));
            }
        }
        if (n2 > 0) {
            int n10 = cPStringBuilder.length();
            int n11 = n10 - n;
            while (n11++ < n2) {
                cPStringBuilder.insert(n, '0');
            }
        }
    }

    private void dateTimeConversion(Object object, int n, int n2, int n3, char c, char c2) throws IOException {
        Cloneable cloneable;
        Calendar calendar;
        this.noPrecision(n3);
        this.checkFlags(n, 3, c);
        if (object instanceof Calendar) {
            calendar = (Calendar)object;
        } else {
            if (object instanceof Date) {
                cloneable = (Date)object;
            } else if (object instanceof Long) {
                cloneable = new Date((Long)object);
            } else {
                throw new IllegalFormatConversionException(c, object.getClass());
            }
            calendar = this.fmtLocale == null ? Calendar.getInstance() : Calendar.getInstance(this.fmtLocale);
            calendar.setTime((Date)cloneable);
        }
        cloneable = this.fmtLocale == null ? new DateFormatSymbols() : new DateFormatSymbols(this.fmtLocale);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        this.singleDateTimeConversion(cPStringBuilder, calendar, c2, (DateFormatSymbols)cloneable);
        this.genericFormat(cPStringBuilder.toString(), n, n2, n3);
    }

    private void advance() {
        ++this.index;
        if (this.index >= this.length) {
            throw new IllegalArgumentException();
        }
    }

    private int parseInt() {
        int n = this.index;
        while (Character.isDigit(this.format.charAt(this.index))) {
            this.advance();
        }
        if (n == this.index) {
            return -1;
        }
        return Integer.parseInt(this.format.substring(n, this.index));
    }

    private int parseArgumentIndex() {
        int n = -1;
        int n2 = this.index;
        if (this.format.charAt(this.index) == '<') {
            n = 0;
            this.advance();
        } else if (Character.isDigit(this.format.charAt(this.index))) {
            n = this.parseInt();
            if (this.format.charAt(this.index) == '$') {
                this.advance();
            } else {
                this.index = n2;
                n = -1;
            }
        }
        return n;
    }

    private int parseFlags() {
        int n;
        int n2 = 0;
        int n3 = this.index;
        while ((n = FLAGS.indexOf(this.format.charAt(this.index))) != -1) {
            int n4 = 1 << n;
            if ((n2 & n4) != 0) {
                throw new DuplicateFormatFlagsException(this.format.substring(n3, this.index + 1));
            }
            n2 |= n4;
            this.advance();
        }
        return n2;
    }

    private int parseWidth() {
        return this.parseInt();
    }

    private int parsePrecision() {
        if (this.format.charAt(this.index) != '.') {
            return -1;
        }
        this.advance();
        int n = this.parseInt();
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        int n = 1;
        int n2 = 0;
        try {
            this.fmtLocale = locale;
            this.format = string;
            this.length = this.format.length();
            this.index = 0;
            while (this.index < this.length) {
                char c = this.format.charAt(this.index);
                if (c != '%') {
                    this.out.append(c);
                } else {
                    char c2;
                    int n3 = this.index;
                    this.advance();
                    int n4 = this.parseArgumentIndex();
                    int n5 = this.parseFlags();
                    int n6 = this.parseWidth();
                    int n7 = this.parsePrecision();
                    char c3 = c2 = this.format.charAt(this.index);
                    if (Character.isUpperCase(c3)) {
                        n5 |= 2;
                        c3 = Character.toLowerCase(c3);
                    }
                    Object object = null;
                    if (c3 == '%' || c3 == 'n') {
                        if (n4 != -1) {
                            throw new UnknownFormatConversionException("FIXME");
                        }
                    } else {
                        if (n4 == -1) {
                            n4 = n++;
                        } else if (n4 == 0) {
                            n4 = n2;
                        }
                        if (--n4 < 0 || n4 >= objectArray.length) {
                            throw new MissingFormatArgumentException(this.format.substring(n3, this.index));
                        }
                        object = objectArray[n4];
                    }
                    switch (c3) {
                        case 'b': {
                            this.booleanFormat(object, n5, n6, n7, c2);
                            break;
                        }
                        case 'h': {
                            this.hashCodeFormat(object, n5, n6, n7, c2);
                            break;
                        }
                        case 's': {
                            this.stringFormat(object, n5, n6, n7, c2);
                            break;
                        }
                        case 'c': {
                            this.characterFormat(object, n5, n6, n7, c2);
                            break;
                        }
                        case 'd': {
                            this.checkFlags(n5 & 2, 0, 'd');
                            this.decimalConversion(object, n5, n6, n7, c2);
                            break;
                        }
                        case 'o': {
                            this.checkFlags(n5 & 2, 0, 'o');
                            this.hexOrOctalConversion(object, n5, n6, n7, 8, c2);
                            break;
                        }
                        case 'x': {
                            this.hexOrOctalConversion(object, n5, n6, n7, 16, c2);
                        }
                        case 'e': {
                            break;
                        }
                        case 'f': {
                            break;
                        }
                        case 'g': {
                            break;
                        }
                        case 'a': {
                            break;
                        }
                        case 't': {
                            this.advance();
                            char c4 = this.format.charAt(this.index);
                            this.dateTimeConversion(object, n5, n6, n7, c2, c4);
                            break;
                        }
                        case '%': {
                            this.percentFormat(n5, n6, n7);
                            break;
                        }
                        case 'n': {
                            this.newLineFormat(n5, n6, n7);
                            break;
                        }
                        default: {
                            throw new UnknownFormatConversionException(String.valueOf(c2));
                        }
                    }
                }
                ++this.index;
            }
        }
        catch (IOException iOException) {
            this.ioException = iOException;
        }
        return this;
    }

    public Formatter format(String string, Object ... objectArray) {
        return this.format(this.locale, string, objectArray);
    }

    public IOException ioException() {
        return this.ioException;
    }

    public Locale locale() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.locale;
    }

    public Appendable out() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.out;
    }

    public String toString() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.out.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigDecimalLayoutForm {
        DECIMAL_FLOAT,
        SCIENTIFIC;

    }
}

