/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumSet<T extends Enum<T>>
extends AbstractSet<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4782406773684236311L;
    BitSet store;
    int cardinality;
    Class<T> enumClass;

    EnumSet() {
    }

    public EnumSet<T> clone() {
        EnumSet enumSet;
        try {
            enumSet = (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        enumSet.store = (BitSet)this.store.clone();
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> allOf(Class<T> clazz) {
        return EnumSet.copyOf(Arrays.asList(clazz.getEnumConstants()));
    }

    public static <T extends Enum<T>> EnumSet<T> noneOf(Class<T> clazz) {
        return EnumSet.complementOf(EnumSet.allOf(clazz));
    }

    public static <T extends Enum<T>> EnumSet<T> copyOf(EnumSet<T> enumSet) {
        return enumSet.clone();
    }

    public static <T extends Enum<T>> EnumSet<T> copyOf(Collection<T> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.copyOf((EnumSet)collection);
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        EnumSet<Enum> enumSet = null;
        for (Enum enum_ : collection) {
            if (enumSet == null) {
                enumSet = EnumSet.of(enum_);
                continue;
            }
            enumSet.add(enum_);
        }
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> complementOf(EnumSet<T> enumSet) {
        Object object = enumSet.clone();
        int n = ((Enum[])((EnumSet)object).enumClass.getEnumConstants()).length;
        ((EnumSet)object).store.flip(0, n);
        ((EnumSet)object).cardinality = n - enumSet.cardinality;
        return object;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t) {
        EnumSet enumSet = new EnumSet<T>(){

            @Override
            public boolean add(T t) {
                if (this.store.get(((Enum)t).ordinal())) {
                    return false;
                }
                this.store.set(((Enum)t).ordinal());
                ++this.cardinality;
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> collection) {
                boolean bl = false;
                if (collection instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)collection;
                    if (this.enumClass == enumSet.enumClass) {
                        this.store.or(enumSet.store);
                        int n = this.cardinality;
                        this.cardinality = this.store.cardinality();
                        bl = n != this.cardinality;
                    }
                } else {
                    for (Enum enum_ : collection) {
                        if (!this.add((T)enum_)) continue;
                        bl = true;
                    }
                }
                return bl;
            }

            @Override
            public void clear() {
                this.store.clear();
                this.cardinality = 0;
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Enum)) {
                    return false;
                }
                Enum enum_ = (Enum)object;
                if (enum_.getDeclaringClass() != this.enumClass) {
                    return false;
                }
                return this.store.get(enum_.ordinal());
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                if (collection instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)collection;
                    if (this.enumClass == enumSet.enumClass) {
                        return this.store.containsAll(enumSet.store);
                    }
                    return false;
                }
                return super.containsAll(collection);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int next = -1;
                    int count = 0;

                    @Override
                    public boolean hasNext() {
                        return this.count < cardinality;
                    }

                    @Override
                    public T next() {
                        this.next = store.nextSetBit(this.next + 1);
                        ++this.count;
                        return ((Enum[])enumClass.getEnumConstants())[this.next];
                    }

                    @Override
                    public void remove() {
                        if (!store.get(this.next)) {
                            store.clear(this.next);
                            --cardinality;
                        }
                    }
                };
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Enum)) {
                    return false;
                }
                Enum enum_ = (Enum)object;
                if (enum_.getDeclaringClass() != this.enumClass) {
                    return false;
                }
                this.store.clear(enum_.ordinal());
                --this.cardinality;
                return true;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                if (collection instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)collection;
                    if (this.enumClass != enumSet.enumClass) {
                        return false;
                    }
                    this.store.andNot(enumSet.store);
                    int n = this.cardinality;
                    this.cardinality = this.store.cardinality();
                    return n != this.cardinality;
                }
                return super.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                if (collection instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)collection;
                    if (this.enumClass != enumSet.enumClass) {
                        return false;
                    }
                    this.store.and(enumSet.store);
                    int n = this.cardinality;
                    this.cardinality = this.store.cardinality();
                    return n != this.cardinality;
                }
                return super.retainAll(collection);
            }

            @Override
            public int size() {
                return this.cardinality;
            }
        };
        enumSet.enumClass = t.getDeclaringClass();
        enumSet.store = new BitSet(((Enum[])enumSet.enumClass.getEnumConstants()).length);
        enumSet.add(t);
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t, T t2) {
        EnumSet<T> enumSet = EnumSet.of(t);
        enumSet.add(t2);
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t, T t2, T t3) {
        EnumSet<T> enumSet = EnumSet.of(t, t2);
        enumSet.add(t3);
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t, T t2, T t3, T t4) {
        EnumSet<T> enumSet = EnumSet.of(t, t2, t3);
        enumSet.add(t4);
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t, T t2, T t3, T t4, T t5) {
        EnumSet<T> enumSet = EnumSet.of(t, t2, t3, t4);
        enumSet.add(t5);
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T t, T ... TArray) {
        EnumSet<T> enumSet = EnumSet.noneOf(t.getDeclaringClass());
        enumSet.add(t);
        for (T t2 : TArray) {
            enumSet.add(t2);
        }
        return enumSet;
    }

    public static <T extends Enum<T>> EnumSet<T> range(T t, T t2) {
        if (t.compareTo(t2) > 0) {
            throw new IllegalArgumentException();
        }
        Class<T> clazz = t.getDeclaringClass();
        EnumSet<T> enumSet = EnumSet.noneOf(clazz);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = 0;
        while (t != enumArray[n]) {
            ++n;
        }
        while (t2 != enumArray[n]) {
            enumSet.add(enumArray[n]);
            ++n;
        }
        enumSet.add(t2);
        return enumSet;
    }
}

