/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 458661240069192865L;
    V[] store;
    int cardinality;
    Class<K> enumClass;
    transient Set<Map.Entry<K, V>> entries;
    static final Object emptySlot = new Object();

    public EnumMap(Class<K> clazz) {
        this.store = new Object[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.store, emptySlot);
        this.cardinality = 0;
        this.enumClass = clazz;
    }

    public EnumMap(EnumMap<K, ? extends V> enumMap) {
        this.store = (Object[])enumMap.store.clone();
        this.cardinality = enumMap.cardinality;
        this.enumClass = enumMap.enumClass;
    }

    public EnumMap(Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            this.store = (Object[])enumMap.store.clone();
            this.cardinality = enumMap.cardinality;
            this.enumClass = enumMap.enumClass;
        } else {
            for (Enum enum_ : map.keySet()) {
                int n;
                V v = map.get(enum_);
                if (this.store == null) {
                    this.enumClass = enum_.getDeclaringClass();
                    this.store = new Object[((Enum[])this.enumClass.getEnumConstants()).length];
                }
                if (this.store[n = enum_.ordinal()] == emptySlot) {
                    ++this.cardinality;
                }
                this.store[n] = v;
            }
            if (this.store == null) {
                throw new IllegalArgumentException("no elements in map");
            }
        }
    }

    @Override
    public int size() {
        return this.cardinality;
    }

    @Override
    public boolean containsValue(Object object) {
        for (V v : this.store) {
            if (v == emptySlot || !AbstractCollection.equals(v, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Enum)) {
            return false;
        }
        Enum enum_ = (Enum)object;
        if (enum_.getDeclaringClass() != this.enumClass) {
            return false;
        }
        return this.store[enum_.ordinal()] != emptySlot;
    }

    @Override
    public V get(Object object) {
        if (!(object instanceof Enum)) {
            return null;
        }
        Enum enum_ = (Enum)object;
        if (enum_.getDeclaringClass() != this.enumClass) {
            return null;
        }
        V v = this.store[enum_.ordinal()];
        return v == emptySlot ? null : (V)v;
    }

    @Override
    public V put(K k, V v) {
        V v2;
        int n = ((Enum)k).ordinal();
        if (this.store[n] == emptySlot) {
            v2 = null;
            ++this.cardinality;
        } else {
            v2 = this.store[n];
        }
        this.store[n] = v;
        return v2;
    }

    @Override
    public V remove(Object object) {
        if (!(object instanceof Enum)) {
            return null;
        }
        Enum enum_ = (Enum)object;
        if (enum_.getDeclaringClass() != this.enumClass) {
            return null;
        }
        V v = this.store[enum_.ordinal()];
        if (v == emptySlot) {
            v = null;
        } else {
            --this.cardinality;
        }
        this.store[enum_.ordinal()] = emptySlot;
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Enum enum_ : map.keySet()) {
            V v = map.get(enum_);
            int n = enum_.ordinal();
            if (this.store[n] == emptySlot) {
                ++this.cardinality;
            }
            this.store[n] = v;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.store, emptySlot);
        this.cardinality = 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < EnumMap.this.cardinality;
                        }

                        @Override
                        public K next() {
                            ++this.count;
                            ++this.index;
                            while (EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return ((Enum[])EnumMap.this.enumClass.getEnumConstants())[this.index];
                        }

                        @Override
                        public void remove() {
                            --EnumMap.this.cardinality;
                            EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return this.contains(object);
                }

                @Override
                public boolean remove(Object object) {
                    return EnumMap.this.remove(object) != null;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < EnumMap.this.cardinality;
                        }

                        @Override
                        public V next() {
                            ++this.count;
                            ++this.index;
                            while (EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return EnumMap.this.store[this.index];
                        }

                        @Override
                        public void remove() {
                            --EnumMap.this.cardinality;
                            EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < EnumMap.this.cardinality;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            ++this.count;
                            ++this.index;
                            while (EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return new AbstractMap.SimpleEntry<K, V>(((Enum[])EnumMap.this.enumClass.getEnumConstants())[this.index], EnumMap.this.store[this.index]){

                                @Override
                                public V setValue(V v) {
                                    this.value = v;
                                    return EnumMap.this.put((Enum)this.key, v);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            --EnumMap.this.cardinality;
                            EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return EnumMap.this.containsKey(entry.getKey()) && AbstractCollection.equals(EnumMap.this.get(entry.getKey()), entry.getValue());
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return EnumMap.this.remove(entry.getKey()) != null;
                }
            };
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EnumMap)) {
            return false;
        }
        EnumMap enumMap = (EnumMap)object;
        if (enumMap.enumClass != this.enumClass || enumMap.cardinality != this.cardinality) {
            return false;
        }
        return Arrays.equals(this.store, enumMap.store);
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap enumMap;
        try {
            enumMap = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            enumMap = null;
        }
        enumMap.store = (Object[])this.store.clone();
        return enumMap;
    }
}

