/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import gnu.java.text.FormatCharacterIterator;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private String pattern;
    private Locale locale;
    private MessageFormatElement[] elements;
    private String leader;

    private static int scanString(String string, int n, CPStringBuilder cPStringBuilder) {
        int n2 = string.length();
        cPStringBuilder.setLength(0);
        boolean bl = false;
        while (n < n2) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                } else {
                    cPStringBuilder.append(c);
                }
            } else if (c == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                cPStringBuilder.append(c);
                ++n;
            } else if (c == '\'') {
                bl = true;
            } else {
                if (c == '{') break;
                cPStringBuilder.append(c);
            }
            ++n;
        }
        return n;
    }

    private static int scanFormatElement(String string, int n, CPStringBuilder cPStringBuilder, char c) {
        int n2 = string.length();
        cPStringBuilder.setLength(0);
        int n3 = 1;
        boolean bl = false;
        while (n < n2) {
            char c2 = string.charAt(n);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                }
            } else if (c2 == '\'' && n + 1 < n2 && string.charAt(n + 1) == '\'') {
                cPStringBuilder.append(c2);
                ++n;
            } else if (c2 == '\'') {
                bl = true;
            } else if (c2 == '{') {
                ++n3;
            } else if (c2 == '}' ? --n3 == 0 : c2 == c) break;
            cPStringBuilder.append(c2);
            ++n;
        }
        return n;
    }

    private static int scanFormat(String string, int n, CPStringBuilder cPStringBuilder, List<MessageFormatElement> list2, Locale locale) {
        MessageFormatElement messageFormatElement = new MessageFormatElement();
        list2.add(messageFormatElement);
        int n2 = string.length();
        ++n;
        n = MessageFormat.scanFormatElement(string, n, cPStringBuilder, ',');
        try {
            messageFormatElement.argNumber = Integer.parseInt(cPStringBuilder.toString());
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            illegalArgumentException.initCause(numberFormatException);
            throw illegalArgumentException;
        }
        if (n < n2 && string.charAt(n) == ',') {
            n = MessageFormat.scanFormatElement(string, n + 1, cPStringBuilder, ',');
            messageFormatElement.type = cPStringBuilder.toString();
            if (n < n2 && string.charAt(n) == ',') {
                n = MessageFormat.scanFormatElement(string, n + 1, cPStringBuilder, '}');
                messageFormatElement.style = cPStringBuilder.toString();
            }
        }
        if (n >= n2 || string.charAt(n) != '}') {
            throw new IllegalArgumentException("Missing '}' at end of message format");
        }
        ++n;
        n = MessageFormat.scanString(string, n, cPStringBuilder);
        messageFormatElement.trailer = cPStringBuilder.toString();
        messageFormatElement.setLocale(locale);
        return n;
    }

    public void applyPattern(String string) {
        this.pattern = string;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = MessageFormat.scanString(string, 0, cPStringBuilder);
        this.leader = cPStringBuilder.toString();
        ArrayList<MessageFormatElement> arrayList = new ArrayList<MessageFormatElement>();
        while (n < string.length()) {
            n = MessageFormat.scanFormat(string, n, cPStringBuilder, arrayList, this.locale);
        }
        this.elements = arrayList.toArray(new MessageFormatElement[arrayList.size()]);
    }

    @Override
    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.elements = (MessageFormatElement[])this.elements.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MessageFormat)) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.pattern.equals(messageFormat.pattern) && this.locale.equals(messageFormat.locale);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        Object[] objectArray = (Object[])object;
        FormatCharacterIterator formatCharacterIterator = new FormatCharacterIterator();
        this.formatInternal(objectArray, new StringBuffer(), null, formatCharacterIterator);
        return formatCharacterIterator;
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        return messageFormat.formatInternal(objectArray, stringBuffer, fieldPosition, null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formatInternal(objectArray, stringBuffer, fieldPosition, null);
    }

    private StringBuffer formatInternal(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, FormatCharacterIterator formatCharacterIterator) {
        stringBuffer.append(this.leader);
        if (formatCharacterIterator != null) {
            formatCharacterIterator.append(this.leader);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Serializable serializable;
            Object object = null;
            boolean bl = false;
            if (objectArray == null || this.elements[i].argNumber >= objectArray.length) {
                bl = true;
            } else {
                object = objectArray[this.elements[i].argNumber];
            }
            AttributedCharacterIterator attributedCharacterIterator = null;
            Format format = null;
            if (fieldPosition != null && i == fieldPosition.getField() && fieldPosition.getFieldAttribute() == Field.ARGUMENT) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            if (bl) {
                stringBuffer.append("{" + this.elements[i].argNumber + "}");
            } else if (this.elements[i].setFormat != null) {
                format = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                if (this.elements[i].formatClass != null && !this.elements[i].formatClass.isInstance(object)) {
                    throw new IllegalArgumentException("Wrong format class");
                }
                format = this.elements[i].format;
            } else if (object instanceof Number) {
                format = NumberFormat.getInstance(this.locale);
            } else if (object instanceof Date) {
                format = DateFormat.getTimeInstance(2, this.locale);
            } else {
                stringBuffer.append(object);
            }
            if (fieldPosition != null && fieldPosition.getField() == i && fieldPosition.getFieldAttribute() == Field.ARGUMENT) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            if (format != null) {
                if (format instanceof ChoiceFormat) {
                    serializable = new StringBuffer();
                    format.format(object, (StringBuffer)serializable, fieldPosition);
                    MessageFormat messageFormat = new MessageFormat();
                    messageFormat.setLocale(this.locale);
                    messageFormat.applyPattern(((StringBuffer)serializable).toString());
                    messageFormat.format(objectArray, stringBuffer, fieldPosition);
                } else if (formatCharacterIterator != null) {
                    attributedCharacterIterator = format.formatToCharacterIterator(object);
                } else {
                    format.format(object, stringBuffer, fieldPosition);
                }
                this.elements[i].format = format;
            }
            if (formatCharacterIterator != null) {
                serializable = new HashMap();
                int n = formatCharacterIterator.getEndIndex();
                ((HashMap)serializable).put(Field.ARGUMENT, this.elements[i].argNumber);
                if (attributedCharacterIterator != null) {
                    formatCharacterIterator.append(attributedCharacterIterator);
                    formatCharacterIterator.addAttributes((HashMap)serializable, n, formatCharacterIterator.getEndIndex());
                } else {
                    formatCharacterIterator.append(object.toString(), (HashMap)serializable);
                }
                formatCharacterIterator.append(this.elements[i].trailer);
            }
            stringBuffer.append(this.elements[i].trailer);
        }
        return stringBuffer;
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object[])object, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.elements.length];
        for (int i = this.elements.length - 1; i >= 0; --i) {
            formatArray[i] = this.elements[i].setFormat;
        }
        return formatArray;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.locale.hashCode();
    }

    private MessageFormat() {
    }

    public MessageFormat(String string) {
        this(string, Locale.getDefault());
    }

    public MessageFormat(String string, Locale locale) {
        this.locale = locale;
        this.applyPattern(string);
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        if (!string.startsWith(this.leader, n)) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        n += this.leader.length();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            Format format = null;
            if (this.elements[i].setFormat != null) {
                format = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                format = this.elements[i].format;
            }
            Object[] objectArray = null;
            if (format instanceof ChoiceFormat) {
                int n2;
                ChoiceFormat choiceFormat = (ChoiceFormat)format;
                String[] stringArray = (String[])choiceFormat.getFormats();
                double[] dArray = choiceFormat.getLimits();
                MessageFormat messageFormat = new MessageFormat();
                messageFormat.setLocale(this.locale);
                ParsePosition parsePosition2 = new ParsePosition(n);
                for (n2 = 0; objectArray == null && n2 < dArray.length; ++n2) {
                    messageFormat.applyPattern(stringArray[n2]);
                    parsePosition2.setIndex(n);
                    objectArray = messageFormat.parse(string, parsePosition2);
                }
                if (objectArray != null) {
                    n = parsePosition2.getIndex();
                    objectArray = new Double(dArray[n2]);
                }
            } else if (format != null) {
                parsePosition.setIndex(n);
                objectArray = format.parseObject(string, parsePosition);
                if (objectArray != null) {
                    n = parsePosition.getIndex();
                }
            } else {
                int n3 = this.elements[i].trailer.length() > 0 ? string.indexOf(this.elements[i].trailer, n) : string.length();
                if (n3 == -1) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                objectArray = string.substring(n, n3);
                n = n3;
            }
            if (objectArray == null || !string.startsWith(this.elements[i].trailer, n)) {
                parsePosition.setErrorIndex(n);
                return null;
            }
            if (this.elements[i].argNumber >= arrayList.size()) {
                arrayList.ensureCapacity(this.elements[i].argNumber + 1);
                for (int j = arrayList.size(); j <= this.elements[i].argNumber; ++j) {
                    arrayList.add(j, null);
                }
            }
            arrayList.set(this.elements[i].argNumber, objectArray);
            n += this.elements[i].trailer.length();
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (objectArray == null) {
            throw new ParseException("couldn't parse string", parsePosition.getErrorIndex());
        }
        return objectArray;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setFormat(int n, Format format) {
        this.elements[n].setFormat = format;
    }

    public void setFormats(Format[] formatArray) {
        if (formatArray.length < this.elements.length) {
            throw new IllegalArgumentException("Not enough format objects");
        }
        int n = Math.min(formatArray.length, this.elements.length);
        for (int i = 0; i < n; ++i) {
            this.elements[i].setFormat = formatArray[i];
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setLocale(locale);
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    public Format[] getFormatsByArgumentIndex() {
        int n = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].argNumber <= n) continue;
            n = this.elements[i].argNumber;
        }
        Format[] formatArray = new Format[n];
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].setFormat != null) {
                formatArray[this.elements[i].argNumber] = this.elements[i].setFormat;
                continue;
            }
            if (this.elements[i].format == null) continue;
            formatArray[this.elements[i].argNumber] = this.elements[i].format;
        }
        return formatArray;
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].argNumber != n) continue;
            this.elements[i].setFormat = format;
        }
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        for (int i = 0; i < formatArray.length; ++i) {
            this.setFormatByArgumentIndex(i, formatArray[i]);
        }
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("argument");

        private Field() {
            super("");
        }

        protected Field(String string) {
            super(string);
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("no such MessageFormat field called " + this.getName());
        }
    }

    private static final class MessageFormatElement {
        int argNumber;
        Format setFormat;
        Format format;
        Class<?> formatClass;
        String type;
        String style;
        String trailer;

        private MessageFormatElement() {
        }

        void setLocale(Locale locale) {
            if (this.type != null) {
                if (this.type.equals("number")) {
                    this.formatClass = Number.class;
                    if (this.style == null) {
                        this.format = NumberFormat.getInstance(locale);
                    } else if (this.style.equals("currency")) {
                        this.format = NumberFormat.getCurrencyInstance(locale);
                    } else if (this.style.equals("percent")) {
                        this.format = NumberFormat.getPercentInstance(locale);
                    } else if (this.style.equals("integer")) {
                        this.format = NumberFormat.getIntegerInstance(locale);
                    } else {
                        this.format = NumberFormat.getNumberInstance(locale);
                        DecimalFormat decimalFormat = (DecimalFormat)this.format;
                        decimalFormat.applyPattern(this.style);
                    }
                } else if (this.type.equals("time") || this.type.equals("date")) {
                    this.formatClass = Date.class;
                    int n = 2;
                    boolean bl = false;
                    if (this.style != null) {
                        if (this.style.equals("short")) {
                            n = 3;
                        } else if (this.style.equals("medium")) {
                            n = 2;
                        } else if (this.style.equals("long")) {
                            n = 1;
                        } else if (this.style.equals("full")) {
                            n = 0;
                        } else {
                            bl = true;
                        }
                    }
                    this.format = this.type.equals("time") ? DateFormat.getTimeInstance(n, locale) : DateFormat.getDateInstance(n, locale);
                    if (bl) {
                        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.format;
                        simpleDateFormat.applyPattern(this.style);
                    }
                } else if (this.type.equals("choice")) {
                    this.formatClass = Number.class;
                    if (this.style == null) {
                        throw new IllegalArgumentException("style required for choice format");
                    }
                    this.format = new ChoiceFormat(this.style);
                }
            }
        }
    }
}

