/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Locale;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private static final int DEFAULT_INTEGER_DIGITS = 309;
    private static final int DEFAULT_FRACTION_DIGITS = 340;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);
    private boolean parseBigDecimal;
    private boolean useCurrencySeparator;
    private boolean decimalSeparatorAlwaysShown;
    private boolean showDecimalSeparator;
    private boolean groupingSeparatorInPattern;
    private byte groupingSize;
    private byte minExponentDigits;
    private int exponentRound;
    private int multiplier;
    private int negativePatternMultiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;
    private int maxIntegerDigitsExponent;
    private boolean hasNegativePrefix;
    private boolean hasFractionalPattern;
    private ArrayList attributes = new ArrayList();

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String string) {
        this(string, new DecimalFormatSymbols());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPatternWithSymbols(string, nonLocalizedSymbols);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPatternWithSymbols(string, this.symbols);
    }

    public void applyPattern(String string) {
        this.applyPatternWithSymbols(string, nonLocalizedSymbols);
    }

    public Object clone() {
        DecimalFormat decimalFormat = (DecimalFormat)super.clone();
        decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return decimalFormat;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.groupingUsed == decimalFormat.groupingUsed && this.groupingSeparatorInPattern == decimalFormat.groupingSeparatorInPattern && this.groupingSize == decimalFormat.groupingSize && this.multiplier == decimalFormat.multiplier && this.useExponentialNotation == decimalFormat.useExponentialNotation && this.minExponentDigits == decimalFormat.minExponentDigits && this.minimumIntegerDigits == decimalFormat.minimumIntegerDigits && this.maximumIntegerDigits == decimalFormat.maximumIntegerDigits && this.minimumFractionDigits == decimalFormat.minimumFractionDigits && this.maximumFractionDigits == decimalFormat.maximumFractionDigits && this.parseBigDecimal == decimalFormat.parseBigDecimal && this.useCurrencySeparator == decimalFormat.useCurrencySeparator && this.showDecimalSeparator == decimalFormat.showDecimalSeparator && this.exponentRound == decimalFormat.exponentRound && this.negativePatternMultiplier == decimalFormat.negativePatternMultiplier && this.maxIntegerDigitsExponent == decimalFormat.maxIntegerDigitsExponent && this.equals(this.negativePrefix, decimalFormat.negativePrefix) && this.equals(this.negativeSuffix, decimalFormat.negativeSuffix) && this.equals(this.positivePrefix, decimalFormat.positivePrefix) && this.equals(this.positiveSuffix, decimalFormat.positiveSuffix) && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return this.toPattern().hashCode();
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof BigInteger) {
            BigDecimal bigDecimal = new BigDecimal((BigInteger)object);
            this.formatInternal(bigDecimal, true, stringBuffer, fieldPosition);
            return stringBuffer;
        }
        if (object instanceof BigDecimal) {
            this.formatInternal((BigDecimal)object, true, stringBuffer, fieldPosition);
            return stringBuffer;
        }
        return super.format(object, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (Double.isNaN(d)) {
            String string = this.symbols.getNaN();
            stringBuffer.append(string);
            if (fieldPosition.getField() == 0 || fieldPosition.getFieldAttribute() == NumberFormat.Field.INTEGER) {
                int n = stringBuffer.length();
                fieldPosition.setBeginIndex(n - string.length());
                fieldPosition.setEndIndex(n);
            }
        } else if (Double.isInfinite(d)) {
            if (d < 0.0) {
                stringBuffer.append(this.negativePrefix);
            } else {
                stringBuffer.append(this.positivePrefix);
            }
            stringBuffer.append(this.symbols.getInfinity());
            if (d < 0.0) {
                stringBuffer.append(this.negativeSuffix);
            } else {
                stringBuffer.append(this.positiveSuffix);
            }
            if (fieldPosition.getField() == 0 || fieldPosition.getFieldAttribute() == NumberFormat.Field.INTEGER) {
                fieldPosition.setBeginIndex(stringBuffer.length());
                fieldPosition.setEndIndex(0);
            }
        } else {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
            this.formatInternal(bigDecimal, false, stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(l));
        this.formatInternal(bigDecimal, true, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException("Passed Object is null");
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.attributes.clear();
        super.format(object, stringBuffer, new FieldPosition(0));
        AttributedString attributedString = new AttributedString(stringBuffer.toString());
        for (int i = 0; i < this.attributes.size(); ++i) {
            FieldPosition fieldPosition = (FieldPosition)this.attributes.get(i);
            Format.Field field = fieldPosition.getFieldAttribute();
            attributedString.addAttribute(field, field, fieldPosition.getBeginIndex(), fieldPosition.getEndIndex());
        }
        return attributedString.getIterator();
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setParseBigDecimal(boolean bl) {
        this.parseBigDecimal = bl;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        if (string.contains(this.symbols.getNaN())) {
            return Double.NaN;
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        char c2 = this.symbols.getMinusSign();
        int n2 = parsePosition.getIndex();
        String string2 = this.negativePrefix.compareTo("") == 0 ? c2 + this.positivePrefix : this.negativePrefix;
        int n3 = this.positivePrefix.length();
        int n4 = string2.length();
        boolean bl = string.startsWith(string2);
        boolean bl2 = string.startsWith(this.positivePrefix);
        if (bl2 && bl) {
            if (n4 > n3) {
                n2 += string2.length();
                bl = true;
            } else {
                n2 += this.positivePrefix.length();
                bl2 = true;
                if (n4 < n3) {
                    bl = false;
                }
            }
        } else if (bl) {
            n2 += string2.length();
            bl2 = false;
        } else if (bl2) {
            n2 += this.positivePrefix.length();
            bl = false;
        } else {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        char c3 = this.symbols.getDecimalSeparator();
        char c4 = this.symbols.getZeroDigit();
        char c5 = this.symbols.getExponential();
        int n5 = n2 + this.maximumIntegerDigits + this.maximumFractionDigits + 2;
        if (this.useExponentialNotation) {
            n5 += this.minExponentDigits + 1;
        }
        boolean bl3 = false;
        int n6 = string.length();
        if (n6 < n5) {
            n5 = n6;
        }
        char c6 = this.symbols.getGroupingSeparator();
        for (n = n2; n < n5; ++n) {
            char c = string.charAt(n);
            if (c >= c4 && c <= c4 + 9) {
                cPStringBuilder.append(c);
                continue;
            }
            if (this.parseIntegerOnly) {
                --n;
                break;
            }
            if (c == c3) {
                cPStringBuilder.append('.');
                continue;
            }
            if (c == c5) {
                cPStringBuilder.append(c);
                bl3 = !bl3;
                continue;
            }
            if (c != '+' && c != '-' && c != c2) continue;
            if (bl3) {
                cPStringBuilder.append(c);
                continue;
            }
            --n;
            break;
        }
        if (string.contains(this.symbols.getInfinity())) {
            int n7 = string.indexOf(this.symbols.getInfinity());
            parsePosition.setIndex(n7);
            if (this.parseBigDecimal) {
                if (bl) {
                    return BigDecimal.valueOf(Double.NEGATIVE_INFINITY);
                }
                return BigDecimal.valueOf(Double.POSITIVE_INFINITY);
            }
            if (bl) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (n == n2 || cPStringBuilder.length() == 0) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        boolean bl4 = string.endsWith(this.negativeSuffix);
        boolean bl5 = string.endsWith(this.positiveSuffix);
        boolean bl6 = this.negativeSuffix.equals(this.positiveSuffix);
        n3 = this.positiveSuffix.length();
        n4 = this.negativeSuffix.length();
        if (bl && !bl4) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        if (bl4 && !bl6 && n4 > n3) {
            bl = true;
        } else if (!bl5) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        if (bl) {
            cPStringBuilder.insert(0, '-');
        }
        parsePosition.setIndex(n);
        BigDecimal bigDecimal = new BigDecimal(cPStringBuilder.toString());
        if (this.parseBigDecimal) {
            return bigDecimal;
        }
        if (this.parseIntegerOnly) {
            return bigDecimal.longValue();
        }
        if (bl && bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return -0.0;
        }
        try {
            BigDecimal bigDecimal2 = bigDecimal.setScale(0, 7);
            return bigDecimal2.longValue();
        }
        catch (ArithmeticException arithmeticException) {
            return bigDecimal.doubleValue();
        }
    }

    public void setCurrency(Currency currency) {
        Currency currency2 = this.symbols.getCurrency();
        if (currency2 != currency) {
            int n;
            int n2;
            int n3;
            String string = this.symbols.getCurrencySymbol();
            int n4 = string.length();
            this.symbols.setCurrency(currency);
            String string2 = this.symbols.getCurrencySymbol();
            int n5 = this.positivePrefix.indexOf(string);
            if (n5 != -1) {
                this.positivePrefix = this.positivePrefix.substring(0, n5) + string2 + this.positivePrefix.substring(n5 + n4);
            }
            if ((n3 = this.negativePrefix.indexOf(string)) != -1) {
                this.negativePrefix = this.negativePrefix.substring(0, n3) + string2 + this.negativePrefix.substring(n3 + n4);
            }
            if ((n2 = this.positiveSuffix.indexOf(string)) != -1) {
                this.positiveSuffix = this.positiveSuffix.substring(0, n2) + string2 + this.positiveSuffix.substring(n2 + n4);
            }
            if ((n = this.negativeSuffix.indexOf(string)) != -1) {
                this.negativeSuffix = this.negativeSuffix.substring(0, n) + string2 + this.negativeSuffix.substring(n + n4);
            }
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public void setMaximumIntegerDigits(int n) {
        n = n > 0 ? n : 0;
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    public void setMinimumIntegerDigits(int n) {
        n = n > 0 ? n : 0;
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    public void setMaximumFractionDigits(int n) {
        n = n > 0 ? n : 0;
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    public void setMinimumFractionDigits(int n) {
        n = n > 0 ? n : 0;
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    private String patternChars(DecimalFormatSymbols decimalFormatSymbols) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append(decimalFormatSymbols.getDecimalSeparator());
        cPStringBuilder.append(decimalFormatSymbols.getDigit());
        cPStringBuilder.append(decimalFormatSymbols.getExponential());
        cPStringBuilder.append(decimalFormatSymbols.getGroupingSeparator());
        cPStringBuilder.append(decimalFormatSymbols.getMinusSign());
        cPStringBuilder.append(decimalFormatSymbols.getPatternSeparator());
        cPStringBuilder.append(decimalFormatSymbols.getPercent());
        cPStringBuilder.append(decimalFormatSymbols.getPerMill());
        cPStringBuilder.append(decimalFormatSymbols.getZeroDigit());
        cPStringBuilder.append('\'');
        cPStringBuilder.append('\u00a4');
        return cPStringBuilder.toString();
    }

    private CPStringBuilder quoteFix(String string, String string2) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                cPStringBuilder.append('\'');
                cPStringBuilder.append(c);
                if (c == '\'') continue;
                cPStringBuilder.append('\'');
                continue;
            }
            cPStringBuilder.append(c);
        }
        return cPStringBuilder;
    }

    private String computePattern(DecimalFormatSymbols decimalFormatSymbols) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.groupingUsed ? this.groupingSize + 1 : this.groupingSize;
        int n3 = Math.max(this.minimumIntegerDigits, n2);
        if (!this.useExponentialNotation) {
            stringBuilder.append(decimalFormatSymbols.getDigit());
        }
        for (n = 1; n < n3 - this.minimumIntegerDigits; ++n) {
            stringBuilder.append(decimalFormatSymbols.getDigit());
        }
        for (n = n3 - this.minimumIntegerDigits; n < n3; ++n) {
            stringBuilder.append(decimalFormatSymbols.getZeroDigit());
        }
        if (this.groupingUsed) {
            stringBuilder.insert(stringBuilder.length() - this.groupingSize, decimalFormatSymbols.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            stringBuilder.append(decimalFormatSymbols.getDecimalSeparator());
        }
        for (n = 0; n < this.minimumFractionDigits; ++n) {
            stringBuilder.append(decimalFormatSymbols.getZeroDigit());
        }
        for (n = this.minimumFractionDigits; n < this.maximumFractionDigits; ++n) {
            stringBuilder.append(decimalFormatSymbols.getDigit());
        }
        if (this.useExponentialNotation) {
            stringBuilder.append(decimalFormatSymbols.getExponential());
            for (n = 0; n < this.minExponentDigits; ++n) {
                stringBuilder.append(decimalFormatSymbols.getZeroDigit());
            }
            if (this.minExponentDigits == 0) {
                stringBuilder.append(decimalFormatSymbols.getDigit());
            }
        }
        String string = stringBuilder.toString();
        String string2 = this.patternChars(decimalFormatSymbols);
        stringBuilder.insert(0, this.quoteFix(this.positivePrefix, string2));
        stringBuilder.append(this.quoteFix(this.positiveSuffix, string2));
        if (this.hasNegativePrefix) {
            stringBuilder.append(decimalFormatSymbols.getPatternSeparator());
            stringBuilder.append(this.quoteFix(this.negativePrefix, string2));
            stringBuilder.append(string);
            stringBuilder.append(this.quoteFix(this.negativeSuffix, string2));
        }
        return stringBuilder.toString();
    }

    private void applyPatternWithSymbols(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.setDefaultValues();
        int n = string.length();
        if (n == 0) {
            this.minimumIntegerDigits = 1;
            this.maximumIntegerDigits = 309;
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 340;
            this.minExponentDigits = 0;
            this.showDecimalSeparator = true;
            this.groupingUsed = true;
            this.groupingSize = (byte)3;
            return;
        }
        int n2 = this.scanFix(string, decimalFormatSymbols, 0, true);
        if (n2 < n) {
            n2 = this.scanNumberInteger(string, decimalFormatSymbols, n2);
        }
        if (n2 < n) {
            n2 = this.scanFractionalPortion(string, decimalFormatSymbols, n2);
        } else {
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 0;
        }
        if (n2 < n) {
            n2 = this.scanExponent(string, decimalFormatSymbols, n2);
        }
        if (n2 < n) {
            n2 = this.scanFix(string, decimalFormatSymbols, n2, false);
        }
        if (n2 < n) {
            this.scanNegativePattern(string, decimalFormatSymbols, n2);
        }
        if (this.useExponentialNotation && this.maxIntegerDigitsExponent > this.minimumIntegerDigits && this.maxIntegerDigitsExponent > 1) {
            this.minimumIntegerDigits = 1;
            this.exponentRound = this.maxIntegerDigitsExponent;
        }
        if (this.useExponentialNotation) {
            this.maximumIntegerDigits = this.maxIntegerDigitsExponent;
        }
        if (!this.hasFractionalPattern && this.showDecimalSeparator) {
            this.decimalSeparatorAlwaysShown = true;
        }
    }

    private int scanFix(String string, DecimalFormatSymbols decimalFormatSymbols, int n, boolean bl) {
        int n2;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        char c = decimalFormatSymbols.getDecimalSeparator();
        char c2 = decimalFormatSymbols.getPatternSeparator();
        char c3 = decimalFormatSymbols.getGroupingSeparator();
        char c4 = decimalFormatSymbols.getDigit();
        char c5 = decimalFormatSymbols.getZeroDigit();
        char c6 = decimalFormatSymbols.getMinusSign();
        char c7 = decimalFormatSymbols.getPercent();
        char c8 = decimalFormatSymbols.getPerMill();
        String string2 = this.symbols.getCurrencySymbol();
        boolean bl2 = false;
        char c9 = string.charAt(n);
        if (c9 == c2) {
            this.hasNegativePrefix = true;
            return ++n;
        }
        int n3 = string.length();
        for (n2 = n; n2 < n3; ++n2) {
            c9 = string.charAt(n2);
            if (!bl2 && c9 == c2) {
                if (this.hasNegativePrefix) {
                    throw new IllegalArgumentException("Invalid pattern found: " + n);
                }
                this.hasNegativePrefix = true;
                ++n2;
                break;
            }
            if (!bl2 && (c9 == c6 || c9 == c4 || c9 == c5 || c9 == c3)) break;
            if (!bl2 && c9 == c) {
                this.showDecimalSeparator = true;
                break;
            }
            if (bl2 && c9 != '\'') {
                cPStringBuilder.append(c9);
                continue;
            }
            if (c9 == '\u00a4') {
                string2 = this.symbols.getCurrencySymbol();
                if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\u00a4') {
                    string2 = this.symbols.getInternationalCurrencySymbol();
                    ++n2;
                }
                this.useCurrencySeparator = true;
                cPStringBuilder.append(string2);
                continue;
            }
            if (c9 == c7) {
                this.multiplier = 100;
                cPStringBuilder.append(this.symbols.getPercent());
                continue;
            }
            if (c9 == c8) {
                this.multiplier = 1000;
                cPStringBuilder.append(this.symbols.getPerMill());
                continue;
            }
            if (c9 == '\'') {
                if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                    cPStringBuilder.append(c9);
                    ++n2;
                    continue;
                }
                bl2 = !bl2;
                continue;
            }
            cPStringBuilder.append(c9);
        }
        if (bl) {
            this.positivePrefix = cPStringBuilder.toString();
            this.negativePrefix = c6 + "" + this.positivePrefix;
        } else {
            this.positiveSuffix = cPStringBuilder.toString();
        }
        return n2;
    }

    private int scanNumberInteger(String string, DecimalFormatSymbols decimalFormatSymbols, int n) {
        char c;
        int n2;
        char c2 = decimalFormatSymbols.getDigit();
        char c3 = decimalFormatSymbols.getZeroDigit();
        char c4 = decimalFormatSymbols.getGroupingSeparator();
        char c5 = decimalFormatSymbols.getDecimalSeparator();
        char c6 = decimalFormatSymbols.getExponential();
        char c7 = decimalFormatSymbols.getPatternSeparator();
        int n3 = 0;
        int n4 = 0;
        this.maxIntegerDigitsExponent = 0;
        boolean bl = false;
        int n5 = string.length();
        for (n2 = n; n2 < n5 && (c = string.charAt(n2)) != c5 && c != c6; ++n2) {
            if (this.hasNegativePrefix && c == c7) {
                throw new IllegalArgumentException("Invalid pattern found: " + n);
            }
            if (c == c2) {
                if (n3 > 0) {
                    throw new IllegalArgumentException("digit mark following zero in positive subpattern, not allowed. Position: " + n2);
                }
                ++n4;
                bl = true;
                ++this.maxIntegerDigitsExponent;
                continue;
            }
            if (c == c3) {
                ++n3;
                ++n4;
                ++this.maxIntegerDigitsExponent;
                continue;
            }
            if (c != c4) break;
            this.groupingSeparatorInPattern = true;
            this.groupingUsed = true;
            n4 = 0;
        }
        if (this.groupingSeparatorInPattern) {
            this.groupingSize = (byte)n4;
        }
        this.minimumIntegerDigits = n3;
        if (bl && this.maximumIntegerDigits > 0 && this.minimumIntegerDigits == 0) {
            this.minimumIntegerDigits = 1;
        }
        return n2;
    }

    private int scanFractionalPortion(String string, DecimalFormatSymbols decimalFormatSymbols, int n) {
        int n2;
        char c = decimalFormatSymbols.getDigit();
        char c2 = decimalFormatSymbols.getZeroDigit();
        char c3 = decimalFormatSymbols.getGroupingSeparator();
        char c4 = decimalFormatSymbols.getDecimalSeparator();
        char c5 = decimalFormatSymbols.getExponential();
        char c6 = decimalFormatSymbols.getPatternSeparator();
        char c7 = string.charAt(n);
        if (c7 != c4) {
            this.minimumFractionDigits = 0;
            this.maximumFractionDigits = 0;
            return n;
        }
        this.hasFractionalPattern = true;
        this.minimumFractionDigits = 0;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = ++n; n2 < n4 && (c7 = string.charAt(n2)) != c5 && c7 != c6; ++n2) {
            if (c7 == c3 || c7 == c4) {
                throw new IllegalArgumentException("unexpected character '" + c7 + "' " + "in fractional subpattern. Position: " + n2);
            }
            if (c7 == c) {
                ++n3;
                continue;
            }
            if (c7 != c2) break;
            if (n3 > 0) {
                throw new IllegalArgumentException("digit mark following zero in positive subpattern, not allowed. Position: " + n2);
            }
            ++this.minimumFractionDigits;
        }
        if (n2 == n) {
            this.hasFractionalPattern = false;
        }
        this.maximumFractionDigits = this.minimumFractionDigits + n3;
        this.showDecimalSeparator = true;
        return n2;
    }

    private int scanExponent(String string, DecimalFormatSymbols decimalFormatSymbols, int n) {
        int n2;
        char c = decimalFormatSymbols.getDigit();
        char c2 = decimalFormatSymbols.getZeroDigit();
        char c3 = decimalFormatSymbols.getGroupingSeparator();
        char c4 = decimalFormatSymbols.getDecimalSeparator();
        char c5 = decimalFormatSymbols.getExponential();
        char c6 = string.charAt(n);
        if (c6 == c4) {
            ++n;
        }
        if (c6 != c5) {
            this.useExponentialNotation = false;
            return n;
        }
        this.minExponentDigits = 0;
        int n3 = string.length();
        for (n2 = ++n; n2 < n3; ++n2) {
            c6 = string.charAt(n2);
            if (c6 == c3 || c6 == c4 || c6 == c || c6 == c5) {
                throw new IllegalArgumentException("unexpected character '" + c6 + "' " + "in exponential subpattern. Position: " + n2);
            }
            if (c6 != c2) break;
            this.minExponentDigits = (byte)(this.minExponentDigits + 1);
        }
        this.useExponentialNotation = true;
        return n2;
    }

    private void scanNegativePattern(String string, DecimalFormatSymbols decimalFormatSymbols, int n) {
        char c;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = decimalFormatSymbols.getDecimalSeparator();
        char c3 = decimalFormatSymbols.getPatternSeparator();
        char c4 = decimalFormatSymbols.getGroupingSeparator();
        char c5 = decimalFormatSymbols.getDigit();
        char c6 = decimalFormatSymbols.getZeroDigit();
        char c7 = decimalFormatSymbols.getMinusSign();
        char c8 = decimalFormatSymbols.getPercent();
        char c9 = decimalFormatSymbols.getPerMill();
        String string3 = string2 = this.symbols.getCurrencySymbol();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = string.length();
        if (n2 > 0) {
            this.hasNegativePrefix = true;
        }
        if ((c = string.charAt(n)) == c3) {
            if (n + 1 > n2) {
                throw new IllegalArgumentException("unexpected character '" + c + "' " + "in negative subpattern.");
            }
            ++n;
        }
        for (int i = n; i < n2; ++i) {
            c = string.charAt(i);
            if (!(bl || c != c5 && c != c6 && c != c2 && c != c3 && c != c4)) {
                if (bl2) continue;
                this.negativePrefix = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
                bl2 = true;
                continue;
            }
            if (c == c7) {
                stringBuilder.append(this.symbols.getMinusSign());
                continue;
            }
            if (bl && c != '\'') {
                stringBuilder.append(c);
                continue;
            }
            if (c == '\u00a4') {
                string3 = string2;
                if (i + 1 < n2 && string.charAt(i + 1) == '\u00a4') {
                    string3 = this.symbols.getInternationalCurrencySymbol();
                    i += 2;
                }
                stringBuilder.append(string3);
                continue;
            }
            if (c == c8) {
                this.negativePatternMultiplier = 100;
                stringBuilder.append(this.symbols.getPercent());
                continue;
            }
            if (c == c9) {
                this.negativePatternMultiplier = 1000;
                stringBuilder.append(this.symbols.getPerMill());
                continue;
            }
            if (c == '\'') {
                if (i + 1 < n2 && string.charAt(i + 1) == '\'') {
                    stringBuilder.append(c);
                    ++i;
                    continue;
                }
                bl = !bl;
                continue;
            }
            if (c == c3) {
                throw new IllegalArgumentException("unexpected character '" + c + "' in negative subpattern.");
            }
            stringBuilder.append(c);
        }
        if (bl2) {
            this.negativeSuffix = stringBuilder.toString();
        } else {
            this.negativePrefix = stringBuilder.toString();
        }
    }

    private void formatInternal(BigDecimal bigDecimal, boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        int n2;
        boolean bl2;
        if (fieldPosition == null) {
            fieldPosition = new FieldPosition(0);
        }
        int n3 = this.multiplier;
        int n4 = -1;
        boolean bl3 = bl2 = bigDecimal.signum() < 0;
        if (bl2) {
            n4 = stringBuffer.length();
            stringBuffer.append(this.negativePrefix);
            bigDecimal = bigDecimal.abs();
            n3 = this.negativePatternMultiplier;
            this.addAttribute(NumberFormat.Field.SIGN, n4, stringBuffer.length());
        } else {
            stringBuffer.append(this.positivePrefix);
        }
        int n5 = stringBuffer.length();
        int n6 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(n3));
        if (this.maximumIntegerDigits == 0 && this.maximumFractionDigits == 0) {
            bigDecimal = BigDecimal.ZERO;
            this.maximumIntegerDigits = 1;
            this.minimumIntegerDigits = 1;
        }
        bigDecimal = bigDecimal.abs();
        int n7 = this.maximumFractionDigits;
        long l = 0L;
        if (this.useExponentialNotation) {
            l = this.getExponent(bigDecimal);
            bigDecimal = bigDecimal.movePointLeft((int)l);
        }
        bigDecimal = bigDecimal.setScale(n7, 6);
        String string = bigDecimal.toPlainString();
        String string2 = null;
        String string3 = null;
        int n8 = string.lastIndexOf(45, 0);
        if (n8 > -1) {
            string = string.substring(n8 + 1);
        }
        if ((n2 = string.indexOf(46)) > -1) {
            string2 = string.substring(0, n2);
            string3 = this.useExponentialNotation ? string.substring(n2, n2 + n7) : string.substring(++n2);
        } else {
            string2 = string;
        }
        n6 = n = string2.length();
        int n9 = this.minimumIntegerDigits - n;
        if (n9 > 0) {
            n4 = Math.max(stringBuffer.length() - 1, 0);
            this.appendZero(stringBuffer, n9, this.minimumIntegerDigits);
        }
        if (this.useExponentialNotation) {
            if (n4 < 0) {
                n4 = Math.max(stringBuffer.length() - 1, 0);
            }
            this.appendDigit(string2, stringBuffer, this.groupingUsed);
        } else {
            n = string2.length();
            int n10 = Math.min(n, this.maximumIntegerDigits);
            string2 = string2.substring(n - n10);
            n6 = string2.length() + 1;
            if (this.maximumIntegerDigits > 0 && (this.minimumIntegerDigits != 0 || string2.compareTo(String.valueOf(this.symbols.getZeroDigit())) != 0)) {
                if (n4 < 0) {
                    n4 = Math.max(stringBuffer.length() - 1, 0);
                }
                this.appendDigit(string2, stringBuffer, this.groupingUsed);
            }
        }
        this.addAttribute(NumberFormat.Field.INTEGER, n4, stringBuffer.length());
        if (fieldPosition.getField() == 0 || fieldPosition.getFieldAttribute() == NumberFormat.Field.INTEGER) {
            fieldPosition.setBeginIndex(n5);
            fieldPosition.setEndIndex(n6);
        }
        this.handleFractionalPart(stringBuffer, string3, fieldPosition, bl);
        if (this.useExponentialNotation) {
            int n11;
            n4 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponential());
            this.addAttribute(NumberFormat.Field.EXPONENT_SYMBOL, n4, stringBuffer.length());
            n4 = stringBuffer.length();
            if (l < 0L) {
                stringBuffer.append(this.symbols.getMinusSign());
                l = -l;
                this.addAttribute(NumberFormat.Field.EXPONENT_SIGN, n4, stringBuffer.length());
            }
            n4 = stringBuffer.length();
            String string4 = String.valueOf(l);
            int n12 = string4.length();
            for (n11 = 0; n11 < this.minExponentDigits - n12; ++n11) {
                stringBuffer.append(this.symbols.getZeroDigit());
            }
            for (n11 = 0; n11 < n12; ++n11) {
                stringBuffer.append(string4.charAt(n11));
            }
            this.addAttribute(NumberFormat.Field.EXPONENT, n4, stringBuffer.length());
        }
        if (bl2) {
            stringBuffer.append(this.negativeSuffix);
        } else {
            stringBuffer.append(this.positiveSuffix);
        }
    }

    private void handleFractionalPart(StringBuffer stringBuffer, String string, FieldPosition fieldPosition, boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        if (this.decimalSeparatorAlwaysShown || (!bl || this.useExponentialNotation) && this.showDecimalSeparator && this.maximumFractionDigits > 0 || this.minimumFractionDigits > 0) {
            n = stringBuffer.length();
            if (this.useCurrencySeparator) {
                stringBuffer.append(this.symbols.getMonetaryDecimalSeparator());
            } else {
                stringBuffer.append(this.symbols.getDecimalSeparator());
            }
            n2 = stringBuffer.length();
            bl2 = true;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        if ((!bl || this.useExponentialNotation) && this.maximumFractionDigits > 0 || this.minimumFractionDigits > 0) {
            n4 = n3 = stringBuffer.length();
            int n5 = this.minimumFractionDigits;
            if (this.useExponentialNotation && (n5 = this.minimumIntegerDigits + this.minimumFractionDigits - stringBuffer.length()) < 0) {
                n5 = 0;
            }
            string = this.adjustTrailingZeros(string, n5);
            boolean bl4 = true;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '0') continue;
                bl4 = false;
            }
            if (!bl4 || this.minimumFractionDigits > 0) {
                this.appendDigit(string, stringBuffer, false);
                n4 = stringBuffer.length();
                bl2 = true;
                bl3 = true;
            } else if (!this.decimalSeparatorAlwaysShown) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                bl2 = false;
            } else {
                n4 = stringBuffer.length();
                bl3 = true;
            }
        }
        if (bl2) {
            this.addAttribute(NumberFormat.Field.DECIMAL_SEPARATOR, n, n2);
        }
        if (bl3) {
            this.addAttribute(NumberFormat.Field.FRACTION, n3, n4);
        }
        if (fieldPosition.getField() == 1 || fieldPosition.getFieldAttribute() == NumberFormat.Field.FRACTION) {
            fieldPosition.setBeginIndex(n3);
            fieldPosition.setEndIndex(n4);
        }
    }

    private void appendZero(StringBuffer stringBuffer, int n, int n2) {
        char c = this.symbols.getZeroDigit();
        char c2 = this.symbols.getGroupingSeparator();
        int n3 = 0;
        int n4 = n2;
        n3 = 0;
        while (n3 < n) {
            if (this.groupingSeparatorInPattern && this.groupingUsed && this.groupingSize != 0 && n4 % this.groupingSize == 0 && n3 > 0) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(c);
            ++n3;
            --n4;
        }
        if (this.groupingSeparatorInPattern && this.groupingUsed && this.groupingSize != 0 && n4 % this.groupingSize == 0) {
            stringBuffer.append(c2);
        }
    }

    private void appendDigit(String string, StringBuffer stringBuffer, boolean bl) {
        int n = this.symbols.getZeroDigit() - 48;
        char c = this.symbols.getGroupingSeparator();
        int n2 = string.length();
        int n3 = 0;
        int n4 = n2;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (bl && this.groupingSize != 0 && n4 % this.groupingSize == 0 && n3 > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append((char)(n + c2));
            ++n3;
            --n4;
        }
    }

    private long getExponent(BigDecimal bigDecimal) {
        long l = 0L;
        if (bigDecimal.signum() > 0) {
            double d = bigDecimal.doubleValue();
            l = (long)Math.floor(Math.log10(d));
            l -= l % (long)this.exponentRound;
            if (this.minimumIntegerDigits > 0) {
                l -= (long)(this.minimumIntegerDigits - 1);
            }
        }
        return l;
    }

    private String adjustTrailingZeros(String string, int n) {
        String string2;
        int n2 = string.length();
        if (n2 > n) {
            int n3 = 0;
            for (int i = n2 - 1; i > n && string.charAt(i) == '0'; --i) {
                ++n3;
            }
            string2 = string.substring(0, n2 - n3);
        } else {
            char c = this.symbols.getZeroDigit();
            CPStringBuilder cPStringBuilder = new CPStringBuilder(string);
            for (int i = n2; i < n; ++i) {
                cPStringBuilder.append(c);
            }
            string2 = cPStringBuilder.toString();
        }
        return string2;
    }

    private void addAttribute(NumberFormat.Field field, int n, int n2) {
        FieldPosition fieldPosition = new FieldPosition(field);
        fieldPosition.setBeginIndex(n);
        fieldPosition.setEndIndex(n2);
        this.attributes.add(fieldPosition);
    }

    private void setDefaultValues() {
        this.negativePrefix = String.valueOf(this.symbols.getMinusSign());
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.multiplier = 1;
        this.negativePatternMultiplier = 1;
        this.exponentRound = 1;
        this.hasNegativePrefix = false;
        this.minimumIntegerDigits = 1;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.maximumFractionDigits = 340;
        this.minExponentDigits = 0;
        this.groupingSize = 0;
        this.decimalSeparatorAlwaysShown = false;
        this.showDecimalSeparator = false;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.groupingSeparatorInPattern = false;
        this.useCurrencySeparator = false;
        this.hasFractionalPattern = false;
    }
}

