/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.Serializable;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.spi.TimeZoneNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private static final transient Properties properties = new Properties();
    private String[][] runtimeZoneStrings;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes;
    transient String[] dateFormats;
    transient String[] timeFormats;

    private static String[] getStringArray(List<ResourceBundle> list2, String string, int n) {
        return DateFormatSymbols.getStringArray(list2, string, n, null);
    }

    private static String[] getStringArray(List<ResourceBundle> list2, String string, int n, String[] stringArray) {
        int n2;
        Object[] objectArray = new String[n];
        Arrays.fill(objectArray, "");
        for (n2 = 0; n2 < list2.size(); ++n2) {
            String string2 = list2.get(n2).getString(string);
            String[] stringArray2 = string2.split("\u00ae", n);
            for (int i = 0; i < objectArray.length; ++i) {
                if (stringArray2.length <= i || stringArray2[i] == null || !((String)objectArray[i]).isEmpty() || stringArray2[i].isEmpty()) continue;
                objectArray[i] = stringArray2[i];
            }
        }
        if (stringArray != null && stringArray.length == n) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!((String)objectArray[n2]).isEmpty() || stringArray[n2] == null || stringArray[n2].isEmpty()) continue;
                objectArray[n2] = stringArray[n2];
            }
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private String[][] getZoneStrings(ResourceBundle resourceBundle, Locale locale) {
        Object[] objectArray2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            String string;
            Object object2;
            HashMap hashMap = new HashMap();
            while (true) {
                boolean bl = false;
                objectArray2 = locale.getCountry();
                String string2 = resourceBundle.getString("zoneStrings");
                String[] stringArray = string2.split("\u00a9");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    object2 = stringArray[i].split("\u00ae");
                    string = properties.getProperty(object2[0] + "." + (String)objectArray2);
                    if (string == null) {
                        string = properties.getProperty(object2[0] + ".DEFAULT");
                    }
                    if (string != null) {
                        object2[0] = string;
                    }
                    if (((String[])object2).length < 5) {
                        object = new String[5];
                        System.arraycopy(object2, 0, object, 0, ((String[])object2).length);
                        for (n = ((String[])object2).length; n < ((String[])object).length; ++n) {
                            object[n] = "";
                        }
                        object2 = object;
                    }
                    if ((object = (String[])hashMap.get(object2[0])) != null && ((String[])object).length > 1) {
                        for (n = 1; n < ((String[])object).length; ++n) {
                            if (object[n].equals("")) continue;
                            object2[n] = object[n];
                        }
                    }
                    hashMap.put(object2[0], object2);
                }
                if (resourceBundle.getLocale() == Locale.ROOT) break;
                resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", LocaleHelper.getFallbackLocale(resourceBundle.getLocale()), ClassLoader.getSystemClassLoader());
            }
            for (Object[] objectArray2 : hashMap.values()) {
                if (!((String)objectArray2[1]).equals("") || !((String)objectArray2[2]).equals("")) continue;
                for (Map.Entry entry : properties.entrySet()) {
                    String string3 = (String)entry.getValue();
                    if (!string3.equals(objectArray2[0])) continue;
                    object2 = (String)entry.getKey();
                    string = ((String)object2).substring(0, ((String)object2).indexOf("."));
                    object = properties.getProperty(string + "." + locale.getCountry());
                    if (object == null) {
                        object = properties.getProperty(string + ".DEFAULT");
                    }
                    if (object == null) continue;
                    String[] stringArray = (String[])hashMap.get(object);
                    objectArray2[1] = stringArray[1];
                    objectArray2[2] = stringArray[2];
                }
            }
            arrayList.addAll(hashMap.values());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        block8: for (TimeZoneNameProvider timeZoneNameProvider : ServiceLoader.load(TimeZoneNameProvider.class)) {
            void var8_17;
            objectArray2 = timeZoneNameProvider.getAvailableLocales();
            int n = objectArray2.length;
            boolean bl = false;
            while (var8_17 < n) {
                Locale locale2 = objectArray2[var8_17];
                if (locale2.equals(locale)) {
                    for (String string : TimeZone.getAvailableIDs()) {
                        String[] stringArray = new String[]{string, timeZoneNameProvider.getDisplayName(string, false, 1, locale), timeZoneNameProvider.getDisplayName(string, false, 0, locale), timeZoneNameProvider.getDisplayName(string, true, 1, locale), timeZoneNameProvider.getDisplayName(string, true, 0, locale)};
                        arrayList.add(stringArray);
                    }
                    continue block8;
                }
                ++var8_17;
            }
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private String[] formatsForKey(ResourceBundle resourceBundle, String string) {
        String[] stringArray = new String[formatPrefixes.length];
        for (int i = 0; i < formatPrefixes.length; ++i) {
            stringArray[i] = resourceBundle.getString(formatPrefixes[i] + string);
        }
        return stringArray;
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, classLoader);
        arrayList.add(resourceBundle);
        Locale locale2 = resourceBundle.getLocale();
        while (locale2 != Locale.ROOT) {
            resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", LocaleHelper.getFallbackLocale(locale2), classLoader);
            arrayList.add(resourceBundle);
            locale2 = resourceBundle.getLocale();
        }
        this.ampms = DateFormatSymbols.getStringArray(arrayList, "ampms", 2);
        this.eras = DateFormatSymbols.getStringArray(arrayList, "eras", 2);
        this.localPatternChars = resourceBundle.getString("localPatternChars");
        this.months = DateFormatSymbols.getStringArray(arrayList, "months", 13);
        this.shortMonths = DateFormatSymbols.getStringArray(arrayList, "shortMonths", 13, this.months);
        this.weekdays = DateFormatSymbols.getStringArray(arrayList, "weekdays", 8);
        this.shortWeekdays = DateFormatSymbols.getStringArray(arrayList, "shortWeekdays", 8, this.weekdays);
        this.dateFormats = this.formatsForKey(resourceBundle, "DateFormat");
        this.timeFormats = this.formatsForKey(resourceBundle, "TimeFormat");
        this.runtimeZoneStrings = this.getZoneStrings(resourceBundle, locale);
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        if (this.zoneStrings != null) {
            return this.zoneStrings;
        }
        return this.runtimeZoneStrings;
    }

    public void setAmPmStrings(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.ampms = stringArray;
    }

    public void setEras(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.eras = stringArray;
    }

    public void setLocalPatternChars(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.localPatternChars = string;
    }

    public void setMonths(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.months = stringArray;
    }

    public void setShortMonths(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.shortMonths = stringArray;
    }

    public void setShortWeekdays(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.shortWeekdays = stringArray;
    }

    public void setWeekdays(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.weekdays = stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.zoneStrings = stringArray;
    }

    private static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
            return object.equals(object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (DateFormatSymbols.equals(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Object[])) {
            return object.hashCode();
        }
        Object[] objectArray = (Object[])object;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n = 37 * DateFormatSymbols.hashCode(objectArray[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return DateFormatSymbols.equals(this.ampms, dateFormatSymbols.ampms) && DateFormatSymbols.equals(this.eras, dateFormatSymbols.eras) && DateFormatSymbols.equals(this.localPatternChars, dateFormatSymbols.localPatternChars) && DateFormatSymbols.equals(this.months, dateFormatSymbols.months) && DateFormatSymbols.equals(this.shortMonths, dateFormatSymbols.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, dateFormatSymbols.weekdays) && DateFormatSymbols.equals(this.zoneStrings, dateFormatSymbols.zoneStrings);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault());
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        try {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            return dateFormatSymbols;
        }
        catch (MissingResourceException missingResourceException) {
            block2: for (DateFormatSymbolsProvider dateFormatSymbolsProvider : ServiceLoader.load(DateFormatSymbolsProvider.class)) {
                for (Locale locale2 : dateFormatSymbolsProvider.getAvailableLocales()) {
                    if (!locale2.equals(locale)) continue;
                    DateFormatSymbols dateFormatSymbols = dateFormatSymbolsProvider.getInstance(locale);
                    if (dateFormatSymbols == null) continue block2;
                    return dateFormatSymbols;
                }
            }
            return DateFormatSymbols.getInstance(LocaleHelper.getFallbackLocale(locale));
        }
    }

    static {
        try {
            properties.load(DateFormatSymbols.class.getResourceAsStream("metazones.properties"));
        }
        catch (IOException iOException) {
            System.out.println("Failed to load weeks resource: " + iOException);
        }
        formatPrefixes = new String[]{"full", "long", "medium", "short"};
    }
}

