/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import java.text.CollationKey;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    int decmp = 1;
    int strength = 2;

    protected Collator() {
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Collator)) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.decmp == collator.decmp && this.strength == collator.strength;
    }

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        return LocaleHelper.getCollatorLocales();
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public static Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            return new RuleBasedCollator(resourceBundle.getString("collation_rules"));
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ParseException parseException) {
            throw (InternalError)new InternalError().initCause(parseException);
        }
        block5: for (CollatorProvider collatorProvider : ServiceLoader.load(CollatorProvider.class)) {
            for (Locale locale2 : collatorProvider.getAvailableLocales()) {
                if (!locale2.equals(locale)) continue;
                Collator collator = collatorProvider.getInstance(locale);
                if (collator == null) continue block5;
                return collator;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            try {
                return new RuleBasedCollator("<0<1<2<3<4<5<6<7<8<9<A,a<b,B<c,C<d,D<e,E<f,F<g,G<h,H<i,I<j,J<k,K<l,L<m,M<n,N<o,O<p,P<q,Q<r,R<s,S<t,T<u,U<v,V<w,W<x,X<y,Y<z,Z");
            }
            catch (ParseException parseException) {
                throw (InternalError)new InternalError().initCause(parseException);
            }
        }
        return Collator.getInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.decmp = n;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        this.strength = n;
    }
}

