/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import gnu.java.text.CharacterBreakIterator;
import gnu.java.text.LineBreakIterator;
import gnu.java.text.SentenceBreakIterator;
import gnu.java.text.WordBreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract int current();

    public abstract int first();

    public abstract int following(int var1);

    public static synchronized Locale[] getAvailableLocales() {
        Locale[] localeArray = new Locale[]{Locale.US};
        return localeArray;
    }

    private static BreakIterator getInstance(String string, Locale locale) {
        String string2;
        Object object;
        try {
            object = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            string2 = ((ResourceBundle)object).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        try {
            object = Class.forName(string2);
            return (BreakIterator)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        BreakIterator breakIterator = BreakIterator.getInstance("CharacterIterator", locale);
        if (breakIterator != null) {
            return breakIterator;
        }
        block0: for (BreakIteratorProvider breakIteratorProvider : ServiceLoader.load(BreakIteratorProvider.class)) {
            for (Locale locale2 : breakIteratorProvider.getAvailableLocales()) {
                if (!locale2.equals(locale)) continue;
                BreakIterator breakIterator2 = breakIteratorProvider.getCharacterInstance(locale);
                if (breakIterator2 == null) continue block0;
                return breakIterator2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new CharacterBreakIterator();
        }
        return BreakIterator.getCharacterInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        BreakIterator breakIterator = BreakIterator.getInstance("LineIterator", locale);
        if (breakIterator != null) {
            return breakIterator;
        }
        block0: for (BreakIteratorProvider breakIteratorProvider : ServiceLoader.load(BreakIteratorProvider.class)) {
            for (Locale locale2 : breakIteratorProvider.getAvailableLocales()) {
                if (!locale2.equals(locale)) continue;
                BreakIterator breakIterator2 = breakIteratorProvider.getLineInstance(locale);
                if (breakIterator2 == null) continue block0;
                return breakIterator2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new LineBreakIterator();
        }
        return BreakIterator.getLineInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        BreakIterator breakIterator = BreakIterator.getInstance("SentenceIterator", locale);
        if (breakIterator != null) {
            return breakIterator;
        }
        block0: for (BreakIteratorProvider breakIteratorProvider : ServiceLoader.load(BreakIteratorProvider.class)) {
            for (Locale locale2 : breakIteratorProvider.getAvailableLocales()) {
                if (!locale2.equals(locale)) continue;
                BreakIterator breakIterator2 = breakIteratorProvider.getSentenceInstance(locale);
                if (breakIterator2 == null) continue block0;
                return breakIterator2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new SentenceBreakIterator();
        }
        return BreakIterator.getSentenceInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public abstract CharacterIterator getText();

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        BreakIterator breakIterator = BreakIterator.getInstance("WordIterator", locale);
        if (breakIterator != null) {
            return breakIterator;
        }
        block0: for (BreakIteratorProvider breakIteratorProvider : ServiceLoader.load(BreakIteratorProvider.class)) {
            for (Locale locale2 : breakIteratorProvider.getAvailableLocales()) {
                if (!locale2.equals(locale)) continue;
                BreakIterator breakIterator2 = breakIteratorProvider.getWordInstance(locale);
                if (breakIterator2 == null) continue block0;
                return breakIterator2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new WordBreakIterator();
        }
        return BreakIterator.getWordInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public boolean isBoundary(int n) {
        if (n == 0) {
            return true;
        }
        return this.following(n - 1) == n;
    }

    public abstract int last();

    public abstract int next();

    public abstract int next(int var1);

    public int preceding(int n) {
        if (this.following(n) == -1) {
            this.last();
        }
        while (this.previous() >= n) {
        }
        return this.current();
    }

    public abstract int previous();

    public void setText(String string) {
        this.setText(new StringCharacterIterator(string));
    }

    public abstract void setText(CharacterIterator var1);
}

