/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;

public final class Bidi {
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    private static final int LTOR = 1;
    private static final int RTOL = 2;
    private char[] text;
    private int textOffset;
    private byte[] embeddings;
    private int embeddingOffset;
    private int length;
    private int flags;
    private int baseEmbedding;
    private byte[] types;
    private byte[] levels;
    private ArrayList formatterIndices;
    private int[] runs;
    private int resultFlags;

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
        this.flags = object == TextAttribute.RUN_DIRECTION_LTR ? 0 : (object == TextAttribute.RUN_DIRECTION_RTL ? 1 : -2);
        NumericShaper numericShaper = null;
        object = attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
        if (object instanceof NumericShaper) {
            numericShaper = (NumericShaper)object;
        }
        char[] cArray = new char[attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()];
        this.embeddings = new byte[this.text.length];
        this.embeddingOffset = 0;
        this.length = cArray.length;
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = attributedCharacterIterator.current();
            object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            if (!(object instanceof Integer)) continue;
            int n = (Integer)object;
            byte by = n < -62 || n > 62 ? (byte)0 : (byte)n;
            this.embeddings[i] = by;
        }
        if (numericShaper != null) {
            numericShaper.shape(this.text, 0, this.length);
        }
        this.runBidi();
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (n4 != -2 && n4 != -1 && n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + n4);
        }
        this.text = cArray;
        this.textOffset = n;
        this.embeddings = byArray;
        this.embeddingOffset = n2;
        this.length = n3;
        this.flags = n4;
        this.runBidi();
    }

    public Bidi(String string, int n) {
        if (n != -2 && n != -1 && n != 0 && n != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + n);
        }
        this.text = string.toCharArray();
        this.textOffset = 0;
        this.embeddings = null;
        this.embeddingOffset = 0;
        this.length = string.length();
        this.flags = n;
        this.runBidi();
    }

    private void computeTypes() {
        this.types = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.types[i] = Character.getDirectionality(this.text[this.textOffset + i]);
        }
    }

    private int computeParagraphEmbeddingLevel() {
        if (this.flags == 0 || this.flags == 1) {
            return this.flags;
        }
        for (int i = 0; i < this.length; ++i) {
            byte by = this.types[i];
            if (by == 0) {
                return 0;
            }
            if (by != 1 && by != 1) continue;
            return 1;
        }
        return this.flags == -2 ? 0 : 1;
    }

    private void computeExplicitLevels() {
        int n;
        int n2;
        int n3;
        int n4;
        this.levels = new byte[this.length];
        int n5 = this.baseEmbedding;
        int n6 = -1;
        byte[] byArray = new byte[62];
        int n7 = 0;
        for (n4 = 0; n4 < this.length; ++n4) {
            if (this.embeddings != null && this.embeddings[this.embeddingOffset + n4] != 0) {
                n5 = this.embeddings[this.embeddingOffset + n4];
                if (n5 < 0) {
                    n6 = (n5 = (byte)(-n5)) % 2 == 0 ? 0 : 1;
                    continue;
                }
                n6 = -1;
                continue;
            }
            n3 = 0;
            n2 = 1;
            switch (this.types[n4]) {
                case 14: 
                case 15: {
                    n3 = 1;
                }
                case 16: 
                case 17: {
                    n = n3 != 0 ? (int)((byte)((n5 & 0xFFFFFFFE) + 2)) : (int)((byte)(n5 + 1 | 1));
                    if (n >= 62) break;
                    if (n6 != -1) {
                        n5 = (byte)(n5 | 0xFFFFFF80);
                    }
                    byArray[n7++] = n5;
                    n5 = n;
                    if (this.types[n4] == 15) {
                        n6 = 0;
                        break;
                    }
                    if (this.types[n4] == 17) {
                        n6 = 1;
                        break;
                    }
                    n6 = -1;
                    break;
                }
                case 18: {
                    if (n7 == 0) break;
                    n = byArray[--n7];
                    n5 = (byte)(n & 0x7F);
                    if (n < 0) {
                        n6 = (n & 1) == 0 ? 0 : 1;
                        break;
                    }
                    n6 = -1;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.levels[n4] = n5;
            if (n2 != 0) {
                if (this.formatterIndices == null) {
                    this.formatterIndices = new ArrayList();
                }
                this.formatterIndices.add(n4);
                continue;
            }
            if (n6 == -1) continue;
            this.types[n4] = n6;
        }
        if (this.formatterIndices == null) {
            return;
        }
        n4 = 0;
        n3 = 0;
        n2 = this.formatterIndices.size();
        for (n = 0; n <= n2; ++n) {
            int n8 = n == n2 ? this.length : (Integer)this.formatterIndices.get(n);
            int n9 = n8 - n3;
            System.arraycopy(this.levels, n3, this.levels, n4, n9);
            System.arraycopy(this.types, n3, this.types, n4, n9);
            n4 += n9;
            n3 = n8 + 1;
        }
        this.length -= this.formatterIndices.size();
    }

    private void computeRuns() {
        int n;
        int n2 = 0;
        int n3 = this.baseEmbedding;
        for (n = 0; n < this.length; ++n) {
            if (this.levels[n] == n3) continue;
            n3 = this.levels[n];
            ++n2;
        }
        if (this.runs == null || this.runs.length != n2 + 1) {
            this.runs = new int[n2 + 1];
        }
        n = 0;
        int n4 = 0;
        n3 = this.baseEmbedding;
        for (int i = 0; i < this.length; ++i) {
            if (this.levels[i] == n3) continue;
            this.runs[n++] = n4;
            n4 = i;
            n3 = this.levels[i];
        }
        this.runs[n++] = n4;
    }

    private void resolveWeakTypes() {
        int n = this.getRunCount();
        int n2 = this.baseEmbedding;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getRunStart(i);
            int n4 = this.getRunLimit(i);
            int n5 = this.getRunLevel(i);
            byte by = Math.max(n2, n5) % 2 == 0 ? (byte)0 : 1;
            int n6 = i == n - 1 ? this.baseEmbedding : this.getRunLevel(i + 1);
            byte by2 = Math.max(n5, n6) % 2 == 0 ? (byte)0 : 1;
            byte by3 = by;
            byte by4 = by;
            for (int j = n3; j < n4; ++j) {
                byte by5;
                byte by6 = by5 = j == n4 - 1 ? by2 : this.types[j + 1];
                if (this.types[j] == 8) {
                    this.types[j] = by3;
                } else {
                    by3 = this.types[j];
                }
                if (this.types[j] == 3) {
                    if (by4 == 2) {
                        this.types[j] = 6;
                    }
                } else if (this.types[j] == 0 || this.types[j] == 1 || this.types[j] == 2) {
                    by4 = this.types[j];
                }
                if (this.types[j] == 2) {
                    this.types[j] = 1;
                }
                if (by3 == 3 && by5 == 3) {
                    if (this.types[j] == 4 || this.types[j] == 7) {
                        this.types[j] = by5;
                    }
                } else if (by3 == 6 && by5 == 6 && this.types[j] == 7) {
                    this.types[j] = by5;
                }
                if (this.types[j] == 5 || this.types[j] == 9) {
                    if (by3 == 3) {
                        this.types[j] = by3;
                    } else {
                        int n7;
                        for (n7 = j + 1; n7 < n4 && (this.types[n7] == 5 || this.types[n7] == 9); ++n7) {
                        }
                        if (n7 < n4 && this.types[n7] == 3) {
                            for (int k = j; k < n7; ++k) {
                                this.types[k] = 3;
                            }
                        }
                    }
                }
                if (this.types[j] == 5 || this.types[j] == 5 || this.types[j] == 7 || this.types[j] == 9) {
                    this.types[j] = 13;
                }
                if (by4 != 0 || this.types[j] != 3) continue;
                this.types[j] = by4;
            }
            n2 = n5;
        }
    }

    private void resolveNeutralTypes() {
        int n = this.getRunCount();
        int n2 = this.baseEmbedding;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getRunStart(i);
            int n4 = this.getRunLimit(i);
            int n5 = this.getRunLevel(i);
            int n6 = n5 % 2 == 0 ? 0 : 1;
            int n7 = Math.max(n2, n5) % 2 == 0 ? 0 : 1;
            int n8 = i == n - 1 ? this.baseEmbedding : this.getRunLevel(i + 1);
            byte by = Math.max(n5, n8) % 2 == 0 ? (byte)0 : 1;
            int n9 = n7;
            int n10 = -1;
            for (int j = n3; j <= n4; ++j) {
                int n11 = -1;
                byte by2 = j == n4 ? by : this.types[j];
                switch (by2) {
                    case 0: {
                        n11 = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n11 = 1;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (n10 != -1) break;
                        n10 = j;
                    }
                }
                if (n11 == -1) continue;
                if (n10 != -1) {
                    int n12 = n9 == n11 ? n9 : n6;
                    for (int k = n10; k < j; ++k) {
                        this.types[k] = n12;
                    }
                }
                n9 = n11;
                n10 = -1;
            }
            n2 = n5;
        }
    }

    private void resolveImplicitLevels() {
        for (int i = 0; i < this.length; ++i) {
            if ((this.levels[i] & 1) == 0) {
                if (this.types[i] == 1) {
                    int n = i;
                    this.levels[n] = (byte)(this.levels[n] + 1);
                } else if (this.types[i] == 6 || this.types[i] == 3) {
                    int n = i;
                    this.levels[n] = (byte)(this.levels[n] + 2);
                }
            } else if (this.types[i] == 0 || this.types[i] == 6 || this.types[i] == 3) {
                int n = i;
                this.levels[n] = (byte)(this.levels[n] + 1);
            }
            this.resultFlags |= 1 << (this.levels[i] & 1);
        }
        this.resultFlags |= 1 << this.baseEmbedding;
    }

    private void reinsertFormattingCodes() {
        if (this.formatterIndices == null) {
            return;
        }
        int n = this.length;
        int n2 = this.levels.length;
        for (int i = this.formatterIndices.size() - 1; i >= 0; --i) {
            int n3 = (Integer)this.formatterIndices.get(i);
            int n4 = n2 - n3 - 1;
            n2 = n3;
            n -= n4;
            if (n3 + 1 < this.levels.length) {
                System.arraycopy(this.levels, n, this.levels, n3 + 1, n4);
            }
            int n5 = n2 == this.levels.length - 1 ? this.baseEmbedding : this.levels[n2 + 1];
            int n6 = n == 0 ? this.baseEmbedding : this.levels[n];
            this.levels[n2] = (byte)Math.max(n6, n5);
        }
        this.length = this.levels.length;
    }

    private void runBidi() {
        this.computeTypes();
        this.baseEmbedding = this.computeParagraphEmbeddingLevel();
        this.computeExplicitLevels();
        this.computeRuns();
        this.resolveWeakTypes();
        this.resolveNeutralTypes();
        this.resolveImplicitLevels();
        this.types = null;
        this.reinsertFormattingCodes();
        this.computeRuns();
    }

    public boolean baseIsLeftToRight() {
        return this.baseEmbedding == 0;
    }

    public Bidi createLineBidi(int n, int n2) {
        int n3 = this.getLevelAt(n);
        int n4 = n3 % 2 == 0 ? 0 : 1;
        return new Bidi(this.text, this.textOffset + n, this.embeddings, this.embeddingOffset + n, n2 - n, n4);
    }

    public int getBaseLevel() {
        return this.baseEmbedding;
    }

    public int getLength() {
        return this.length;
    }

    public int getLevelAt(int n) {
        if (n < 0 || n >= this.length) {
            return this.getBaseLevel();
        }
        return this.levels[n];
    }

    public int getRunCount() {
        return this.runs.length;
    }

    public int getRunLevel(int n) {
        return this.levels[this.runs[n]];
    }

    public int getRunLimit(int n) {
        if (n == this.runs.length - 1) {
            return this.length;
        }
        return this.runs[n + 1];
    }

    public int getRunStart(int n) {
        return this.runs[n];
    }

    public boolean isLeftToRight() {
        return this.resultFlags == 1;
    }

    public boolean isMixed() {
        return this.resultFlags == 3;
    }

    public boolean isRightToLeft() {
        return this.resultFlags == 2;
    }

    public String toString() {
        return "Bidi Bidi Bidi I like you, Buck!";
    }

    public static void reorderVisually(byte[] byArray, int n, Object[] objectArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        int n6 = 63;
        for (n4 = 0; n4 < n3; ++n4) {
            byArray2[n4] = byArray[n + n4];
            n5 = Math.max(byArray2[n4], n5);
            if (byArray2[n4] % 2 == 0) continue;
            n6 = Math.min(n6, byArray2[n4]);
        }
        block1: for (n4 = n5; n4 >= n6; --n4) {
            int n7 = 0;
            while (n7 < n3) {
                int n8;
                while (n7 < n3 && byArray2[n7] < n4) {
                    ++n7;
                }
                if (n7 == n3) continue block1;
                for (n8 = n7 + 1; n8 < n3 && byArray2[n8] >= n4; ++n8) {
                }
                for (int i = 0; i < (n8 - n7) / 2; ++i) {
                    byte by = byArray2[n8 - i - 1];
                    byArray2[n8 - i - 1] = byArray2[n7 + i];
                    byArray2[n7 + i] = by;
                    Object object = objectArray[n2 + n8 - i - 1];
                    objectArray[n2 + n8 - i - 1] = objectArray[n2 + n7 + i];
                    objectArray[n2 + n7 + i] = object;
                }
                n7 = n8 + 1;
            }
        }
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            byte by = Character.getDirectionality(cArray[i]);
            if (by == 0 || by == 3 || by == 4 || by == 5 || by == 6 || by == 7 || by == 11 || by == 12 || by == 10) continue;
            return true;
        }
        return false;
    }
}

