/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateFactory {
    private static final String CERTIFICATE_FACTORY = "CertificateFactory";
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        Provider[] providerArray = Security.getProviders();
        CertificateException certificateException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return CertificateFactory.getInstance(string, providerArray[i]);
            }
            catch (CertificateException certificateException2) {
                certificateException = certificateException2;
                continue;
            }
        }
        if (certificateException != null) {
            throw certificateException;
        }
        throw new CertificateException(string);
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return CertificateFactory.getInstance(string, provider);
    }

    public static final CertificateFactory getInstance(String string, Provider provider) throws CertificateException {
        Throwable throwable;
        try {
            Object object = Engine.getInstance(CERTIFICATE_FACTORY, string, provider);
            return new CertificateFactory((CertificateFactorySpi)object, provider, string);
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throwable = noSuchAlgorithmException;
        }
        CertificateException certificateException = new CertificateException(string);
        certificateException.initCause(throwable);
        throw certificateException;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Collection<? extends Certificate> generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection<? extends CRL> generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }

    public final CertPath generateCertPath(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream);
    }

    public final CertPath generateCertPath(InputStream inputStream, String string) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream, string);
    }

    public final CertPath generateCertPath(List<? extends Certificate> list2) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(list2);
    }

    public final Iterator<String> getCertPathEncodings() {
        return this.certFacSpi.engineGetCertPathEncodings();
    }
}

