/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CertPath
implements Serializable {
    private static final long serialVersionUID = 6068470306649138683L;
    private final String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator<String> getEncodings();

    public boolean equals(Object object) {
        if (!(object instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)object;
        return this.type.equals(certPath.type) && this.getCertificates().equals(certPath.getCertificates());
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.getCertificates().hashCode();
    }

    public String toString() {
        List<? extends Certificate> list2 = this.getCertificates();
        int n = list2.size();
        int n2 = 0;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.type);
        cPStringBuilder.append(" Cert Path: length = ").append(n).append(".\n[\n");
        while (--n >= 0) {
            cPStringBuilder.append(list2.get(n2++)).append('\n');
        }
        return cPStringBuilder.append("\n]").toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List<? extends Certificate> getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw (ObjectStreamException)new NotSerializableException("java.security.cert.CertPath: " + this.type).initCause(certificateEncodingException);
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private static final long serialVersionUID = 3015633072427920915L;
        private final String type;
        private final byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return CertificateFactory.getInstance(this.type).generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                throw (ObjectStreamException)new NotSerializableException("java.security.cert.CertPath: " + this.type).initCause(certificateException);
            }
        }
    }
}

