/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureClassLoader
extends ClassLoader {
    private final HashMap<CodeSource, ProtectionDomain> protectionDomainCache = new HashMap();

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    protected SecureClassLoader() {
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return super.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, CodeSource codeSource) {
        return super.defineClass(string, byteBuffer, this.getProtectionDomain(codeSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        ProtectionDomain protectionDomain = null;
        if (codeSource != null) {
            HashMap<CodeSource, ProtectionDomain> hashMap = this.protectionDomainCache;
            synchronized (hashMap) {
                protectionDomain = this.protectionDomainCache.get(codeSource);
            }
            if (protectionDomain == null) {
                protectionDomain = new ProtectionDomain(codeSource, this.getPermissions(codeSource), this, null);
                hashMap = this.protectionDomainCache;
                synchronized (hashMap) {
                    ProtectionDomain protectionDomain2 = this.protectionDomainCache.get(codeSource);
                    if (protectionDomain2 == null) {
                        this.protectionDomainCache.put(codeSource, protectionDomain);
                    } else {
                        protectionDomain = protectionDomain2;
                    }
                }
            }
        }
        return protectionDomain;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Policy policy = Policy.getCurrentPolicy();
        return policy.getPermissions(codeSource);
    }
}

